/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AggregateRating;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.RatingImpl;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Integer;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class AggregateRatingImpl
extends RatingImpl
implements AggregateRating {
    private static final ImmutableSet<String> PROPERTY_SET = AggregateRatingImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/bestRating");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/itemReviewed");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/ratingCount");
        builder.add((Object)"http://schema.org/ratingValue");
        builder.add((Object)"http://schema.org/reviewCount");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/worstRating");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public AggregateRatingImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/AggregateRating";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getItemReviewedList() {
        return this.getProperty("http://schema.org/itemReviewed");
    }

    @Override
    public ImmutableList<SchemaOrgType> getRatingCountList() {
        return this.getProperty("http://schema.org/ratingCount");
    }

    @Override
    public ImmutableList<SchemaOrgType> getReviewCountList() {
        return this.getProperty("http://schema.org/reviewCount");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<AggregateRating.Builder>
    implements AggregateRating.Builder {
        BuilderImpl() {
        }

        @Override
        public AggregateRating.Builder addAdditionalType(URL value) {
            return (AggregateRating.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public AggregateRating.Builder addAdditionalType(String value) {
            return (AggregateRating.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public AggregateRating.Builder addAlternateName(Text value) {
            return (AggregateRating.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public AggregateRating.Builder addAlternateName(String value) {
            return (AggregateRating.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public AggregateRating.Builder addBestRating(Number value) {
            return (AggregateRating.Builder)this.addProperty("http://schema.org/bestRating", value);
        }

        @Override
        public AggregateRating.Builder addBestRating(Text value) {
            return (AggregateRating.Builder)this.addProperty("http://schema.org/bestRating", value);
        }

        @Override
        public AggregateRating.Builder addBestRating(String value) {
            return (AggregateRating.Builder)this.addProperty("http://schema.org/bestRating", Text.of(value));
        }

        @Override
        public AggregateRating.Builder addDescription(Text value) {
            return (AggregateRating.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public AggregateRating.Builder addDescription(String value) {
            return (AggregateRating.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public AggregateRating.Builder addImage(ImageObject value) {
            return (AggregateRating.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public AggregateRating.Builder addImage(ImageObject.Builder value) {
            return (AggregateRating.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public AggregateRating.Builder addImage(URL value) {
            return (AggregateRating.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public AggregateRating.Builder addImage(String value) {
            return (AggregateRating.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public AggregateRating.Builder addItemReviewed(Thing value) {
            return (AggregateRating.Builder)this.addProperty("http://schema.org/itemReviewed", value);
        }

        @Override
        public AggregateRating.Builder addItemReviewed(Thing.Builder value) {
            return (AggregateRating.Builder)this.addProperty("http://schema.org/itemReviewed", value.build());
        }

        @Override
        public AggregateRating.Builder addItemReviewed(String value) {
            return (AggregateRating.Builder)this.addProperty("http://schema.org/itemReviewed", Text.of(value));
        }

        @Override
        public AggregateRating.Builder addMainEntityOfPage(CreativeWork value) {
            return (AggregateRating.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public AggregateRating.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (AggregateRating.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public AggregateRating.Builder addMainEntityOfPage(URL value) {
            return (AggregateRating.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public AggregateRating.Builder addMainEntityOfPage(String value) {
            return (AggregateRating.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public AggregateRating.Builder addName(Text value) {
            return (AggregateRating.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public AggregateRating.Builder addName(String value) {
            return (AggregateRating.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public AggregateRating.Builder addPotentialAction(Action value) {
            return (AggregateRating.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public AggregateRating.Builder addPotentialAction(Action.Builder value) {
            return (AggregateRating.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public AggregateRating.Builder addPotentialAction(String value) {
            return (AggregateRating.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public AggregateRating.Builder addRatingCount(Integer value) {
            return (AggregateRating.Builder)this.addProperty("http://schema.org/ratingCount", value);
        }

        @Override
        public AggregateRating.Builder addRatingCount(String value) {
            return (AggregateRating.Builder)this.addProperty("http://schema.org/ratingCount", Text.of(value));
        }

        @Override
        public AggregateRating.Builder addRatingValue(Text value) {
            return (AggregateRating.Builder)this.addProperty("http://schema.org/ratingValue", value);
        }

        @Override
        public AggregateRating.Builder addRatingValue(String value) {
            return (AggregateRating.Builder)this.addProperty("http://schema.org/ratingValue", Text.of(value));
        }

        @Override
        public AggregateRating.Builder addReviewCount(Integer value) {
            return (AggregateRating.Builder)this.addProperty("http://schema.org/reviewCount", value);
        }

        @Override
        public AggregateRating.Builder addReviewCount(String value) {
            return (AggregateRating.Builder)this.addProperty("http://schema.org/reviewCount", Text.of(value));
        }

        @Override
        public AggregateRating.Builder addSameAs(URL value) {
            return (AggregateRating.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public AggregateRating.Builder addSameAs(String value) {
            return (AggregateRating.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public AggregateRating.Builder addUrl(URL value) {
            return (AggregateRating.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public AggregateRating.Builder addUrl(String value) {
            return (AggregateRating.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public AggregateRating.Builder addWorstRating(Number value) {
            return (AggregateRating.Builder)this.addProperty("http://schema.org/worstRating", value);
        }

        @Override
        public AggregateRating.Builder addWorstRating(Text value) {
            return (AggregateRating.Builder)this.addProperty("http://schema.org/worstRating", value);
        }

        @Override
        public AggregateRating.Builder addWorstRating(String value) {
            return (AggregateRating.Builder)this.addProperty("http://schema.org/worstRating", Text.of(value));
        }

        @Override
        public AggregateRating.Builder addDetailedDescription(Article value) {
            return (AggregateRating.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public AggregateRating.Builder addDetailedDescription(Article.Builder value) {
            return (AggregateRating.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public AggregateRating.Builder addDetailedDescription(String value) {
            return (AggregateRating.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public AggregateRating.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (AggregateRating.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public AggregateRating.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (AggregateRating.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public AggregateRating.Builder addPopularityScore(String value) {
            return (AggregateRating.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public AggregateRating build() {
            return new AggregateRatingImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

