/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.schemaorg.BaseTypeImpl;
import com.google.schemaorg.JsonLdContext;
import com.google.schemaorg.JsonLdNode;
import com.google.schemaorg.SchemaOrgException;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import java.util.Collection;
import javax.annotation.Nullable;

public abstract class SchemaOrgTypeImpl
extends BaseTypeImpl
implements SchemaOrgType,
JsonLdNode {
    private final ImmutableListMultimap<String, Thing> reverseMap;

    public SchemaOrgTypeImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties);
        this.reverseMap = ImmutableListMultimap.copyOf(reverseMap);
    }

    @Override
    public boolean containsJsonLdId() {
        return this.containsProperty("@id");
    }

    @Override
    public ImmutableList<ValueType> getJsonLdContextList() {
        return this.getPropertyList("@context");
    }

    @Override
    @Nullable
    public String getJsonLdId() throws SchemaOrgException {
        ValueType value = this.getSingleValueProperty("@id");
        if (value == null) {
            return null;
        }
        return ((Text)value).getValue();
    }

    @Override
    public ImmutableMultimap<String, Thing> getJsonLdReverseMap() {
        return this.reverseMap;
    }

    @Override
    public abstract String getFullTypeName();

    @Override
    public abstract boolean includesProperty(String var1);

    @Override
    public boolean contentEquals(ValueType o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SchemaOrgTypeImpl) {
            if (this.getClass() != o.getClass()) {
                return false;
            }
            SchemaOrgTypeImpl that = (SchemaOrgTypeImpl)o;
            if (!SchemaOrgTypeImpl.multimapContentEquals(this.getAllProperties(), that.getAllProperties())) {
                return false;
            }
            return SchemaOrgTypeImpl.multimapContentEquals(this.getJsonLdReverseMap(), that.getJsonLdReverseMap());
        }
        return false;
    }

    private static <T extends ValueType> boolean multimapContentEquals(Multimap<String, T> m1, Multimap<String, T> m2) {
        if (!m1.keySet().equals(m2.keySet())) {
            return false;
        }
        for (String key : m1.keySet()) {
            Object[] m1Values = m1.get((Object)key).toArray();
            Object[] m2Values = m2.get((Object)key).toArray();
            if (m2Values.length != m1Values.length) {
                return false;
            }
            for (int i = 0; i < m1Values.length; ++i) {
                if (((ValueType)m1Values[i]).contentEquals((ValueType)m2Values[i])) continue;
                return false;
            }
        }
        return true;
    }

    private <T> ImmutableList<T> getTransformedPropertyList(String name, Class<T> clazz) {
        Function transformFunc = new Function<ValueType, T>(){

            public T apply(ValueType input) {
                return input;
            }
        };
        return ImmutableList.copyOf((Collection)Lists.transform(this.getPropertyList(name), (Function)transformFunc));
    }

    @Override
    public ImmutableList<SchemaOrgType> getProperty(String name) {
        return this.getTransformedPropertyList(name, SchemaOrgType.class);
    }

    public static abstract class BuilderImpl<T extends SchemaOrgType.Builder & JsonLdNode.Builder>
    extends BaseTypeImpl.BuilderImpl<T>
    implements SchemaOrgType.Builder,
    JsonLdNode.Builder {
        protected final Multimap<String, Thing> reverseMap = LinkedListMultimap.create();

        public T addJsonLdContext(@Nullable JsonLdContext value) {
            return (T)((SchemaOrgType.Builder)this.addPropertyValue("@context", value));
        }

        public T addJsonLdContext(@Nullable JsonLdContext.Builder builder) {
            return (T)((SchemaOrgType.Builder)this.addPropertyValue("@context", builder == null ? null : builder.build()));
        }

        public T setJsonLdId(@Nullable String value) {
            if (value == null) {
                this.setSingleValueProperty("@id", null);
            }
            return (T)((SchemaOrgType.Builder)this.setSingleValueProperty("@id", Text.of(value)));
        }

        public T setJsonLdReverse(String property, Thing obj) {
            Preconditions.checkNotNull((Object)property, (Object)"property is null");
            Preconditions.checkNotNull((Object)obj, (Object)"object is null");
            this.reverseMap.put((Object)property, (Object)obj);
            return (T)this;
        }

        public T setJsonLdReverse(String property, Thing.Builder builder) {
            Preconditions.checkNotNull((Object)builder, (Object)"builder is null");
            return this.setJsonLdReverse(property, builder.build());
        }

        public T addProperty(String name, SchemaOrgType value) {
            Preconditions.checkNotNull((Object)value, (Object)"value is null");
            return (T)((SchemaOrgType.Builder)this.addPropertyValue(name, value));
        }

        public T addProperty(String name, Thing.Builder builder) {
            Preconditions.checkNotNull((Object)builder, (Object)"value is null");
            return (T)((SchemaOrgType.Builder)this.addPropertyValue(name, builder.build()));
        }

        public T addProperty(String name, String value) {
            Preconditions.checkNotNull((Object)value, (Object)"value is null");
            return (T)((SchemaOrgType.Builder)this.addPropertyValue(name, Text.of(value)));
        }
    }
}

