/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.google.schemaorg.EnumValues;
import com.google.schemaorg.JsonLdContext;
import com.google.schemaorg.JsonLdFactory;
import com.google.schemaorg.JsonLdSyntaxException;
import com.google.schemaorg.NullValue;
import com.google.schemaorg.SchemaOrgException;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.BooleanEnum;
import com.google.schemaorg.core.CoreFactory;
import com.google.schemaorg.core.Enumeration;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.DataType;
import com.google.schemaorg.core.datatype.Float;
import com.google.schemaorg.core.datatype.Integer;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.goog.GoogFactory;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class JsonLdSerializer {
    private static final Type thingTypeToken = new TypeToken<List<? extends Thing>>(){}.getType();
    private final Gson gson;

    public JsonLdSerializer(boolean setPrettyPrinting) {
        this(setPrettyPrinting, false);
    }

    public JsonLdSerializer(boolean setPrettyPrinting, boolean disableHtmlEscaping) {
        GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapter(thingTypeToken, (Object)new JsonLdTypeAdapter()).serializeNulls();
        if (setPrettyPrinting) {
            gsonBuilder.setPrettyPrinting();
        }
        if (disableHtmlEscaping) {
            gsonBuilder.disableHtmlEscaping();
        }
        this.gson = gsonBuilder.create();
    }

    public String serialize(List<? extends Thing> objects) throws JsonLdSyntaxException, JsonIOException {
        try {
            return this.gson.toJson(objects, thingTypeToken);
        }
        catch (JsonIOException e) {
            if (e.getCause() instanceof JsonLdSyntaxException) {
                throw (JsonLdSyntaxException)e.getCause();
            }
            throw e;
        }
    }

    public String serialize(Thing object) throws JsonLdSyntaxException, JsonIOException {
        return this.serialize((List<? extends Thing>)ImmutableList.of((Object)object));
    }

    public List<Thing> deserialize(String json) throws JsonLdSyntaxException, JsonSyntaxException {
        try {
            return (List)this.gson.fromJson(json, thingTypeToken);
        }
        catch (JsonSyntaxException e) {
            if (e.getCause() instanceof JsonLdSyntaxException) {
                throw (JsonLdSyntaxException)e.getCause();
            }
            throw e;
        }
    }

    private static class JsonLdTypeAdapter
    extends TypeAdapter<List<? extends Thing>> {
        private static final String CORE_PACKAGE = "com.google.schemaorg.core";
        private static final String GOOG_PACKAGE = "com.google.schemaorg.goog";
        private static final String CORE_NAMESPACE = "http://schema.org";
        private static final String GOOG_NAMESPACE = "http://schema.googleapis.com";
        private static final String THING = "http://schema.org/Thing";
        private static final String OF_METHOD_NAME = "of";
        private static final String ADD_PROPERTY_METHOD_NAME = "addProperty";
        private static final Pattern CORE_NAMESPACE_PATTERN = Pattern.compile("https?://schema.org/?");
        private static final Pattern GOOG_NAMESPACE_PATTERN = Pattern.compile("https?://schema.googleapis.com/?");

        private JsonLdTypeAdapter() {
        }

        public void write(JsonWriter out, List<? extends Thing> values) throws IOException {
            if (values == null || values.isEmpty()) {
                out.nullValue();
                return;
            }
            if (values.size() == 1) {
                this.writeObject(out, values.get(0), true);
            } else {
                out.beginArray();
                for (Thing thing : values) {
                    this.writeObject(out, thing, true);
                }
                out.endArray();
            }
        }

        private void writeContextUrl(JsonWriter out, Thing value) throws IOException {
            LinkedList<Thing> queue = new LinkedList<Thing>();
            queue.add(value);
            while (!queue.isEmpty()) {
                ImmutableListMultimap<String, ValueType> properties = ((SchemaOrgTypeImpl)queue.poll()).getAllProperties();
                for (Map.Entry entry : properties.entries()) {
                    ValueType propertyValue = (ValueType)entry.getValue();
                    if (propertyValue.getClass().getName().startsWith(GOOG_PACKAGE) || ((String)entry.getKey()).startsWith(GOOG_NAMESPACE)) {
                        out.value(GOOG_NAMESPACE);
                        return;
                    }
                    if (!(propertyValue instanceof Thing) || propertyValue instanceof Enumeration) continue;
                    queue.add((Thing)propertyValue);
                }
            }
            out.value(CORE_NAMESPACE);
        }

        private void writeContext(JsonWriter out, Thing value, boolean isTopLevelObject) throws IOException {
            ImmutableList<ValueType> list = value.getJsonLdContextList();
            if (!isTopLevelObject && list.size() == 0) {
                return;
            }
            out.name("@context");
            if (isTopLevelObject && list.size() == 0) {
                this.writeContextUrl(out, value);
                return;
            }
            if (isTopLevelObject && list.size() > 0) {
                out.beginArray();
                this.writeContextUrl(out, value);
                for (ValueType context : list) {
                    this.writeContextInternal(out, context);
                }
                out.endArray();
                return;
            }
            if (!isTopLevelObject && list.size() == 1) {
                this.writeContextInternal(out, (ValueType)list.get(0));
                return;
            }
            if (!isTopLevelObject && list.size() > 1) {
                out.beginArray();
                for (ValueType context : list) {
                    this.writeContextInternal(out, context);
                }
                out.endArray();
            }
        }

        private void writeContextInternal(JsonWriter out, ValueType value) throws IOException {
            if (value == NullValue.VALUE) {
                out.nullValue();
                return;
            }
            if (!(value instanceof JsonLdContext)) {
                throw new JsonLdSyntaxException(String.format("Invalid value of @context: %s", value));
            }
            JsonLdContext context = (JsonLdContext)value;
            if (context.containsBase()) {
                out.beginObject();
                out.name("@base");
                try {
                    String base = context.getBase();
                    if (base == null) {
                        out.nullValue();
                    } else {
                        out.value(base);
                    }
                }
                catch (SchemaOrgException e) {
                    throw new JsonLdSyntaxException("JSON-LD @base must be single value", e.getCause());
                }
                out.endObject();
            }
        }

        private void writeReverse(JsonWriter out, ImmutableMultimap<String, Thing> map) throws IOException {
            ImmutableSet keySet = map.keySet();
            if (keySet.size() == 0) {
                return;
            }
            out.name("@reverse");
            out.beginObject();
            for (String key : keySet) {
                out.name(JsonLdTypeAdapter.shortNameOf(key));
                ImmutableCollection values = map.get((Object)key);
                if (values.size() == 0) {
                    throw new JsonLdSyntaxException(String.format("JSON-LD reverse property %s has no value", key));
                }
                if (values.size() == 1) {
                    this.writeObject(out, (Thing)values.toArray()[0], false);
                    continue;
                }
                out.beginArray();
                for (Thing value : values) {
                    this.writeObject(out, value, false);
                }
                out.endArray();
            }
            out.endObject();
        }

        private void writeObject(JsonWriter out, Thing value, boolean isTopLevelObject) throws IOException {
            if (value instanceof Enumeration) {
                throw new JsonLdSyntaxException(String.format("Enumeration value '%s' cannot be a JSON-LD entity", ((Enumeration)value).getFullEnumValue()));
            }
            out.beginObject();
            this.writeContext(out, value, isTopLevelObject);
            out.name("@type").value(JsonLdTypeAdapter.shortNameOf(value.getFullTypeName()));
            ImmutableListMultimap<String, ValueType> properties = ((SchemaOrgTypeImpl)((Object)value)).getAllProperties();
            for (String key : properties.keySet()) {
                if (key.equals("@context")) continue;
                if (key.equals("@id")) {
                    out.name(key);
                    try {
                        String id = value.getJsonLdId();
                        if (id == null) {
                            out.nullValue();
                            continue;
                        }
                        out.value(id);
                        continue;
                    }
                    catch (SchemaOrgException e) {
                        throw new JsonLdSyntaxException(String.format("Multiple value found for @id in type %s", value.getFullTypeName()));
                    }
                }
                out.name(JsonLdTypeAdapter.shortNameOf(key));
                ImmutableList<SchemaOrgType> values = ((SchemaOrgTypeImpl)((Object)value)).getProperty(key);
                if (values.size() == 0) {
                    throw new JsonLdSyntaxException(String.format("Schema.org type %s's property %s has no value", value.getFullTypeName(), key));
                }
                if (values.size() == 1) {
                    this.writeInternal(out, (SchemaOrgType)values.get(0));
                    continue;
                }
                this.writeArray(out, (List<SchemaOrgType>)values);
            }
            this.writeReverse(out, value.getJsonLdReverseMap());
            out.endObject();
        }

        private void writeArray(JsonWriter out, List<SchemaOrgType> values) throws IOException {
            out.beginArray();
            for (SchemaOrgType value : values) {
                this.writeInternal(out, value);
            }
            out.endArray();
        }

        private void writeInternal(JsonWriter out, SchemaOrgType value) throws IOException {
            if (value instanceof DataType) {
                String dataValue = ((DataType)value).getValue();
                if (value instanceof Integer) {
                    out.value((long)java.lang.Integer.parseInt(dataValue));
                } else if (value instanceof Float) {
                    out.value((double)java.lang.Float.parseFloat(dataValue));
                } else if (value instanceof Number) {
                    out.value(Double.parseDouble(dataValue));
                } else {
                    out.value(dataValue);
                }
                return;
            }
            if (value instanceof Enumeration) {
                out.value(((Enumeration)value).getFullEnumValue());
                return;
            }
            if (value instanceof Thing) {
                this.writeObject(out, (Thing)value, false);
            }
        }

        public List<Thing> read(JsonReader reader) throws IOException {
            JsonToken token = reader.peek();
            switch (token) {
                case STRING: 
                case NUMBER: 
                case BOOLEAN: 
                case NAME: 
                case NULL: 
                case END_OBJECT: 
                case END_ARRAY: {
                    throw new JsonLdSyntaxException(String.format("Invalid top level JSON-LD token %s. Should be an object or an array of objects", token));
                }
                case BEGIN_OBJECT: {
                    return ImmutableList.of((Object)this.readObject(reader));
                }
                case BEGIN_ARRAY: {
                    reader.beginArray();
                    ImmutableList.Builder builder = ImmutableList.builder();
                    while (reader.hasNext()) {
                        builder.add((Object)this.readObject(reader));
                    }
                    reader.endArray();
                    return builder.build();
                }
            }
            return ImmutableList.of();
        }

        private Thing readObject(JsonReader reader) throws IOException {
            reader.beginObject();
            LinkedListMultimap properties = LinkedListMultimap.create();
            LinkedListMultimap reverseMap = LinkedListMultimap.create();
            String typeName = null;
            while (reader.hasNext()) {
                String key = reader.nextName();
                if ("@type".equals(key)) {
                    typeName = reader.nextString();
                    continue;
                }
                if ("@context".equals(key)) {
                    properties.putAll((Object)key, this.readContext(reader));
                    continue;
                }
                if ("@reverse".equals(key)) {
                    reverseMap.putAll(this.readReverse(reader));
                    continue;
                }
                properties.putAll((Object)key, this.readInternal(reader, "@id".equals(key)));
            }
            reader.endObject();
            if (Strings.isNullOrEmpty(typeName)) {
                typeName = THING;
            }
            return JsonLdTypeAdapter.buildSchemaOrgObject(typeName, (Multimap<String, ValueType>)properties, (ListMultimap<String, Thing>)reverseMap);
        }

        private ListMultimap<String, Thing> readReverse(JsonReader reader) throws IOException {
            reader.beginObject();
            LinkedListMultimap reverseMap = LinkedListMultimap.create();
            while (reader.hasNext()) {
                String property = reader.nextName();
                JsonToken token = reader.peek();
                if (token == JsonToken.BEGIN_OBJECT) {
                    reverseMap.put((Object)property, (Object)this.readObject(reader));
                    continue;
                }
                if (token == JsonToken.BEGIN_ARRAY) {
                    reader.beginArray();
                    while (reader.hasNext()) {
                        reverseMap.put((Object)property, (Object)this.readObject(reader));
                    }
                    reader.endArray();
                    continue;
                }
                throw new JsonLdSyntaxException(String.format("Invalid value token %s in @reverse. Should be a JSON-LD object or an array of JSON-LD objects", token));
            }
            reader.endObject();
            return reverseMap;
        }

        private JsonLdContext readContextUrl(JsonReader reader) throws IOException {
            String url = reader.nextString();
            if (!CORE_NAMESPACE_PATTERN.matcher(url).matches() && !GOOG_NAMESPACE_PATTERN.matcher(url).matches()) {
                throw new JsonLdSyntaxException(String.format("Invalid url %s for @context", url));
            }
            return JsonLdFactory.newContextUrl(url);
        }

        private List<JsonLdContext> readContext(JsonReader reader) throws IOException {
            ArrayList<JsonLdContext> list = new ArrayList<JsonLdContext>();
            JsonToken token = reader.peek();
            switch (token) {
                case STRING: {
                    list.add(this.readContextUrl(reader));
                    break;
                }
                case NUMBER: 
                case BOOLEAN: 
                case NAME: 
                case END_OBJECT: 
                case END_ARRAY: 
                case END_DOCUMENT: {
                    throw new JsonLdSyntaxException(String.format("Invalid @context value token %s. Should be URL, context definition or an array containing a combination of these", token));
                }
                case BEGIN_OBJECT: {
                    list.add(this.readContextDef(reader));
                    break;
                }
                case BEGIN_ARRAY: {
                    list.addAll(this.readContextArray(reader));
                    break;
                }
                case NULL: {
                    reader.nextNull();
                    list.add(null);
                }
            }
            return list;
        }

        private List<JsonLdContext> readContextArray(JsonReader reader) throws IOException {
            reader.beginArray();
            ArrayList<JsonLdContext> list = new ArrayList<JsonLdContext>();
            while (reader.hasNext()) {
                JsonToken token = reader.peek();
                if (token == JsonToken.STRING) {
                    list.add(this.readContextUrl(reader));
                    continue;
                }
                if (token == JsonToken.NULL) {
                    reader.nextNull();
                    list.add(null);
                    continue;
                }
                if (token == JsonToken.BEGIN_OBJECT) {
                    list.add(this.readContextDef(reader));
                    continue;
                }
                throw new JsonLdSyntaxException(String.format("Invalid @context value token %s. Should be URL, context definition", token));
            }
            reader.endArray();
            return list;
        }

        private JsonLdContext readContextDef(JsonReader reader) throws IOException {
            reader.beginObject();
            JsonLdContext.Builder contextBuilder = JsonLdFactory.newContextBuilder();
            while (reader.hasNext()) {
                String key = reader.nextName();
                if (!"@base".equals(key)) {
                    throw new JsonLdSyntaxException(String.format("Unsupported '%s' in JSON-LD context", key));
                }
                JsonToken valueToken = reader.peek();
                if (valueToken == JsonToken.STRING) {
                    contextBuilder.setBase(reader.nextString());
                    continue;
                }
                if (valueToken == JsonToken.NULL) {
                    reader.nextNull();
                    contextBuilder.setBase(null);
                    continue;
                }
                throw new JsonLdSyntaxException(String.format("The value of @base is '%s', should be a string", valueToken));
            }
            reader.endObject();
            return contextBuilder.build();
        }

        private List<SchemaOrgType> readInternal(JsonReader reader, boolean acceptNull) throws IOException {
            ArrayList<SchemaOrgType> list = new ArrayList<SchemaOrgType>();
            switch (reader.peek()) {
                case STRING: {
                    list.add(Text.of(reader.nextString()));
                    break;
                }
                case NUMBER: {
                    list.add(Number.of(reader.nextString()));
                    break;
                }
                case BOOLEAN: {
                    if (reader.nextBoolean()) {
                        list.add(BooleanEnum.TRUE);
                        break;
                    }
                    list.add(BooleanEnum.FALSE);
                    break;
                }
                case NULL: {
                    if (acceptNull) {
                        reader.nextNull();
                        list.add(null);
                        break;
                    }
                    throw new JsonLdSyntaxException("Found null value for schema.org property value");
                }
                case BEGIN_OBJECT: {
                    list.add(this.readObject(reader));
                    break;
                }
                case BEGIN_ARRAY: {
                    list.addAll(this.readArray(reader));
                    break;
                }
                case END_DOCUMENT: {
                    throw new JsonLdSyntaxException("Meet end of document");
                }
            }
            return list;
        }

        private List<SchemaOrgType> readArray(JsonReader reader) throws IOException {
            reader.beginArray();
            ArrayList<SchemaOrgType> list = new ArrayList<SchemaOrgType>();
            while (reader.hasNext()) {
                list.addAll(this.readInternal(reader, false));
            }
            reader.endArray();
            return list;
        }

        private static Thing buildSchemaOrgObject(String typeName, Multimap<String, ValueType> properties, ListMultimap<String, Thing> reverseMap) throws JsonLdSyntaxException {
            try {
                Class<?> builderClass = JsonLdTypeAdapter.findBuilderClass(typeName);
                Thing.Builder builder = (Thing.Builder)JsonLdTypeAdapter.createBuilder(builderClass);
                for (String key : properties.keySet()) {
                    JsonLdTypeAdapter.setPropertyValues(builderClass, builder, key, properties.get((Object)key), typeName);
                }
                JsonLdTypeAdapter.setReverseMap(builder, reverseMap);
                return (Thing)builderClass.getMethod("build", new Class[0]).invoke((Object)builder, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new JsonLdSyntaxException(String.format("JSON-LD deserialize internal error for type %s.", typeName), e.getCause());
            }
        }

        private static void setReverseMap(Thing.Builder builder, ListMultimap<String, Thing> reverseMap) {
            for (String key : reverseMap.keySet()) {
                for (Thing thing : reverseMap.get((Object)key)) {
                    builder.setJsonLdReverse(key, thing);
                }
            }
        }

        private static void setPropertyValues(Class<?> builderClass, Thing.Builder builder, String key, Collection<ValueType> values, String typeName) throws JsonLdSyntaxException, IllegalAccessException, InvocationTargetException {
            String methodName = "";
            try {
                switch (key) {
                    case "@context": {
                        methodName = "addJsonLdContext";
                        for (ValueType value : values) {
                            builderClass.getMethod(methodName, JsonLdContext.class).invoke((Object)builder, value == null ? null : (JsonLdContext)value);
                        }
                        break;
                    }
                    case "@id": {
                        methodName = "setJsonLdId";
                        for (ValueType value : values) {
                            builderClass.getMethod(methodName, String.class).invoke((Object)builder, value == null ? null : ((Text)value).getValue());
                        }
                        break;
                    }
                    default: {
                        for (ValueType value : values) {
                            Enumeration enumValue;
                            if (value instanceof Text && (enumValue = EnumValues.valueOf(((Text)value).getValue())) != null) {
                                value = enumValue;
                            }
                            JsonLdTypeAdapter.invokeMethod(builderClass, builder, key, (SchemaOrgType)value);
                        }
                    }
                }
            }
            catch (NoSuchMethodException e) {
                throw new JsonLdSyntaxException(String.format("Could not find method %s in %s", methodName, builderClass.getName()), e.getCause());
            }
        }

        private static void invokeMethod(Class<?> builderClass, Thing.Builder builder, String propertyName, SchemaOrgType value) throws JsonLdSyntaxException {
            String methodName = String.format("add%s", JsonLdTypeAdapter.capFirst(JsonLdTypeAdapter.shortNameOf(propertyName)));
            Method foundMethod = null;
            Object paramValue = null;
            if (value instanceof Text) {
                try {
                    foundMethod = builderClass.getMethod(methodName, String.class);
                    paramValue = ((Text)value).getValue();
                }
                catch (NoSuchMethodException e) {
                    foundMethod = null;
                    paramValue = null;
                }
            } else {
                Method[] methods;
                for (Method m : methods = builderClass.getMethods()) {
                    if (!m.getName().equals(methodName)) continue;
                    foundMethod = m;
                    Class<?> parameterType = m.getParameterTypes()[0];
                    if (parameterType.isAssignableFrom(value.getClass())) {
                        paramValue = value;
                        break;
                    }
                    if (!(value instanceof Number) || !Number.class.isAssignableFrom(parameterType)) continue;
                    String strValue = ((Number)value).getValue();
                    try {
                        if (parameterType == Integer.class) {
                            Method method = parameterType.getMethod(OF_METHOD_NAME, java.lang.Integer.TYPE);
                            paramValue = method.invoke(null, java.lang.Integer.parseInt(strValue));
                            break;
                        }
                        if (parameterType == Float.class) {
                            Method method = parameterType.getMethod(OF_METHOD_NAME, java.lang.Float.TYPE);
                            paramValue = method.invoke(null, java.lang.Float.valueOf(java.lang.Float.parseFloat(strValue)));
                            break;
                        }
                        Method method = parameterType.getMethod(OF_METHOD_NAME, String.class);
                        paramValue = method.invoke(null, ((Number)value).getValue());
                        break;
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                        // empty catch block
                    }
                }
            }
            if (foundMethod != null && paramValue != null) {
                try {
                    foundMethod.invoke((Object)builder, paramValue);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new JsonLdSyntaxException(String.format("Could not call method %s with parameter type %s on %s: check property name and expected value type", methodName, paramValue.getClass().getName(), builderClass.getName()));
                }
            } else if (foundMethod == null) {
                try {
                    foundMethod = builderClass.getMethod(ADD_PROPERTY_METHOD_NAME, String.class, SchemaOrgType.class);
                    foundMethod.invoke((Object)builder, propertyName, value);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new JsonLdSyntaxException(String.format("Could not call method '%s' to add property '%s'", ADD_PROPERTY_METHOD_NAME, propertyName), e.getCause());
                }
            } else {
                throw new JsonLdSyntaxException(String.format("Could not call method '%s' on '%s': check property name and expected value type", methodName, builderClass.getName()));
            }
        }

        /*
         * Loose catch block
         */
        private static Class<?> findBuilderClass(String typeName) throws JsonLdSyntaxException {
            block6: {
                if (typeName.startsWith("http://schema.org/")) {
                    return Class.forName(JsonLdTypeAdapter.builderName(CORE_PACKAGE, typeName.substring("http://schema.org/".length())));
                }
                if (!typeName.startsWith("http://schema.googleapis.com/")) break block6;
                return Class.forName(JsonLdTypeAdapter.builderName(GOOG_PACKAGE, typeName.substring("http://schema.googleapis.com/".length())));
                {
                    catch (ClassNotFoundException e) {
                        throw new JsonLdSyntaxException(String.format("JSON-LD Entity type %s is not a valid schema.org type", typeName), e.getCause());
                    }
                }
            }
            try {
                return Class.forName(JsonLdTypeAdapter.builderName(CORE_PACKAGE, typeName));
            }
            catch (ClassNotFoundException e) {
                return Class.forName(JsonLdTypeAdapter.builderName(GOOG_PACKAGE, typeName));
            }
        }

        private static <T> T createBuilder(Class<T> builderClass) throws JsonLdSyntaxException {
            String typeName = builderClass.getName().split("\\$")[0];
            try {
                if (typeName.startsWith(CORE_PACKAGE)) {
                    return (T)CoreFactory.class.getMethod(JsonLdTypeAdapter.newBuilderMethodName(typeName), new Class[0]).invoke(null, new Object[0]);
                }
                if (typeName.startsWith(GOOG_PACKAGE)) {
                    return (T)GoogFactory.class.getMethod(JsonLdTypeAdapter.newBuilderMethodName(typeName), new Class[0]).invoke(null, new Object[0]);
                }
                throw new JsonLdSyntaxException(String.format("Invalid type name %s from builder class %s", typeName, builderClass.getName()));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new JsonLdSyntaxException(String.format("Could not create instance of %s builder", typeName));
            }
        }

        private static String newBuilderMethodName(String typeName) {
            return String.format("new%sBuilder", JsonLdTypeAdapter.shortNameOf(typeName));
        }

        private static String capFirst(String name) {
            return name.substring(0, 1).toUpperCase() + name.substring(1);
        }

        private static String builderName(String packageName, String typeName) {
            return String.format("%s$Builder", JsonLdTypeAdapter.typeName(packageName, typeName));
        }

        private static String typeName(String packageName, String typeName) {
            return String.format("%s.%s", packageName, typeName);
        }

        private static String shortNameOf(String fullName) {
            if (fullName.startsWith("http://schema.org/")) {
                return fullName.substring("http://schema.org/".length());
            }
            if (fullName.startsWith("http://schema.googleapis.com/")) {
                return fullName.substring("http://schema.googleapis.com/".length());
            }
            if (fullName.startsWith(CORE_PACKAGE)) {
                return fullName.substring(CORE_PACKAGE.length() + 1);
            }
            if (fullName.startsWith(GOOG_PACKAGE)) {
                return fullName.substring(GOOG_PACKAGE.length() + 1);
            }
            return fullName;
        }
    }
}

