/*
 * Decompiled with CFR 0.152.
 */
package com.github.matinh.vdldoc.maven.plugins;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;
import org.omnifaces.vdldoc.VdldocGenerator;

@Mojo(name="vdldoc", defaultPhase=LifecyclePhase.SITE)
@Execute(phase=LifecyclePhase.GENERATE_SOURCES)
public class Vdldoc
extends AbstractMojo
implements MavenReport {
    @Parameter(defaultValue="${project.name} VDL Documentation")
    private String browserTitle;
    @Parameter(defaultValue="${project.name} VDL Documentation")
    private String documentTitle;
    @Parameter(defaultValue="true", property="maven.vdldoc.failOnError")
    private boolean failOnError = true;
    @Parameter(defaultValue="false", property="maven.vdldoc.skip")
    private boolean skip;
    @Parameter(defaultValue="**/*.taglib.xml", property="maven.vdldoc.includes")
    private List<String> includes;
    @Parameter(defaultValue="target/**", property="maven.vdldoc.excludes")
    private List<String> excludes;
    @Parameter(defaultValue="${project.reporting.outputDirectory}", property="maven.vdldoc.outputDirectory")
    private File reportOutputDirectory;
    @Parameter(defaultValue="vdldoc", property="maven.vdldoc.destDir")
    private String destDir = "vdldoc";
    @Parameter(property="maven.vdldoc.css")
    private String css;
    @Parameter(property="maven.vdldoc.facesConfig")
    private String facesConfig;
    @Parameter(property="maven.vdldoc.attributesFile")
    private String attributesFile;
    @Parameter(defaultValue="false", property="maven.vdldoc.hideGeneratedBy")
    private boolean hideGeneratedBy;
    @Parameter(defaultValue="${project.basedir}", readonly=true)
    private File srcDirectory;
    private VdldocGenerator generator = new VdldocGenerator();

    void setGenerator(VdldocGenerator gen) {
        this.generator = gen;
    }

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping generation of Vdldoc.");
            return;
        }
        try {
            this.generateDocumentation();
        }
        catch (Exception e) {
            if (this.failOnError) {
                throw new MojoExecutionException("Error generating Vdldoc!", e);
            }
            String reason = e.getLocalizedMessage() == null ? e.toString() : e.getLocalizedMessage();
            this.getLog().warn((CharSequence)("Failed to generate documentation: " + reason));
            this.getLog().debug((Throwable)e);
        }
    }

    public void generate(Sink sink, Locale locale) throws MavenReportException {
        try {
            this.execute();
        }
        catch (MojoExecutionException e) {
            throw new MavenReportException(e.getMessage(), (Exception)e.getCause());
        }
    }

    public String getOutputName() {
        return this.destDir + File.separator + "index";
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.vdldoc.name");
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.vdldoc.description");
    }

    public void setReportOutputDirectory(File file) {
        this.reportOutputDirectory = file;
    }

    public File getReportOutputDirectory() {
        return this.reportOutputDirectory;
    }

    public boolean isExternalReport() {
        return true;
    }

    public boolean canGenerateReport() {
        return true;
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("vdldoc-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    private void generateDocumentation() {
        this.generator.setWindowTitle(this.browserTitle);
        this.generator.setDocTitle(this.documentTitle);
        this.generator.setOutputDirectory(new File(this.reportOutputDirectory, this.destDir));
        if (!StringUtils.isEmpty((String)this.css)) {
            this.getLog().debug((CharSequence)("Using CSS file " + this.css));
            this.generator.setCssLocation(this.css);
        }
        if (!StringUtils.isEmpty((String)this.facesConfig)) {
            this.getLog().debug((CharSequence)("Using faces-config file " + this.facesConfig));
            this.generator.setFacesConfig(new File(this.facesConfig));
        }
        if (!StringUtils.isEmpty((String)this.attributesFile)) {
            this.getLog().debug((CharSequence)("Using attributes-file " + this.attributesFile));
            this.generator.setAttributes(new File(this.attributesFile));
        }
        if (this.hideGeneratedBy) {
            this.getLog().debug((CharSequence)"Hiding 'generated-by' message.");
            this.generator.setHideGeneratedBy(true);
        }
        List<String> taglibs = this.scanForTaglibs(this.srcDirectory, this.includes, this.excludes);
        this.getLog().debug((CharSequence)("Found taglibs: " + taglibs));
        for (String taglib : taglibs) {
            this.generator.addTaglib(new File(this.srcDirectory, taglib));
        }
        this.generator.generate();
    }

    private List<String> scanForTaglibs(File basedir, List<String> includeList, List<String> excludeList) {
        ArrayList<String> result = new ArrayList<String>();
        if (basedir != null && basedir.exists()) {
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(basedir);
            if (includeList != null) {
                scanner.setIncludes(Vdldoc.processIncludesExcludes(includeList));
            }
            if (excludeList != null) {
                scanner.setExcludes(Vdldoc.processIncludesExcludes(excludeList));
            }
            scanner.scan();
            Collections.addAll(result, scanner.getIncludedFiles());
        }
        return result;
    }

    private static String[] processIncludesExcludes(List<String> list) {
        ArrayList newList = new ArrayList();
        for (String aList : list) {
            String[] includes = aList.split(",");
            Collections.addAll(newList, includes);
        }
        String[] incs = new String[newList.size()];
        for (int i = 0; i < incs.length; ++i) {
            incs[i] = (String)newList.get(i);
        }
        return incs;
    }
}

