/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.APDUBIBO;
import apdu4j.CardChannelBIBO;
import apdu4j.CommandAPDU;
import apdu4j.HexUtils;
import apdu4j.TerminalManager;
import apdu4j.providers.APDUReplayProvider;
import apdu4j.terminals.LoggingCardTerminal;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.crypto.Cipher;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.TerminalFactory;
import joptsimple.OptionSet;
import pro.javacard.AID;
import pro.javacard.CAPFile;
import pro.javacard.gp.DAPProperties;
import pro.javacard.gp.DMTokenGenerator;
import pro.javacard.gp.GPCardKeys;
import pro.javacard.gp.GPCommandLineInterface;
import pro.javacard.gp.GPCommands;
import pro.javacard.gp.GPCrypto;
import pro.javacard.gp.GPData;
import pro.javacard.gp.GPException;
import pro.javacard.gp.GPKeyInfo;
import pro.javacard.gp.GPRegistry;
import pro.javacard.gp.GPRegistryEntry;
import pro.javacard.gp.GPSession;
import pro.javacard.gp.GPUtils;
import pro.javacard.gp.PlaintextKeys;
import pro.javacard.gp.PythiaKeys;
import pro.javacard.gp.SEAccessControl;
import pro.javacard.gp.SEAccessControlUtility;
import pro.javacard.gp.SecureChannelParameters;

public final class GPTool
extends GPCommandLineInterface {
    private static boolean isVerbose = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] argv) throws Exception {
        OptionSet args = GPTool.parseArguments(argv);
        System.setProperty("org.slf4j.simpleLogger.showThreadName", "false");
        System.setProperty("org.slf4j.simpleLogger.levelInBrackets", "true");
        System.setProperty("org.slf4j.simpleLogger.showShortLogName", "true");
        if (args.has("verbose")) {
            System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "debug");
            isVerbose = true;
        } else {
            System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "warn");
        }
        if (args.has("debug")) {
            System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "trace");
        }
        if (args.has("version") || args.has("verbose") || args.has("debug") || args.has("info")) {
            String version = GPSession.getVersion();
            version = version + "\nRunning on " + System.getProperty("os.name");
            version = version + " " + System.getProperty("os.version");
            version = version + " " + System.getProperty("os.arch");
            version = version + ", Java " + System.getProperty("java.version");
            version = version + " by " + System.getProperty("java.vendor");
            System.out.println("GlobalPlatformPro " + version);
            if (Cipher.getMaxAllowedKeyLength("AES") == 128) {
                System.out.println("Unlimited crypto policy is NOT installed!");
            }
        }
        CAPFile cap = null;
        if (args.has("cap")) {
            File capfile = (File)args.valueOf("cap");
            try (FileInputStream fin = new FileInputStream(capfile);){
                cap = CAPFile.fromStream((InputStream)fin);
            }
            if (args.has("info")) {
                System.out.println("**** CAP info of " + capfile.getName());
                cap.dump(System.out);
                if (args.specs().size() == 2) {
                    System.exit(0);
                }
            }
        }
        if (args.has("list-privs")) {
            System.out.println("# Known privileges:");
            System.out.println(Arrays.asList(GPRegistryEntry.Privilege.values()).stream().map(i -> i.toString()).collect(Collectors.joining("\n")));
        }
        try {
            List<Object> do_readers;
            TerminalFactory tf;
            if (args.has("replay")) {
                File f = (File)args.valueOf("replay");
                FileInputStream fin = new FileInputStream(f);
                Object object = null;
                try {
                    tf = TerminalFactory.getInstance("PC/SC", (Object)fin, (Provider)new APDUReplayProvider());
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (fin != null) {
                        if (object != null) {
                            try {
                                fin.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            fin.close();
                        }
                    }
                }
            } else {
                tf = TerminalManager.getTerminalFactory((String)((String)args.valueOf("terminals")));
            }
            CardTerminals terminals = tf.terminals();
            if (args.has("debug")) {
                System.out.println("# Detected readers from " + tf.getProvider().getName());
                for (CardTerminal term : terminals.list()) {
                    void var7_17;
                    String string = " ";
                    if (term.isCardPresent()) {
                        String string2 = "*";
                        if (GPTool.ignoreReader(term.getName())) {
                            String string3 = "I";
                        }
                    }
                    System.out.println("[" + (String)var7_17 + "] " + term.getName());
                }
            }
            if (args.has("reader") || System.getenv().containsKey("GP_READER")) {
                CardTerminal cardTerminal;
                String reader = System.getenv("GP_READER");
                if (args.has("reader")) {
                    reader = (String)args.valueOf("reader");
                }
                if ((cardTerminal = terminals.getTerminal(reader)) == null) {
                    GPTool.fail("Reader \"" + reader + "\" not found.");
                }
                do_readers = Arrays.asList(cardTerminal);
            } else {
                List<CardTerminal> tmp = terminals.list(CardTerminals.State.CARD_PRESENT);
                do_readers = new ArrayList();
                for (CardTerminal t : tmp) {
                    if (!GPTool.ignoreReader(t.getName())) {
                        do_readers.add(t);
                        continue;
                    }
                    if (!args.has("verbose")) continue;
                    System.out.println("# Ignoring " + t.getName());
                }
            }
            if (do_readers.size() == 0) {
                GPTool.fail("No smart card readers with a card found");
            }
            for (CardTerminal cardTerminal : do_readers) {
                void var7_24;
                if (do_readers.size() > 1) {
                    System.out.println("# " + cardTerminal.getName());
                }
                if (args.has("debug")) {
                    FileOutputStream o = null;
                    if (args.has("dump")) {
                        File f = (File)args.valueOf("dump");
                        o = new FileOutputStream(f);
                    }
                    LoggingCardTerminal loggingCardTerminal = LoggingCardTerminal.getInstance((CardTerminal)cardTerminal, o);
                }
                Card card = null;
                APDUBIBO channel = null;
                try {
                    List blobs;
                    AID appletAID;
                    AID packageAID;
                    Serializable key2;
                    List<CAPFile> caps;
                    AID aid;
                    PlaintextKeys keys;
                    try {
                        card = var7_24.connect("*");
                        card.beginExclusive();
                        channel = CardChannelBIBO.getBIBO((CardChannel)card.getBasicChannel());
                    }
                    catch (CardException e2) {
                        System.err.println("Could not connect to " + var7_24.getName() + ": " + TerminalManager.getExceptionMessage((Exception)e2));
                        if (card == null) continue;
                        card.endExclusive();
                        card.disconnect(true);
                        continue;
                    }
                    if (args.has("info") || args.has("verbose")) {
                        System.out.println("Reader: " + var7_24.getName());
                        System.out.println("ATR: " + HexUtils.bin2hex((byte[])card.getATR().getBytes()));
                        System.out.println("More information about your card:");
                        System.out.println("    http://smartcard-atr.appspot.com/parse?ATR=" + HexUtils.bin2hex((byte[])card.getATR().getBytes()));
                        System.out.println();
                    }
                    if (args.has("apdu")) {
                        AID target = null;
                        if (args.has("applet")) {
                            target = AID.fromString((Object)args.valueOf("applet"));
                        } else if (cap != null) {
                            target = (AID)cap.getAppletAIDs().get(0);
                        }
                        if (target != null) {
                            GPTool.verbose("Selecting " + target);
                            channel.transmit(new CommandAPDU(0, 164, 4, 0, target.getBytes()));
                        }
                        for (Object s : args.valuesOf("apdu")) {
                            CommandAPDU c = new CommandAPDU(HexUtils.stringToBin((String)((String)s)));
                            channel.transmit(c);
                        }
                    }
                    Map<String, String> env = System.getenv();
                    GPSession gp = args.has("sdaid") ? GPSession.connect((APDUBIBO)channel, (AID)AID.fromString((Object)args.valueOf("sdaid"))) : (env.containsKey("GP_AID") ? GPSession.connect((APDUBIBO)channel, (AID)AID.fromString((Object)env.get("GP_AID"))) : GPSession.discover((APDUBIBO)channel));
                    if (args.has("token-key")) {
                        gp.setDMTokenGenerator(new DMTokenGenerator(GPTool.getRSAPrivateKey(args.valueOf("token-key").toString())));
                    } else {
                        gp.setDMTokenGenerator(new DMTokenGenerator(null));
                    }
                    if (args.has("force")) {
                        gp.setStrict(false);
                    }
                    if (args.has("info")) {
                        GPData.dump((APDUBIBO)channel);
                    }
                    if (args.has("keys")) {
                        GPTool.fail("Not yet implemented");
                        keys = PlaintextKeys.defaultKey();
                    } else if (args.has("oracle")) {
                        keys = PythiaKeys.ask((byte[])card.getATR().getBytes(), (byte[])GPData.fetchCPLC((APDUBIBO)channel), (byte[])GPData.fetchKeyInfoTemplate((APDUBIBO)channel));
                    } else {
                        PlaintextKeys keyz;
                        if (args.has("key")) {
                            byte[] k = HexUtils.stringToBin((String)((String)args.valueOf("key")));
                            byte[] kcv = null;
                            if (args.has("kcv")) {
                                kcv = HexUtils.stringToBin((String)((String)args.valueOf("kcv")));
                            }
                            keyz = PlaintextKeys.fromMasterKey((byte[])k, kcv);
                        } else {
                            Iterator params = SecureChannelParameters.fromEnvironment();
                            if (args.has("key-mac") && args.has("key-enc") && args.has("key-dek")) {
                                byte[] enc = HexUtils.stringToBin((String)((String)args.valueOf("key-enc")));
                                byte[] byArray = HexUtils.stringToBin((String)((String)args.valueOf("key-mac")));
                                byte[] dek = HexUtils.stringToBin((String)((String)args.valueOf("key-dek")));
                                keyz = PlaintextKeys.fromKeys((byte[])enc, (byte[])byArray, (byte[])dek);
                            } else if (((Optional)((Object)params)).isPresent()) {
                                keyz = (PlaintextKeys)((SecureChannelParameters)((Optional)((Object)params)).get()).getCardKeys();
                            } else {
                                if (GPTool.needsAuthentication(args)) {
                                    System.out.println("Warning: no keys given, using default test key " + HexUtils.bin2hex((byte[])PlaintextKeys.defaultKeyBytes));
                                }
                                keyz = PlaintextKeys.defaultKey();
                            }
                        }
                        if (args.has("visa2")) {
                            keyz.setDiversifier(PlaintextKeys.Diversification.VISA2);
                        } else if (args.has("emv")) {
                            keyz.setDiversifier(PlaintextKeys.Diversification.EMV);
                        } else if (args.has("kdf3")) {
                            keyz.setDiversifier(PlaintextKeys.Diversification.KDF3);
                        } else if (args.has("kdf")) {
                            keyz.setDiversifier(GPTool.getDiversificationOrFail(args, "kdf"));
                        }
                        if (args.has("key-ver")) {
                            keyz.setVersion(GPUtils.intValue((String)((String)args.valueOf("key-ver"))));
                        }
                        keys = keyz;
                    }
                    if (args.has("op201")) {
                        gp.setSpec(GPSession.GPSpec.OP201);
                    }
                    if (args.has("bs")) {
                        gp.setBlockSize(((Integer)args.valueOf("bs")).intValue());
                    }
                    if (args.has("acr-list-aram")) {
                        SEAccessControlUtility.acrList((GPSession)gp);
                    }
                    if (!GPTool.needsAuthentication(args)) continue;
                    Object mode = GPSession.defaultMode.clone();
                    if (args.has("mode")) {
                        ((AbstractCollection)mode).clear();
                        for (Object s : args.valuesOf("mode")) {
                            ((AbstractCollection)mode).add(GPSession.APDUMode.fromString((String)((String)s)));
                        }
                    }
                    gp.openSecureChannel((GPCardKeys)keys, null, null, (EnumSet)mode);
                    if (args.has("secure-apdu")) {
                        for (Object s : args.valuesOf("secure-apdu")) {
                            CommandAPDU commandAPDU = new CommandAPDU(HexUtils.stringToBin((String)((String)s)));
                            gp.transmit(commandAPDU);
                        }
                    }
                    if (args.has("acr-list")) {
                        SEAccessControl.AcrListFetcher fetcher = new SEAccessControl.AcrListFetcher(gp);
                        byte[] r = fetcher.get(args.has("acr-aid") ? AID.fromString((Object)args.valueOf("acr-aid")) : null);
                        SEAccessControl.AcrListResponse acrListResponse = SEAccessControl.AcrListResponse.fromBytes((byte[])r);
                        SEAccessControl.printList((List)acrListResponse.acrList);
                    }
                    if (args.has("delete")) {
                        GPRegistry reg = gp.getRegistry();
                        if (args.has("default")) {
                            Optional def = reg.getDefaultSelectedAID();
                            if (def.isPresent()) {
                                gp.deleteAID((AID)def.get(), false);
                            } else {
                                System.err.println("Could not identify default selected application!");
                            }
                        }
                        List aids = args.valuesOf("delete").stream().map(a -> AID.fromString((Object)a)).collect(Collectors.toList());
                        Iterator iterator = aids.iterator();
                        while (iterator.hasNext()) {
                            aid = (AID)iterator.next();
                            try {
                                boolean deleteDeps = reg.allPackageAIDs().contains(aid) || args.has("force");
                                gp.deleteAID(aid, deleteDeps);
                            }
                            catch (GPException e3) {
                                if (!gp.getRegistry().allAIDs().contains(aid)) {
                                    System.err.println("Could not delete AID (not present on card): " + aid);
                                    continue;
                                }
                                System.err.println("Could not delete AID: " + aid);
                                if (e3.sw != 27013) throw e3;
                                System.err.println("Deletion not allowed. Some app still active?");
                            }
                        }
                    }
                    if (args.has("uninstall")) {
                        caps = GPTool.getCapFileList(args, "uninstall");
                        for (CAPFile cAPFile : caps) {
                            aid = cAPFile.getPackageAID();
                            if (!gp.getRegistry().allAIDs().contains(aid)) {
                                System.out.println(aid + " is not present on card!");
                                continue;
                            }
                            gp.deleteAID(aid, true);
                            System.out.println(aid + " deleted.");
                        }
                    }
                    if (args.has("load")) {
                        caps = GPTool.getCapFileList(args, "load");
                        for (CAPFile cAPFile : caps) {
                            if (isVerbose) {
                                cAPFile.dump(System.out);
                            }
                            GPTool.calculateDapPropertiesAndLoadCap(args, gp, cAPFile);
                        }
                    }
                    if (args.has("put-key")) {
                        int keyVersion = 115;
                        if (args.has("new-keyver")) {
                            keyVersion = GPUtils.intValue((String)args.valueOf("new-keyver").toString());
                        }
                        Throwable throwable = null;
                        try (FileInputStream fin = new FileInputStream(new File(args.valueOf("put-key").toString()));){
                            key2 = GPCrypto.pem2PublicKey((InputStream)fin);
                            if (key2 instanceof RSAPublicKey) {
                                gp.putKey((RSAPublicKey)key2, keyVersion);
                            }
                        }
                        catch (Throwable key2) {
                            Throwable throwable2 = key2;
                            throw key2;
                        }
                    }
                    if (args.has("install")) {
                        AID appaid;
                        CAPFile instcap;
                        File capfile = (File)args.valueOf("install");
                        FileInputStream fileInputStream = new FileInputStream(capfile);
                        key2 = null;
                        try {
                            instcap = CAPFile.fromStream((InputStream)fileInputStream);
                        }
                        catch (Throwable e3) {
                            key2 = e3;
                            throw e3;
                        }
                        finally {
                            if (fileInputStream != null) {
                                if (key2 != null) {
                                    try {
                                        fileInputStream.close();
                                    }
                                    catch (Throwable e3) {
                                        ((Throwable)key2).addSuppressed(e3);
                                    }
                                } else {
                                    fileInputStream.close();
                                }
                            }
                        }
                        if (args.has("verbose")) {
                            instcap.dump(System.out);
                        }
                        GPRegistry gPRegistry = gp.getRegistry();
                        if (args.has("force") && gPRegistry.allPackageAIDs().contains(instcap.getPackageAID())) {
                            gp.deleteAID(instcap.getPackageAID(), true);
                        }
                        if (instcap.getAppletAIDs().size() <= 1) {
                            GPTool.calculateDapPropertiesAndLoadCap(args, gp, instcap);
                        }
                        if (instcap.getAppletAIDs().size() == 0) {
                            return;
                        }
                        if (instcap.getAppletAIDs().size() > 1) {
                            if (!args.has("applet")) {
                                GPTool.fail("CAP contains more than one applet, specify the right one with --applet");
                                return;
                            }
                            appaid = AID.fromString((Object)args.valueOf("applet"));
                        } else {
                            appaid = (AID)instcap.getAppletAIDs().get(0);
                        }
                        AID instanceaid = args.has("create") ? AID.fromString((Object)args.valueOf("create")) : appaid;
                        GPRegistryEntry.Privileges privs = GPTool.getInstPrivs(args);
                        if (args.has("force") && gPRegistry.getDefaultSelectedAID().isPresent() && privs.has(GPRegistryEntry.Privilege.CardReset)) {
                            gp.deleteAID((AID)gPRegistry.getDefaultSelectedAID().get(), false);
                        }
                        if (gp.getRegistry().allAppletAIDs().contains(instanceaid)) {
                            System.err.println("WARNING: Applet " + instanceaid + " already present on card");
                        }
                        gp.installAndMakeSelectable(instcap.getPackageAID(), appaid, instanceaid, privs, GPTool.getInstParams(args));
                    }
                    if (args.has("create") && !args.has("install")) {
                        packageAID = null;
                        appletAID = null;
                        if (cap != null) {
                            packageAID = cap.getPackageAID();
                            if (cap.getAppletAIDs().size() != 1) {
                                throw new IllegalArgumentException("There should be only one applet in CAP. Use --applet instead.");
                            }
                            appletAID = (AID)cap.getAppletAIDs().get(0);
                        }
                        if (args.has("package")) {
                            packageAID = AID.fromString((Object)args.valueOf("package"));
                        }
                        if (args.has("applet")) {
                            appletAID = AID.fromString((Object)args.valueOf("applet"));
                        }
                        if (packageAID == null) throw new IllegalArgumentException("Need --package and --applet or --cap");
                        if (appletAID == null) {
                            throw new IllegalArgumentException("Need --package and --applet or --cap");
                        }
                        if (gp.getRegistry().allAIDs().contains(appletAID)) {
                            System.err.println("WARNING: Applet " + appletAID + " already present on card");
                        }
                        AID aID = AID.fromString((Object)args.valueOf("create"));
                        gp.installAndMakeSelectable(packageAID, appletAID, aID, GPTool.getInstPrivs(args), GPTool.getInstParams(args));
                    }
                    if (args.has("domain")) {
                        if ((args.has("allow-from") || args.has("allow-to")) && args.has("params")) {
                            GPTool.fail("SSD extradition options can't be used with SSD installation parameters");
                        }
                        packageAID = new AID("A0000001515350");
                        appletAID = new AID("A000000151535041");
                        if (args.has("package") && args.has("applet")) {
                            packageAID = AID.fromString((Object)args.valueOf("package"));
                            appletAID = AID.fromString((Object)args.valueOf("applet"));
                        } else {
                            System.out.println("Note: using default AID-s for SSD instantiation: " + appletAID + " from " + packageAID);
                        }
                        AID aID = AID.fromString((Object)args.valueOf("domain"));
                        GPRegistryEntry.Privileges privs = GPTool.getInstPrivs(args);
                        privs.add(GPRegistryEntry.Privilege.SecurityDomain);
                        byte[] params = new byte[]{};
                        if (args.has("params")) {
                            params = GPTool.getInstParams(args);
                        } else {
                            if (args.has("allow-to")) {
                                params = GPUtils.concatenate((byte[][])new byte[][]{params, {-126, 1, 32}});
                            }
                            if (args.has("allow-from")) {
                                params = GPUtils.concatenate((byte[][])new byte[][]{params, {-121, 1, 32}});
                            }
                        }
                        gp.installAndMakeSelectable(packageAID, appletAID, aID, privs, params);
                    }
                    if (args.has("move")) {
                        if (!args.has("to")) {
                            GPTool.fail("Specify extradition target with --to");
                        }
                        AID what = AID.fromString((Object)args.valueOf("move"));
                        AID to = AID.fromString((Object)args.valueOf("to"));
                        gp.extradite(what, to);
                    }
                    if (args.has("store-data")) {
                        blobs = args.valuesOf("store-data").stream().map(e -> HexUtils.stringToBin((String)((String)e))).collect(Collectors.toList());
                        for (byte[] byArray : blobs) {
                            if (args.has("applet")) {
                                gp.personalize(AID.fromString((Object)args.valueOf("applet")), byArray, 1);
                                continue;
                            }
                            gp.storeData(byArray, 1);
                        }
                    }
                    if (args.has("store-data-chunk")) {
                        blobs = args.valuesOf("store-data-chunk").stream().map(e -> HexUtils.stringToBin((String)((String)e))).collect(Collectors.toList());
                        if (args.has("applet")) {
                            gp.personalize(AID.fromString((Object)args.valueOf("applet")), blobs, 1);
                        } else {
                            gp.storeData(blobs, 1);
                        }
                    }
                    if (args.has("acr-add")) {
                        void var16_73;
                        AID aid2 = null;
                        byte[] hash = null;
                        AID aID = SEAccessControl.ACR_AID;
                        if (args.has("applet")) {
                            aid2 = AID.fromString((Object)args.valueOf("applet"));
                        }
                        if (args.has("acr-hash")) {
                            hash = HexUtils.stringToBin((String)((String)args.valueOf("acr-hash")));
                        }
                        if (args.has("acr-aid")) {
                            AID aID2 = AID.fromString((Object)((String)args.valueOf("acr-aid")));
                        }
                        if (!args.has("acr-rule")) {
                            System.err.println("Must specify an access rule with -acr-rule (00, 01 or an apdu filter)");
                        }
                        if (hash != null && hash.length != 20) {
                            GPTool.fail("certificate hash must be 20 bytes");
                        }
                        SEAccessControlUtility.acrAdd((GPSession)gp, (AID)var16_73, (AID)aid2, (byte[])hash, (byte[])HexUtils.stringToBin((String)((String)args.valueOf("acr-rule"))));
                    }
                    if (args.has("acr-delete")) {
                        void var16_77;
                        byte[] byArray;
                        AID araAid = SEAccessControl.ACR_AID;
                        if (args.has("acr-aid")) {
                            araAid = AID.fromString((Object)args.valueOf("acr-aid"));
                        }
                        AID aid3 = null;
                        if (args.has("applet")) {
                            aid3 = AID.fromString((Object)"applet");
                        }
                        Object var16_75 = null;
                        if (args.has("acr-hash") && (byArray = HexUtils.stringToBin((String)((String)args.valueOf("acr-hash")))).length != 20) {
                            GPTool.fail("certificate hash must be 20 bytes");
                        }
                        SEAccessControlUtility.acrDelete((GPSession)gp, (AID)araAid, (AID)aid3, (byte[])var16_77);
                    }
                    if (args.has("lock-card")) {
                        gp.setCardStatus((byte)127);
                    }
                    if (args.has("unlock-card")) {
                        gp.setCardStatus((byte)15);
                    }
                    if (args.has("initialize-card")) {
                        gp.setCardStatus((byte)7);
                    }
                    if (args.has("secure-card")) {
                        GPRegistryEntry isd = (GPRegistryEntry)gp.getRegistry().getISD().orElseThrow(() -> new GPException("ISD is null"));
                        if (isd.getLifeCycle() != 7 && args.has("force")) {
                            System.out.println("Note: forcing status to INITIALIZED");
                            gp.setCardStatus((byte)7);
                        }
                        gp.setCardStatus((byte)15);
                    }
                    if (args.has("lock-applet")) {
                        gp.lockUnlockApplet(AID.fromString((Object)args.valueOf("lock-applet")), true);
                    }
                    if (args.has("unlock-applet")) {
                        gp.lockUnlockApplet(AID.fromString((Object)args.valueOf("unlock-applet")), false);
                    }
                    if (args.has("list")) {
                        GPCommands.listRegistry((GPRegistry)gp.getRegistry(), (PrintStream)System.out, (boolean)args.has("verbose"));
                    }
                    if (args.has("delete-key")) {
                        int keyver = GPUtils.intValue((String)((String)args.valueOf("delete-key")));
                        System.out.println("Deleting key " + keyver);
                        gp.deleteKey(keyver);
                    }
                    if (args.has("unlock")) {
                        int kv;
                        boolean replace;
                        if (gp.getScpKeyVersion() == 255) {
                            replace = false;
                            kv = 1;
                        } else {
                            kv = gp.getScpKeyVersion();
                            replace = true;
                        }
                        PlaintextKeys plaintextKeys = PlaintextKeys.defaultKey();
                        plaintextKeys.setVersion(kv);
                        gp.putKeys((GPCardKeys)plaintextKeys, replace);
                        System.out.println("Default " + HexUtils.bin2hex((byte[])PlaintextKeys.defaultKeyBytes) + " set as master key for " + gp.getAID());
                    }
                    if (args.has("lock") || args.has("lock-enc") && args.has("lock-mac") && args.has("lock-dek")) {
                        int n;
                        PlaintextKeys newKeys;
                        boolean replace = true;
                        List current = gp.getKeyInfoTemplate();
                        boolean bl = true;
                        if (current.size() > 0) {
                            if (((GPKeyInfo)current.get(0)).getVersion() == 255) {
                                replace = false;
                            } else {
                                int n2 = ((GPKeyInfo)current.get(0)).getVersion();
                            }
                        }
                        if (args.has("lock-enc") && args.has("lock-mac") && args.has("lock-dek")) {
                            byte[] enc = HexUtils.stringToBin((String)((String)args.valueOf("lock-enc")));
                            byte[] mac = HexUtils.stringToBin((String)((String)args.valueOf("lock-mac")));
                            byte[] dek = HexUtils.stringToBin((String)((String)args.valueOf("lock-dek")));
                            newKeys = PlaintextKeys.fromKeys((byte[])enc, (byte[])mac, (byte[])dek);
                        } else {
                            newKeys = PlaintextKeys.fromMasterKey((byte[])HexUtils.stringToBin((String)((String)args.valueOf("lock"))));
                            if (args.has("lock-kdf")) {
                                newKeys.setDiversifier(GPTool.getDiversificationOrFail(args, "lock-kdf"));
                            }
                        }
                        if (args.has("new-keyver")) {
                            n = GPUtils.intValue((String)((String)args.valueOf("new-keyver")));
                            replace = false;
                            System.out.println("New version: " + n);
                        }
                        newKeys.setVersion(n);
                        gp.putKeys((GPCardKeys)newKeys, replace);
                        if (args.has("lock")) {
                            System.out.println("Card locked with: " + HexUtils.bin2hex((byte[])HexUtils.stringToBin((String)((String)args.valueOf("lock")))));
                            System.out.println("Write this down, DO NOT FORGET/LOSE IT!");
                        } else {
                            System.out.println("Card locked with new keys.");
                            System.out.println("Write them down, DO NOT FORGET/LOSE THEM!");
                        }
                    }
                    if (args.has("make-default")) {
                        gp.makeDefaultSelected(AID.fromString((Object)args.valueOf("make-default")));
                    }
                    if (args.has("rename-isd")) {
                        gp.renameISD(AID.fromString((Object)args.valueOf("rename-isd")));
                    }
                    if (args.has("set-pre-perso")) {
                        byte[] payload = HexUtils.stringToBin((String)((String)args.valueOf("set-pre-perso")));
                        if (args.has("today")) {
                            System.arraycopy(GPData.CPLC.today(), 0, payload, 2, 2);
                        }
                        GPCommands.setPrePerso((GPSession)gp, (byte[])payload);
                    }
                    if (!args.has("set-perso")) continue;
                    byte[] payload = HexUtils.stringToBin((String)((String)args.valueOf("set-perso")));
                    if (args.has("today")) {
                        System.arraycopy(GPData.CPLC.today(), 0, payload, 2, 2);
                    }
                    GPCommands.setPerso((GPSession)gp, (byte[])payload);
                }
                catch (GPException e4) {
                    if (args.has("force")) continue;
                    GPTool.fail(e4.getMessage());
                }
                catch (IOException e5) {
                    System.out.println("Failed to communicate with card in " + var7_24 + ": " + e5.getMessage());
                }
                finally {
                    if (card == null) continue;
                    card.endExclusive();
                    card.disconnect(true);
                }
            }
        }
        catch (CardException e6) {
            if (TerminalManager.getExceptionMessage((Exception)e6) != null) {
                System.out.println("PC/SC failure: " + TerminalManager.getExceptionMessage((Exception)e6));
            }
            e6.printStackTrace();
            GPTool.fail("CardException, terminating");
        }
        System.exit(0);
    }

    private static void calculateDapPropertiesAndLoadCap(OptionSet args, GPSession gp, CAPFile capFile) throws GPException, IOException {
        try {
            DAPProperties dap = new DAPProperties(args, gp);
            GPTool.loadCapAccordingToDapRequirement(args, gp, dap.getTargetDomain(), dap.getDapDomain(), dap.isRequired(), capFile);
            System.out.println("CAP loaded");
        }
        catch (GPException e) {
            switch (e.sw) {
                case 27264: {
                    System.err.println("Applet loading failed. Are you sure the card can handle it?");
                    break;
                }
                case 27013: {
                    System.err.println("Applet loading not allowed. Are you sure the domain can accept it?");
                    break;
                }
            }
            throw e;
        }
    }

    private static void loadCapAccordingToDapRequirement(OptionSet args, GPSession gp, AID targetDomain, AID dapDomain, boolean dapRequired, CAPFile cap) throws IOException, GPException {
        if (dapRequired) {
            byte[] dap = args.has("sha256") ? cap.getMetaInfEntry("dap.rsa.sha256") : cap.getMetaInfEntry("dap.rsa.sha1");
            gp.loadCapFile(cap, targetDomain, dapDomain == null ? targetDomain : dapDomain, dap, args.has("sha256") ? "SHA-256" : "SHA-1");
        } else {
            gp.loadCapFile(cap, targetDomain, args.has("sha256") ? "SHA-256" : "SHA-1");
        }
    }

    @Deprecated
    private static PrivateKey getRSAPrivateKey(String path) throws IOException {
        Throwable throwable = null;
        try (FileInputStream fin = new FileInputStream(new File(path));){
            PrivateKey key = GPCrypto.pem2PrivateKey((InputStream)fin);
            if (key instanceof RSAPrivateKey) {
                PrivateKey privateKey = key;
                return privateKey;
            }
            try {
                throw new RuntimeException("Supplied key at path is not instance of RSAPrivateKey");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private static GPRegistryEntry.Privileges getInstPrivs(OptionSet args) {
        GPRegistryEntry.Privileges privs = new GPRegistryEntry.Privileges();
        if (args.has("privs")) {
            GPTool.addPrivs(privs, (String)args.valueOf("privs"));
        }
        if (args.has("default")) {
            privs.add(GPRegistryEntry.Privilege.CardReset);
        }
        if (args.has("terminate")) {
            privs.add(GPRegistryEntry.Privilege.CardLock);
            privs.add(GPRegistryEntry.Privilege.CardTerminate);
        }
        return privs;
    }

    static PlaintextKeys.Diversification getDiversificationOrFail(OptionSet args, String v) {
        PlaintextKeys.Diversification kdf = PlaintextKeys.Diversification.lookup((String)args.valueOf(v).toString().trim());
        if (kdf == null) {
            GPTool.fail("Invalid KDF: " + args.valueOf(v) + "\nvalid values: " + Arrays.asList(PlaintextKeys.Diversification.values()).stream().map(i -> i.toString()).collect(Collectors.joining("\n")));
        }
        return kdf;
    }

    private static GPRegistryEntry.Privileges addPrivs(GPRegistryEntry.Privileges privs, String v) {
        String[] parts;
        if (v == null) {
            return privs;
        }
        for (String s : parts = v.split(",")) {
            GPRegistryEntry.Privilege p = GPRegistryEntry.Privilege.lookup((String)s.trim());
            if (p == null) {
                throw new IllegalArgumentException("Unknown privilege: " + s.trim());
            }
            privs.add(p);
        }
        return privs;
    }

    private static byte[] getInstParams(OptionSet args) {
        if (args.has("params")) {
            String arg = (String)args.valueOf("params");
            return HexUtils.stringToBin((String)arg);
        }
        return new byte[0];
    }

    private static boolean ignoreReader(String name) {
        String ignore = System.getenv("GP_READER_IGNORE");
        if (ignore != null) {
            String[] names;
            for (String n : names = ignore.toLowerCase().split(";")) {
                if (!name.toLowerCase().contains(n)) continue;
                return true;
            }
        }
        return false;
    }

    private static List<CAPFile> getCapFileList(OptionSet args, String arg) {
        return args.valuesOf(arg).stream().map(e -> {
            try (FileInputStream fin = new FileInputStream((File)e);){
                CAPFile cAPFile = CAPFile.fromStream((InputStream)fin);
                return cAPFile;
            }
            catch (IOException x) {
                GPTool.fail("Could not read CAP: " + x.getMessage());
                return null;
            }
        }).collect(Collectors.toList());
    }

    private static boolean needsAuthentication(OptionSet args) {
        String[] yes = new String[]{"list", "load", "install", "delete", "delete-key", "create", "acr-add", "acr-delete", "lock", "unlock", "lock-enc", "lock-mac", "lock-dek", "make-default", "uninstall", "secure-apdu", "domain", "lock-card", "unlock-card", "lock-applet", "unlock-applet", "store-data", "store-data-chunk", "initialize-card", "secure-card", "rename-isd", "set-perso", "set-pre-perso", "move", "put-key", "acr-aid", "acr-list"};
        return Arrays.stream(yes).anyMatch(str -> args.has(str));
    }

    public static void fail(String msg) {
        System.err.println(msg);
        System.exit(1);
    }

    private static void verbose(String s) {
        if (isVerbose) {
            System.out.println("# " + s);
        }
    }
}

