/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import java.io.IOException;
import joptsimple.OptionSet;
import pro.javacard.AID;
import pro.javacard.gp.GPException;
import pro.javacard.gp.GPRegistry;
import pro.javacard.gp.GPRegistryEntry;
import pro.javacard.gp.GPSession;

public class DAPProperties {
    private AID targetDomain = null;
    private AID dapDomain = null;
    private boolean required = false;

    public DAPProperties(OptionSet args, GPSession gp) throws IOException, IllegalArgumentException {
        GPRegistryEntry target;
        GPRegistry reg = gp.getRegistry();
        if (args.has("to")) {
            this.targetDomain = AID.fromString((Object)args.valueOf("to"));
            target = (GPRegistryEntry)reg.getDomain(this.targetDomain).orElseThrow(() -> new IllegalArgumentException("Target domain does not exist: " + this.targetDomain));
            this.required = this.required || target.hasPrivilege(GPRegistryEntry.Privilege.DAPVerification);
        }
        boolean bl = this.required = this.required || reg.allDomains().stream().anyMatch(e -> e.hasPrivilege(GPRegistryEntry.Privilege.MandatedDAPVerification));
        if (args.has("dap-domain")) {
            this.dapDomain = AID.fromString((Object)args.valueOf("dap-domain"));
            target = (GPRegistryEntry)reg.getDomain(this.targetDomain).orElseThrow(() -> new IllegalArgumentException("DAP domain does not exist: " + this.targetDomain));
            if (!target.hasPrivilege(GPRegistryEntry.Privilege.DAPVerification) && !target.hasPrivilege(GPRegistryEntry.Privilege.MandatedDAPVerification)) {
                throw new GPException("Specified DAP domain does not have (Mandated)DAPVerification privilege: " + this.targetDomain.toString());
            }
        }
    }

    public AID getTargetDomain() {
        return this.targetDomain;
    }

    public AID getDapDomain() {
        return this.dapDomain;
    }

    public boolean isRequired() {
        return this.required;
    }
}

