/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.CommandAPDU;
import apdu4j.ResponseAPDU;
import java.util.EnumSet;
import pro.javacard.gp.GPException;
import pro.javacard.gp.GPSession;
import pro.javacard.gp.GPSessionKeys;

abstract class SecureChannelWrapper {
    protected final int blockSize;
    protected final GPSessionKeys sessionKeys;
    protected final boolean mac;
    protected final boolean enc;
    protected final boolean rmac;
    protected final boolean renc;

    protected SecureChannelWrapper(GPSessionKeys keys, EnumSet<GPSession.APDUMode> securityLevel, int bs) {
        this.mac = securityLevel.contains((Object)GPSession.APDUMode.MAC);
        this.enc = securityLevel.contains((Object)GPSession.APDUMode.ENC);
        this.rmac = securityLevel.contains((Object)GPSession.APDUMode.RMAC);
        this.renc = securityLevel.contains((Object)GPSession.APDUMode.RENC);
        this.sessionKeys = keys;
        this.blockSize = bs;
    }

    protected int getBlockSize() {
        int res = this.blockSize;
        if (this.mac) {
            res -= 8;
        }
        if (this.enc) {
            res -= 8;
        }
        return res;
    }

    abstract CommandAPDU wrap(CommandAPDU var1) throws GPException;

    abstract ResponseAPDU unwrap(ResponseAPDU var1) throws GPException;
}

