/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.HexUtils;
import java.util.Map;
import java.util.Optional;
import pro.javacard.AID;
import pro.javacard.gp.GPCardKeys;
import pro.javacard.gp.GPUtils;
import pro.javacard.gp.PlaintextKeys;

public class SecureChannelParameters {
    private AID aid;
    private GPCardKeys cardKeys;

    public Optional<AID> getAID() {
        return Optional.ofNullable(this.aid);
    }

    public GPCardKeys getCardKeys() {
        return this.cardKeys;
    }

    public static Optional<SecureChannelParameters> fromEnvironment() {
        return SecureChannelParameters.fromKeyValuePairs(System.getenv());
    }

    public static Optional<SecureChannelParameters> fromKeyValuePairs(Map<String, String> env) {
        SecureChannelParameters params = new SecureChannelParameters();
        if (env.containsKey("GP_KEY_ENC") && env.containsKey("GP_KEY_MAC") && env.containsKey("GP_KEY_DEK")) {
            byte[] enc = HexUtils.stringToBin((String)env.get("GP_KEY_ENC"));
            byte[] mac = HexUtils.stringToBin((String)env.get("GP_KEY_MAC"));
            byte[] dek = HexUtils.stringToBin((String)env.get("GP_KEY_DEK"));
            params.cardKeys = PlaintextKeys.fromKeys(enc, mac, dek);
            if (env.containsKey("GP_KEY_VERSION")) {
                ((PlaintextKeys)params.cardKeys).setVersion(GPUtils.intValue(env.get("GP_KEY_VERSION")));
            }
            if (env.containsKey("GP_AID")) {
                params.aid = AID.fromString((Object)env.get("GP_AID"));
            }
        } else {
            return Optional.empty();
        }
        return Optional.of(params);
    }
}

