/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.APDUBIBO;
import apdu4j.CommandAPDU;
import apdu4j.ResponseAPDU;
import com.payneteasy.tlv.BerTlv;
import com.payneteasy.tlv.BerTlvBuilder;
import java.io.IOException;
import pro.javacard.AID;
import pro.javacard.gp.GPException;
import pro.javacard.gp.GPSession;
import pro.javacard.gp.SEAccessControl;

public final class SEAccessControlUtility {
    private static ResponseAPDU sendAcrGetData(APDUBIBO channel, byte P1) throws IOException, GPException {
        CommandAPDU list = new CommandAPDU(-128, -54, 255, (int)P1, 256);
        ResponseAPDU response = channel.transmit(list);
        try {
            GPException.check(response, "ACR GET DATA failed", new int[0]);
        }
        catch (GPException e) {
            if (SEAccessControl.ACR_GET_DATA_ERROR.containsKey(e.sw)) {
                System.out.println("[SW] " + SEAccessControl.ACR_GET_DATA_ERROR.get(e.sw));
            }
            throw e;
        }
        return response;
    }

    public static void acrList(GPSession gp) throws IOException, GPException {
        try {
            gp.select(SEAccessControl.ACR_AID);
            ResponseAPDU response = SEAccessControlUtility.sendAcrGetData(gp.getCardChannel(), (byte)64);
            SEAccessControl.BerTlvData temp = SEAccessControl.AcrListResponse.getAcrListData(null, response.getData());
            while (temp.getCurrentIndex() < temp.getLength()) {
                response = SEAccessControlUtility.sendAcrGetData(gp.getCardChannel(), (byte)96);
                temp = SEAccessControl.AcrListResponse.getAcrListData(temp, response.getData());
            }
            SEAccessControl.AcrListResponse resp = SEAccessControl.AcrListResponse.fromBytes(temp.getData());
            SEAccessControl.printList(resp.acrList);
        }
        catch (GPException e) {
            throw new GPException("Could not read " + SEAccessControl.ACR_AID);
        }
    }

    public static void acrAdd(GPSession gp, AID araAid, AID aid, byte[] hash, byte[] rules) throws IOException, GPException {
        SEAccessControl.RefArDo refArDo = new SEAccessControl.RefArDo(aid, hash, rules);
        SEAccessControl.StoreArDo storeArDo = new SEAccessControl.StoreArDo(refArDo);
        SEAccessControlUtility.acrStore(gp, araAid, storeArDo.toTlv());
    }

    public static void acrStore(GPSession gp, AID araAid, BerTlv data) throws IOException, GPException {
        try {
            gp.personalizeSingle(araAid, new BerTlvBuilder().addBerTlv(data).buildArray(), -112);
        }
        catch (GPException e) {
            if (SEAccessControl.ACR_STORE_DATA_ERROR.containsKey(e.sw)) {
                System.out.println("[SW] " + SEAccessControl.ACR_STORE_DATA_ERROR.get(e.sw));
            }
            System.out.println(e.getMessage());
        }
    }

    public static void acrDelete(GPSession gp, AID araAid, AID aid, byte[] hash) throws IOException, GPException {
        BerTlv request;
        if (hash != null) {
            SEAccessControl.RefArDo refArDo = new SEAccessControl.RefArDo(aid, hash, null);
            request = new SEAccessControl.DeleteArDo(refArDo).toTlv();
        } else if (aid != null) {
            SEAccessControl.AidRefDo aidRefDo = new SEAccessControl.AidRefDo(aid.getBytes());
            request = new SEAccessControl.DeleteAidDo(aidRefDo).toTlv();
        } else {
            request = new SEAccessControl.DeleteAll().toTlv();
        }
        SEAccessControlUtility.acrStore(gp, araAid, request);
    }
}

