/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.CommandAPDU;
import apdu4j.HexUtils;
import apdu4j.ResponseAPDU;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.EnumSet;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import pro.javacard.gp.GPCardKeys;
import pro.javacard.gp.GPCrypto;
import pro.javacard.gp.GPException;
import pro.javacard.gp.GPSession;
import pro.javacard.gp.GPSessionKeys;
import pro.javacard.gp.GPUtils;
import pro.javacard.gp.SecureChannelWrapper;

class SCP03Wrapper
extends SecureChannelWrapper {
    byte[] chaining_value = new byte[16];
    byte[] encryption_counter = new byte[16];

    SCP03Wrapper(GPSessionKeys sessionKeys, EnumSet<GPSession.APDUMode> securityLevel, int bs) {
        super(sessionKeys, securityLevel, bs);
    }

    @Override
    protected CommandAPDU wrap(CommandAPDU command) throws GPException {
        byte[] cmd_mac = null;
        try {
            int cla = command.getCLA();
            int lc = command.getNc();
            byte[] data = command.getData();
            if (this.enc) {
                cla = 132;
                GPCrypto.buffer_increment(this.encryption_counter);
                if (command.getData().length > 0) {
                    byte[] d = GPCrypto.pad80(command.getData(), 16);
                    Cipher c = Cipher.getInstance("AES/CBC/NoPadding");
                    c.init(1, GPCrypto.aeskey(this.sessionKeys.get(GPCardKeys.KeyPurpose.ENC)), GPCrypto.iv_null_16);
                    byte[] iv = c.doFinal(this.encryption_counter);
                    c.init(1, GPCrypto.aeskey(this.sessionKeys.get(GPCardKeys.KeyPurpose.ENC)), new IvParameterSpec(iv));
                    data = c.doFinal(d);
                    lc = data.length;
                }
            }
            if (this.mac) {
                cla = 132;
                lc += 8;
                ByteArrayOutputStream bo = new ByteArrayOutputStream();
                bo.write(this.chaining_value);
                bo.write(cla);
                bo.write(command.getINS());
                bo.write(command.getP1());
                bo.write(command.getP2());
                bo.write(GPUtils.encodeLcLength(lc));
                bo.write(data);
                byte[] cmac_input = bo.toByteArray();
                byte[] cmac = GPCrypto.scp03_mac(this.sessionKeys.get(GPCardKeys.KeyPurpose.MAC), cmac_input, 128);
                System.arraycopy(cmac, 0, this.chaining_value, 0, this.chaining_value.length);
                cmd_mac = Arrays.copyOf(cmac, 8);
            }
            CommandAPDU newAPDU = null;
            ByteArrayOutputStream newData = new ByteArrayOutputStream();
            newData.write(data);
            if (this.mac) {
                newData.write(cmd_mac);
            }
            newAPDU = command.getNe() > 0 ? new CommandAPDU(cla, command.getINS(), command.getP1(), command.getP2(), newData.toByteArray(), command.getNe()) : new CommandAPDU(cla, command.getINS(), command.getP1(), command.getP2(), newData.toByteArray());
            return newAPDU;
        }
        catch (IOException e) {
            throw new RuntimeException("APDU wrapping failed", e);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalStateException("APDU wrapping failed", e);
        }
        catch (GeneralSecurityException e) {
            throw new GPException("APDU wrapping failed", e);
        }
    }

    @Override
    protected ResponseAPDU unwrap(ResponseAPDU response) throws GPException {
        try {
            if (this.rmac) {
                if (response.getData().length < 8) {
                    throw new RuntimeException("Wrong response length (too short).");
                }
                int respLen = response.getData().length - 8;
                byte[] actualMac = new byte[8];
                System.arraycopy(response.getData(), respLen, actualMac, 0, 8);
                ByteArrayOutputStream bo = new ByteArrayOutputStream();
                bo.write(this.chaining_value);
                bo.write(response.getData(), 0, respLen);
                bo.write(response.getSW1());
                bo.write(response.getSW2());
                byte[] cmac_input = bo.toByteArray();
                byte[] cmac = GPCrypto.scp03_mac(this.sessionKeys.get(GPCardKeys.KeyPurpose.RMAC), cmac_input, 128);
                byte[] resp_mac = Arrays.copyOf(cmac, 8);
                if (!Arrays.equals(resp_mac, actualMac)) {
                    throw new GPException("RMAC invalid: " + HexUtils.bin2hex((byte[])actualMac) + " vs " + HexUtils.bin2hex((byte[])resp_mac));
                }
                ByteArrayOutputStream o = new ByteArrayOutputStream();
                o.write(response.getBytes(), 0, respLen);
                o.write(response.getSW1());
                o.write(response.getSW2());
                response = new ResponseAPDU(o.toByteArray());
            }
            if (this.renc && response.getData().length > 0) {
                byte[] response_encryption_counter = Arrays.copyOf(this.encryption_counter, this.encryption_counter.length);
                response_encryption_counter[0] = -128;
                Cipher c = Cipher.getInstance("AES/CBC/NoPadding");
                c.init(1, GPCrypto.aeskey(this.sessionKeys.get(GPCardKeys.KeyPurpose.ENC)), GPCrypto.iv_null_16);
                byte[] iv = c.doFinal(response_encryption_counter);
                c.init(2, GPCrypto.aeskey(this.sessionKeys.get(GPCardKeys.KeyPurpose.ENC)), new IvParameterSpec(iv));
                byte[] data = c.doFinal(response.getData());
                ByteArrayOutputStream o = new ByteArrayOutputStream();
                o.write(GPCrypto.unpad80(data));
                o.write(response.getSW1());
                o.write(response.getSW2());
                response = new ResponseAPDU(o.toByteArray());
            }
            return response;
        }
        catch (IOException e) {
            throw new RuntimeException("APDU unwrapping failed", e);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalStateException("APDU unwrapping failed", e);
        }
        catch (GeneralSecurityException e) {
            throw new GPException("APDU unwrapping failed", e);
        }
    }
}

