/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.CommandAPDU;
import apdu4j.ResponseAPDU;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.EnumSet;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import pro.javacard.gp.GPCardKeys;
import pro.javacard.gp.GPCrypto;
import pro.javacard.gp.GPException;
import pro.javacard.gp.GPSession;
import pro.javacard.gp.GPSessionKeys;
import pro.javacard.gp.SecureChannelWrapper;

class SCP01Wrapper
extends SecureChannelWrapper {
    private boolean icvEnc = false;
    private boolean preAPDU = true;
    private boolean postAPDU = false;
    byte[] icv = null;

    SCP01Wrapper(GPSessionKeys sessionKeys, EnumSet<GPSession.APDUMode> securityLevel, int bs) {
        super(sessionKeys, securityLevel, bs);
        this.setVariant(21);
    }

    private static byte setBits(byte b, byte mask) {
        return (byte)((b | mask) & 0xFF);
    }

    public void setVariant(int i) {
        if (i == 5) {
            this.icvEnc = false;
        }
    }

    @Override
    public CommandAPDU wrap(CommandAPDU command) throws GPException {
        try {
            Cipher c;
            int origLc;
            int origCLA;
            if (!this.mac && !this.enc) {
                return command;
            }
            int newCLA = origCLA = command.getCLA();
            int origINS = command.getINS();
            int origP1 = command.getP1();
            int origP2 = command.getP2();
            byte[] origData = command.getData();
            int newLc = origLc = command.getNc();
            byte[] newData = null;
            int le = command.getNe();
            ByteArrayOutputStream t = new ByteArrayOutputStream();
            if (origLc > this.getBlockSize()) {
                throw new IllegalArgumentException("APDU too long for wrapping.");
            }
            if (this.mac) {
                if (this.icv == null) {
                    this.icv = new byte[8];
                } else if (this.icvEnc) {
                    c = Cipher.getInstance("DESede/ECB/NoPadding");
                    c.init(1, GPCrypto.des3key(this.sessionKeys.get(GPCardKeys.KeyPurpose.MAC)));
                    this.icv = c.doFinal(this.icv);
                }
                if (this.preAPDU) {
                    newCLA = SCP01Wrapper.setBits((byte)newCLA, (byte)4);
                    newLc += 8;
                }
                t.write(newCLA);
                t.write(origINS);
                t.write(origP1);
                t.write(origP2);
                t.write(newLc);
                t.write(origData);
                this.icv = GPCrypto.mac_3des(this.sessionKeys.get(GPCardKeys.KeyPurpose.MAC), t.toByteArray(), this.icv);
                if (this.postAPDU) {
                    newCLA = SCP01Wrapper.setBits((byte)newCLA, (byte)4);
                    newLc += 8;
                }
                t.reset();
                newData = origData;
            }
            if (this.enc && origLc > 0) {
                t.write(origLc);
                t.write(origData);
                if (t.size() % 8 != 0) {
                    byte[] x = GPCrypto.pad80(t.toByteArray(), 8);
                    t.reset();
                    t.write(x);
                }
                newLc += t.size() - origData.length;
                c = Cipher.getInstance("DESede/CBC/NoPadding");
                c.init(1, GPCrypto.des3key(this.sessionKeys.get(GPCardKeys.KeyPurpose.ENC)), GPCrypto.iv_null_8);
                newData = c.doFinal(t.toByteArray());
                t.reset();
            }
            t.write(newCLA);
            t.write(origINS);
            t.write(origP1);
            t.write(origP2);
            if (newLc > 0) {
                t.write(newLc);
                t.write(newData);
            }
            if (this.mac) {
                t.write(this.icv);
            }
            if (le > 0) {
                t.write(le);
            }
            CommandAPDU wrapped = new CommandAPDU(t.toByteArray());
            return wrapped;
        }
        catch (IOException e) {
            throw new RuntimeException("APDU wrapping failed", e);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalStateException("APDU wrapping failed", e);
        }
        catch (GeneralSecurityException e) {
            throw new GPException("APDU wrapping failed", e);
        }
    }

    @Override
    public ResponseAPDU unwrap(ResponseAPDU response) throws GPException {
        return response;
    }
}

