/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.HexUtils;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.javacard.gp.GPCardKeys;
import pro.javacard.gp.GPCrypto;
import pro.javacard.gp.GPException;
import pro.javacard.gp.GPKeyInfo;
import pro.javacard.gp.GPSecureChannel;
import pro.javacard.gp.GPSessionKeys;
import pro.javacard.gp.GPUtils;

public class PlaintextKeys
extends GPCardKeys {
    private static final Logger logger = LoggerFactory.getLogger(PlaintextKeys.class);
    static final byte[] defaultKeyBytes = HexUtils.hex2bin((String)"404142434445464748494A4B4C4D4E4F");
    public static final Map<GPCardKeys.KeyPurpose, byte[]> SCP02_CONSTANTS;
    public static final Map<GPCardKeys.KeyPurpose, Byte> SCP03_CONSTANTS;
    public static final Map<GPCardKeys.KeyPurpose, byte[]> SCP03_KDF_CONSTANTS;
    Diversification diversifier;
    private int version = 0;
    private HashMap<GPCardKeys.KeyPurpose, byte[]> cardKeys = new HashMap();
    private HashMap<GPCardKeys.KeyPurpose, byte[]> sessionKeys = new HashMap();

    private PlaintextKeys(byte[] enc, byte[] mac, byte[] dek, Diversification d) {
        this.cardKeys.put(GPCardKeys.KeyPurpose.ENC, enc);
        this.cardKeys.put(GPCardKeys.KeyPurpose.MAC, mac);
        this.cardKeys.put(GPCardKeys.KeyPurpose.DEK, dek);
        this.diversifier = d;
    }

    public static PlaintextKeys fromMasterKey(byte[] master) {
        return PlaintextKeys.derivedFromMasterKey(master, null, Diversification.NONE);
    }

    public static PlaintextKeys fromMasterKey(byte[] master, byte[] kcv) {
        return PlaintextKeys.derivedFromMasterKey(master, kcv, Diversification.NONE);
    }

    public static PlaintextKeys defaultKey() {
        return PlaintextKeys.derivedFromMasterKey(defaultKeyBytes, null, Diversification.NONE);
    }

    public static PlaintextKeys derivedFromMasterKey(byte[] master, byte[] kcv, Diversification div) {
        if (kcv != null && kcv.length == 3) {
            byte[] kcv_des = GPCrypto.kcv_3des(master);
            byte[] kcv_aes = GPCrypto.kcv_aes(master);
            if (Arrays.equals(kcv_des, kcv)) {
                logger.debug("KCV matches 3DES");
            } else if (Arrays.equals(kcv_aes, kcv)) {
                logger.debug("KCV matches AES");
            } else {
                String msg = String.format("KCV mismatch: %s vs %s (3DES) or %s (AES)", HexUtils.bin2hex((byte[])kcv), HexUtils.bin2hex((byte[])kcv_des), HexUtils.bin2hex((byte[])kcv_aes));
                throw new IllegalArgumentException(msg);
            }
        }
        return new PlaintextKeys(master, master, master, div);
    }

    public static PlaintextKeys fromKeys(byte[] enc, byte[] mac, byte[] dek) {
        return new PlaintextKeys(enc, mac, dek, Diversification.NONE);
    }

    public static byte[] diversify(byte[] k, GPCardKeys.KeyPurpose usage, byte[] kdd, Diversification method) throws GPException {
        try {
            byte[] kv;
            if (method == Diversification.KDF3) {
                return GPCrypto.scp03_kdf(k, new byte[0], GPUtils.concatenate(SCP03_KDF_CONSTANTS.get((Object)usage), kdd), k.length);
            }
            if (method == Diversification.VISA2) {
                kv = PlaintextKeys.fillVisa2(kdd, usage);
            } else if (method == Diversification.EMV) {
                kv = PlaintextKeys.fillEmv(kdd, usage);
            } else {
                throw new IllegalStateException("Unknown diversification method");
            }
            Cipher cipher = Cipher.getInstance("DESede/ECB/NoPadding");
            cipher.init(1, GPCrypto.des3key(k));
            return cipher.doFinal(kv);
        }
        catch (InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            throw new GPException("Diversification failed.", e);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException("Can not diversify", e);
        }
    }

    public static final byte[] fillVisa2(byte[] kdd, GPCardKeys.KeyPurpose key) {
        byte[] data = new byte[16];
        System.arraycopy(kdd, 0, data, 0, 2);
        System.arraycopy(kdd, 4, data, 2, 4);
        data[6] = -16;
        data[7] = key.getValue();
        System.arraycopy(kdd, 0, data, 8, 2);
        System.arraycopy(kdd, 4, data, 10, 4);
        data[14] = 15;
        data[15] = key.getValue();
        return data;
    }

    public static final byte[] fillVisa(byte[] kdd, GPCardKeys.KeyPurpose key) {
        byte[] data = new byte[16];
        System.arraycopy(kdd, 0, data, 0, 4);
        System.arraycopy(kdd, 8, data, 4, 2);
        data[6] = -16;
        data[7] = 1;
        System.arraycopy(kdd, 0, data, 8, 4);
        System.arraycopy(kdd, 8, data, 12, 2);
        data[14] = 15;
        data[15] = 1;
        return data;
    }

    public static final byte[] fillEmv(byte[] kdd, GPCardKeys.KeyPurpose key) {
        byte[] data = new byte[16];
        System.arraycopy(kdd, 4, data, 0, 6);
        data[6] = -16;
        data[7] = key.getValue();
        System.arraycopy(kdd, 4, data, 8, 6);
        data[14] = 15;
        data[15] = key.getValue();
        return data;
    }

    @Override
    public GPKeyInfo getKeyInfo() {
        byte[] aKey = this.cardKeys.get((Object)GPCardKeys.KeyPurpose.ENC);
        int type = aKey.length > 16 || this.scp == GPSecureChannel.SCP03 ? 136 : 128;
        return new GPKeyInfo(this.version, 1, aKey.length, type);
    }

    @Override
    public byte[] encrypt(byte[] data) throws GeneralSecurityException {
        if (this.scp == GPSecureChannel.SCP02) {
            return GPCrypto.dek_encrypt_des(this.sessionKeys.get((Object)GPCardKeys.KeyPurpose.DEK), data);
        }
        if (this.scp == GPSecureChannel.SCP01) {
            return GPCrypto.dek_encrypt_des(this.cardKeys.get((Object)GPCardKeys.KeyPurpose.DEK), data);
        }
        if (this.scp == GPSecureChannel.SCP03) {
            return GPCrypto.dek_encrypt_aes(this.cardKeys.get((Object)GPCardKeys.KeyPurpose.DEK), data);
        }
        throw new IllegalStateException("Unknown SCP version");
    }

    @Override
    public byte[] encryptKey(GPCardKeys key, GPCardKeys.KeyPurpose p) throws GeneralSecurityException {
        if (!(key instanceof PlaintextKeys)) {
            throw new IllegalArgumentException(this.getClass().getName() + " can only handle " + this.getClass().getName());
        }
        PlaintextKeys other = (PlaintextKeys)key;
        logger.debug("Encrypting {} value {} with {}", new Object[]{p, HexUtils.bin2hex((byte[])other.cardKeys.get((Object)p)), HexUtils.bin2hex((byte[])this.cardKeys.get((Object)GPCardKeys.KeyPurpose.DEK))});
        switch (this.scp) {
            case SCP01: {
                return GPCrypto.dek_encrypt_des(this.cardKeys.get((Object)GPCardKeys.KeyPurpose.DEK), other.cardKeys.get((Object)p));
            }
            case SCP02: {
                logger.debug("Encrypting {} value {} with {}", new Object[]{p, HexUtils.bin2hex((byte[])other.cardKeys.get((Object)p)), HexUtils.bin2hex((byte[])this.sessionKeys.get((Object)GPCardKeys.KeyPurpose.DEK))});
                return GPCrypto.dek_encrypt_des(this.sessionKeys.get((Object)GPCardKeys.KeyPurpose.DEK), other.cardKeys.get((Object)p));
            }
            case SCP03: {
                byte[] otherkey = other.cardKeys.get((Object)p);
                int n = otherkey.length % 16 + 1;
                byte[] plaintext = new byte[n * otherkey.length];
                GPCrypto.random.nextBytes(plaintext);
                System.arraycopy(otherkey, 0, plaintext, 0, otherkey.length);
                return GPCrypto.dek_encrypt_aes(this.cardKeys.get((Object)GPCardKeys.KeyPurpose.DEK), plaintext);
            }
        }
        throw new GPException("Illegal SCP");
    }

    @Override
    public GPSessionKeys getSessionKeys(byte[] kdd) {
        block5: for (GPCardKeys.KeyPurpose p : GPCardKeys.KeyPurpose.cardKeys()) {
            switch (this.scp) {
                case SCP01: {
                    this.sessionKeys.put(p, this.deriveSessionKeySCP01(this.cardKeys.get((Object)p), p, kdd));
                    continue block5;
                }
                case SCP02: {
                    this.sessionKeys.put(p, this.deriveSessionKeySCP02(this.cardKeys.get((Object)p), p, kdd));
                    if (p != GPCardKeys.KeyPurpose.MAC) continue block5;
                    this.sessionKeys.put(GPCardKeys.KeyPurpose.RMAC, this.deriveSessionKeySCP02(this.cardKeys.get((Object)p), GPCardKeys.KeyPurpose.RMAC, kdd));
                    continue block5;
                }
                case SCP03: {
                    this.sessionKeys.put(p, this.deriveSessionKeySCP03(this.cardKeys.get((Object)p), p, kdd));
                    if (p != GPCardKeys.KeyPurpose.MAC) continue block5;
                    this.sessionKeys.put(GPCardKeys.KeyPurpose.RMAC, this.deriveSessionKeySCP03(this.cardKeys.get((Object)p), GPCardKeys.KeyPurpose.RMAC, kdd));
                    continue block5;
                }
            }
            throw new IllegalStateException("Illegal SCP");
        }
        return new GPSessionKeys(this, this.sessionKeys.get((Object)GPCardKeys.KeyPurpose.ENC), this.sessionKeys.get((Object)GPCardKeys.KeyPurpose.MAC), this.sessionKeys.get((Object)GPCardKeys.KeyPurpose.RMAC));
    }

    @Override
    public byte[] kcv(GPCardKeys.KeyPurpose p) {
        byte[] k = this.cardKeys.get((Object)p);
        if (this.scp == GPSecureChannel.SCP03) {
            return GPCrypto.kcv_aes(k);
        }
        if (this.scp == GPSecureChannel.SCP01 || this.scp == GPSecureChannel.SCP02) {
            return GPCrypto.kcv_3des(k);
        }
        if (k.length == 16) {
            logger.warn("Don't know how to calculate KCV, defaulting to SCP02");
            return GPCrypto.kcv_3des(k);
        }
        logger.warn("Don't know how to calculate KCV, defaulting to SCP03");
        return GPCrypto.kcv_aes(k);
    }

    public void setVersion(int version) {
        this.version = version;
    }

    private byte[] deriveSessionKeySCP01(byte[] cardKey, GPCardKeys.KeyPurpose p, byte[] kdd) {
        if (p == GPCardKeys.KeyPurpose.DEK) {
            return cardKey;
        }
        byte[] derivationData = new byte[16];
        System.arraycopy(kdd, 12, derivationData, 0, 4);
        System.arraycopy(kdd, 0, derivationData, 4, 4);
        System.arraycopy(kdd, 8, derivationData, 8, 4);
        System.arraycopy(kdd, 4, derivationData, 12, 4);
        try {
            Cipher cipher = Cipher.getInstance("DESede/ECB/NoPadding");
            cipher.init(1, GPCrypto.des3key(cardKey));
            return cipher.doFinal(derivationData);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalStateException("Can not calculate session keys", e);
        }
        catch (InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            throw new RuntimeException("Session key calculation failed", e);
        }
    }

    private byte[] deriveSessionKeySCP02(byte[] cardKey, GPCardKeys.KeyPurpose p, byte[] sequence) {
        try {
            Cipher cipher = Cipher.getInstance("DESede/CBC/NoPadding");
            byte[] derivationData = new byte[16];
            System.arraycopy(sequence, 0, derivationData, 2, 2);
            System.arraycopy(SCP02_CONSTANTS.get((Object)p), 0, derivationData, 0, 2);
            cipher.init(1, GPCrypto.des3key(cardKey), GPCrypto.iv_null_8);
            return cipher.doFinal(derivationData);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalStateException("Session keys calculation failed.", e);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            throw new RuntimeException("Session keys calculation failed.", e);
        }
    }

    private byte[] deriveSessionKeySCP03(byte[] cardKey, GPCardKeys.KeyPurpose p, byte[] kdd) {
        if (p == GPCardKeys.KeyPurpose.DEK) {
            return cardKey;
        }
        byte[] kdf = GPCrypto.scp03_kdf(cardKey, SCP03_CONSTANTS.get((Object)p), kdd, cardKey.length * 8);
        return kdf;
    }

    @Override
    public GPCardKeys diversify(GPSecureChannel scp, byte[] kdd) {
        super.diversify(scp, kdd);
        if (this.diversifier == Diversification.NONE) {
            return this;
        }
        for (Map.Entry<GPCardKeys.KeyPurpose, byte[]> e : this.cardKeys.entrySet()) {
            this.cardKeys.put(e.getKey(), PlaintextKeys.diversify(e.getValue(), e.getKey(), kdd, this.diversifier));
        }
        return this;
    }

    @Override
    public String toString() {
        String enc = HexUtils.bin2hex((byte[])this.cardKeys.get((Object)GPCardKeys.KeyPurpose.ENC));
        String enc_kcv = HexUtils.bin2hex((byte[])this.kcv(GPCardKeys.KeyPurpose.ENC));
        String mac = HexUtils.bin2hex((byte[])this.cardKeys.get((Object)GPCardKeys.KeyPurpose.MAC));
        String mac_kcv = HexUtils.bin2hex((byte[])this.kcv(GPCardKeys.KeyPurpose.MAC));
        String dek = HexUtils.bin2hex((byte[])this.cardKeys.get((Object)GPCardKeys.KeyPurpose.DEK));
        String dek_kcv = HexUtils.bin2hex((byte[])this.kcv(GPCardKeys.KeyPurpose.DEK));
        return String.format("ENC=%s (KCV: %s) MAC=%s (KCV: %s) DEK=%s (KCV: %s) for %s", new Object[]{enc, enc_kcv, mac, mac_kcv, dek, dek_kcv, this.scp});
    }

    public void setDiversifier(Diversification diversifier) {
        this.diversifier = diversifier;
    }

    static {
        HashMap<GPCardKeys.KeyPurpose, byte[]> scp2 = new HashMap<GPCardKeys.KeyPurpose, byte[]>();
        scp2.put(GPCardKeys.KeyPurpose.MAC, new byte[]{1, 1});
        scp2.put(GPCardKeys.KeyPurpose.RMAC, new byte[]{1, 2});
        scp2.put(GPCardKeys.KeyPurpose.DEK, new byte[]{1, -127});
        scp2.put(GPCardKeys.KeyPurpose.ENC, new byte[]{1, -126});
        SCP02_CONSTANTS = Collections.unmodifiableMap(scp2);
        HashMap<GPCardKeys.KeyPurpose, Byte> scp3 = new HashMap<GPCardKeys.KeyPurpose, Byte>();
        scp3.put(GPCardKeys.KeyPurpose.ENC, (byte)4);
        scp3.put(GPCardKeys.KeyPurpose.MAC, (byte)6);
        scp3.put(GPCardKeys.KeyPurpose.RMAC, (byte)7);
        SCP03_CONSTANTS = Collections.unmodifiableMap(scp3);
        HashMap<GPCardKeys.KeyPurpose, byte[]> scp3kdf = new HashMap<GPCardKeys.KeyPurpose, byte[]>();
        scp3kdf.put(GPCardKeys.KeyPurpose.ENC, HexUtils.hex2bin((String)"0000000100"));
        scp3kdf.put(GPCardKeys.KeyPurpose.MAC, HexUtils.hex2bin((String)"0000000200"));
        scp3kdf.put(GPCardKeys.KeyPurpose.DEK, HexUtils.hex2bin((String)"0000000300"));
        SCP03_KDF_CONSTANTS = Collections.unmodifiableMap(scp3kdf);
    }

    public static enum Diversification {
        NONE,
        VISA2,
        EMV,
        KDF3;


        public static Diversification lookup(String v) {
            for (Diversification d : Diversification.values()) {
                if (!d.name().equalsIgnoreCase(v)) continue;
                return d;
            }
            return null;
        }
    }
}

