/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.HexUtils;
import java.security.GeneralSecurityException;
import pro.javacard.gp.GPCardKeys;

public class GPSessionKeys {
    GPCardKeys cardKeys;
    private final byte[] enc;
    private final byte[] mac;
    private final byte[] rmac;

    public GPSessionKeys(GPCardKeys cardKeys, byte[] enc, byte[] mac, byte[] rmac) {
        this.cardKeys = cardKeys;
        this.enc = (byte[])enc.clone();
        this.mac = (byte[])mac.clone();
        this.rmac = rmac == null ? new byte[0] : (byte[])rmac.clone();
    }

    public byte[] encrypt(byte[] data) throws GeneralSecurityException {
        return this.cardKeys.encrypt(data);
    }

    public byte[] encryptKey(GPCardKeys other, GPCardKeys.KeyPurpose p) throws GeneralSecurityException {
        return this.cardKeys.encryptKey(other, p);
    }

    public byte[] get(GPCardKeys.KeyPurpose p) {
        switch (p) {
            case ENC: {
                return (byte[])this.enc.clone();
            }
            case MAC: {
                return (byte[])this.mac.clone();
            }
            case RMAC: {
                return (byte[])this.rmac.clone();
            }
        }
        throw new IllegalArgumentException("Invalid session key: " + (Object)((Object)p));
    }

    public String toString() {
        return String.format("ENC=%s MAC=%s RMAC=%s, card keys=%s", HexUtils.bin2hex((byte[])this.enc), HexUtils.bin2hex((byte[])this.mac), this.rmac == null ? "N/A" : HexUtils.bin2hex((byte[])this.rmac), this.cardKeys.toString());
    }
}

