/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.APDUBIBO;
import apdu4j.CommandAPDU;
import apdu4j.HexUtils;
import apdu4j.ResponseAPDU;
import com.payneteasy.tlv.BerTag;
import com.payneteasy.tlv.BerTlv;
import com.payneteasy.tlv.BerTlvParser;
import com.payneteasy.tlv.BerTlvs;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.javacard.AID;
import pro.javacard.CAPFile;
import pro.javacard.gp.DMTokenGenerator;
import pro.javacard.gp.GPCardKeys;
import pro.javacard.gp.GPCrypto;
import pro.javacard.gp.GPData;
import pro.javacard.gp.GPDataException;
import pro.javacard.gp.GPException;
import pro.javacard.gp.GPKeyInfo;
import pro.javacard.gp.GPRegistry;
import pro.javacard.gp.GPRegistryEntry;
import pro.javacard.gp.GPSecureChannel;
import pro.javacard.gp.GPSessionKeys;
import pro.javacard.gp.GPUtils;
import pro.javacard.gp.SCP01Wrapper;
import pro.javacard.gp.SCP02Wrapper;
import pro.javacard.gp.SCP03Wrapper;
import pro.javacard.gp.SecureChannelWrapper;

public class GPSession {
    private static final Logger logger = LoggerFactory.getLogger(GPSession.class);
    private static final String LFDBH_SHA1 = "SHA1";
    public static final int SCP_ANY = 0;
    public static final int SCP_01_05 = 1;
    public static final int SCP_01_15 = 2;
    public static final int SCP_02_04 = 3;
    public static final int SCP_02_05 = 4;
    public static final int SCP_02_0A = 5;
    public static final int SCP_02_0B = 6;
    public static final int SCP_02_14 = 7;
    public static final int SCP_02_15 = 8;
    public static final int SCP_02_1A = 9;
    public static final int SCP_02_1B = 10;
    public static final EnumSet<APDUMode> defaultMode = EnumSet.of(APDUMode.MAC);
    public static final byte CLA_GP = -128;
    public static final byte CLA_MAC = -124;
    public static final byte INS_INITIALIZE_UPDATE = 80;
    public static final byte INS_INSTALL = -26;
    public static final byte INS_LOAD = -24;
    public static final byte INS_DELETE = -28;
    public static final byte INS_GET_STATUS = -14;
    public static final byte INS_SET_STATUS = -16;
    public static final byte INS_PUT_KEY = -40;
    public static final byte INS_STORE_DATA = -30;
    public static final byte INS_GET_DATA = -54;
    public static final byte P1_INSTALL_AND_MAKE_SELECTABLE = 12;
    public static final byte P1_INSTALL_FOR_INSTALL = 4;
    public static final byte P1_INSTALL_FOR_LOAD = 2;
    public static final byte P1_MORE_BLOCKS = 0;
    public static final byte P1_LAST_BLOCK = -128;
    protected boolean strict = true;
    GPSpec spec = GPSpec.GP211;
    private AID sdAID;
    GPSecureChannel scpVersion;
    private int scpKeyVersion = 0;
    private int blockSize = 255;
    private GPSessionKeys sessionKeys;
    private SecureChannelWrapper wrapper = null;
    private APDUBIBO channel;
    private GPRegistry registry = null;
    private DMTokenGenerator tokenizer = new DMTokenGenerator(null);
    private boolean dirty = true;

    public GPSession(APDUBIBO channel, AID sdAID) {
        if (channel == null) {
            throw new IllegalArgumentException("A card session is required");
        }
        this.channel = channel;
        this.sdAID = sdAID;
    }

    public static GPSession discover(APDUBIBO channel) throws GPException, IOException {
        BerTlv isdaid;
        BerTlvs tlvs;
        byte[] identify_aid;
        CommandAPDU identify;
        ResponseAPDU identify_resp;
        byte[] identify_data;
        if (channel == null) {
            throw new IllegalArgumentException("channel is null");
        }
        CommandAPDU command = new CommandAPDU(0, 164, 4, 0, 256);
        ResponseAPDU response = channel.transmit(command);
        if (response.getSW() == 27266 && (identify_data = (identify_resp = channel.transmit(identify = new CommandAPDU(0, 164, 4, 0, identify_aid = HexUtils.hex2bin((String)"A000000167413000FF"), 256))).getData()).length > 15 && identify_data[14] == 0) {
            throw new GPException("Unfused JCOP detected");
        }
        if (response.getSW() == 27271) {
            logger.debug("Trying default ISD AID ...");
            return GPSession.connect(channel, new AID(GPData.defaultISDBytes));
        }
        GPException.check(response, "Could not SELECT default selected", 25219);
        try {
            BerTlvParser parser = new BerTlvParser();
            tlvs = parser.parse(response.getData());
            GPUtils.trace_tlv(response.getData(), logger);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalStateException e) {
            logger.warn("Could not parse SELECT response: " + e.getMessage());
            throw new GPDataException("Could not auto-detect ISD AID", response.getData());
        }
        BerTlv fcitag = tlvs.find(new BerTag(111));
        if (fcitag != null && (isdaid = fcitag.find(new BerTag(132))) != null && isdaid.getBytesValue().length > 0) {
            AID detectedAID = new AID(isdaid.getBytesValue());
            logger.debug("Auto-detected ISD: " + detectedAID);
            return new GPSession(channel, detectedAID);
        }
        throw new GPDataException("Could not auto-detect ISD AID", response.getData());
    }

    public static GPSession connect(APDUBIBO channel, AID sdAID) throws IOException, GPException {
        if (channel == null) {
            throw new IllegalArgumentException("A card session is required");
        }
        if (sdAID == null) {
            throw new IllegalArgumentException("Security Domain AID is required");
        }
        logger.debug("(I)SD AID: " + sdAID);
        GPSession gp = new GPSession(channel, sdAID);
        gp.select(sdAID);
        return gp;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getVersion() {
        try (InputStream versionfile = GPSession.class.getResourceAsStream("pro_version.txt");){
            String version = "unknown-development";
            if (versionfile != null) {
                try (BufferedReader vinfo = new BufferedReader(new InputStreamReader(versionfile, StandardCharsets.US_ASCII));){
                    version = vinfo.readLine();
                }
            }
            String string = version;
            return string;
        }
        catch (IOException e) {
            return "unknown-error";
        }
    }

    public static byte[] getLoadParams(boolean loadParam, byte[] code) {
        byte[] byArray;
        if (loadParam) {
            byte[] byArray2 = new byte[6];
            byArray2[0] = -17;
            byArray2[1] = 4;
            byArray2[2] = -58;
            byArray2[3] = 2;
            byArray2[4] = (byte)((code.length & 0xFF00) >> 8);
            byArray = byArray2;
            byArray2[5] = (byte)(code.length & 0xFF);
        } else {
            byArray = new byte[]{};
        }
        return byArray;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void setBlockSize(int size) {
        this.blockSize = size;
    }

    public void setSpec(GPSpec spec) {
        this.spec = spec;
    }

    public void setDMTokenGenerator(DMTokenGenerator tokenGenerator) {
        this.tokenizer = tokenGenerator;
    }

    public AID getAID() {
        return new AID(this.sdAID.getBytes());
    }

    public APDUBIBO getCardChannel() {
        return this.channel;
    }

    protected void giveStrictWarning(String message) throws GPException {
        message = "STRICT WARNING: " + message;
        if (this.strict) {
            throw new GPException(message);
        }
        logger.warn(message);
    }

    public int getScpKeyVersion() {
        return this.scpKeyVersion;
    }

    void select(AID sdAID) throws GPException, IOException {
        CommandAPDU command = new CommandAPDU(0, 164, 4, 0, sdAID.getBytes(), 256);
        ResponseAPDU resp = this.channel.transmit(command);
        if (resp.getSW() == 25219) {
            logger.warn("SELECT ISD returned 6283 - CARD_LOCKED");
        }
        GPException.check(resp, "Could not SELECT Security Domain", 25219);
        this.parse_select_response(resp.getData());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parse_select_response(byte[] fci) throws GPException {
        BerTlvs tlvs;
        try {
            BerTlvParser parser = new BerTlvParser();
            tlvs = parser.parse(fci);
            GPUtils.trace_tlv(fci, logger);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalStateException e) {
            logger.warn("Could not parse SELECT response: " + e.getMessage());
            return;
        }
        BerTlv fcitag = tlvs.find(new BerTag(111));
        if (fcitag != null) {
            BerTlv prop;
            AID detectedAID;
            BerTlv isdaid = fcitag.find(new BerTag(132));
            if (isdaid != null && !(detectedAID = new AID(isdaid.getBytesValue())).equals((Object)this.sdAID)) {
                logger.warn(String.format("SD AID in FCI (%s) does not match the requested AID (%s). Using reported AID!", detectedAID, this.sdAID));
                this.sdAID = detectedAID;
            }
            if ((prop = fcitag.find(new BerTag(165))) != null) {
                BerTlv maxbs;
                BerTlv lc;
                BerTlv isdd = prop.find(new BerTag(115));
                if (isdd != null) {
                    BerTlv oidtag = isdd.find(new BerTag(6));
                    if (oidtag != null) {
                        BerTlv veroid;
                        if (!Arrays.equals(oidtag.getBytesValue(), HexUtils.hex2bin((String)"2A864886FC6B01"))) throw new GPDataException("Invalid CardRecognitionData", oidtag.getBytesValue());
                        BerTlv vertag = isdd.find(new BerTag(96));
                        if (vertag != null && (veroid = vertag.find(new BerTag(6))) != null) {
                            this.spec = GPData.oid2version(veroid.getBytesValue());
                            logger.debug("Auto-detected GP version: " + (Object)((Object)this.spec));
                        }
                    } else {
                        logger.warn("Not global platform OID");
                    }
                }
                if ((lc = prop.find(new BerTag(159, 110))) != null) {
                    logger.debug("Lifecycle data (ignored): " + HexUtils.bin2hex((byte[])lc.getBytesValue()));
                }
                if ((maxbs = prop.find(new BerTag(159, 101))) == null) return;
                this.setBlockSize(maxbs.getBytesValue());
                return;
            } else {
                logger.warn("No mandatory proprietary info present in FCI");
            }
            return;
        } else {
            logger.warn("No FCI returned to SELECT");
        }
    }

    private void setBlockSize(byte[] blocksize) {
        int bs = new BigInteger(1, blocksize).intValue();
        if (bs > this.blockSize) {
            logger.warn("Ignoring auto-detected block size that exceeds set maximum: " + bs);
        } else {
            this.blockSize = bs;
            logger.debug("Auto-detected block size: " + this.blockSize);
        }
    }

    List<GPKeyInfo> getKeyInfoTemplate() throws IOException, GPException {
        ArrayList<GPKeyInfo> result = new ArrayList<GPKeyInfo>();
        byte[] tmpl = this.wrapper != null ? this.transmit(new CommandAPDU(-128, 202, 0, 224, 256)).getData() : GPData.fetchKeyInfoTemplate(this.channel);
        result.addAll(GPKeyInfo.parseTemplate(tmpl));
        return result;
    }

    public void openSecureChannel(GPCardKeys keys, GPSecureChannel scp, byte[] host_challenge, EnumSet<APDUMode> securityLevel) throws IOException, GPException {
        byte[] host_cryptogram;
        CommandAPDU initUpdate;
        ResponseAPDU response;
        int sw;
        if (securityLevel.contains((Object)APDUMode.ENC)) {
            securityLevel.add(APDUMode.MAC);
        }
        logger.info("Using card master keys: {}", (Object)keys);
        if (host_challenge == null) {
            host_challenge = new byte[8];
            GPCrypto.random.nextBytes(host_challenge);
            logger.trace("Generated host challenge: " + HexUtils.bin2hex((byte[])host_challenge));
        }
        if ((sw = (response = this.channel.transmit(initUpdate = new CommandAPDU(-128, 80, keys.getKeyInfo().getVersion(), scp == GPSecureChannel.SCP01 ? keys.getKeyInfo().getID() : 0, host_challenge, 256))).getSW()) == 27010 || sw == 27011) {
            throw new GPException(sw, "INITIALIZE UPDATE failed, card LOCKED?");
        }
        GPException.check(response, "INITIALIZE UPDATE failed", new int[0]);
        byte[] update_response = response.getData();
        if (update_response.length != 28 && update_response.length != 29 && update_response.length != 32) {
            throw new GPException("Invalid INITIALIZE UPDATE response length: " + update_response.length);
        }
        int offset = 0;
        byte[] diversification_data = Arrays.copyOfRange(update_response, 0, 10);
        this.scpKeyVersion = update_response[offset += diversification_data.length] & 0xFF;
        this.scpVersion = GPSecureChannel.valueOf(update_response[++offset] & 0xFF).orElseThrow(() -> new GPDataException("Invalid SCP version", update_response));
        ++offset;
        int scp_i = -1;
        if (this.scpVersion == GPSecureChannel.SCP03) {
            scp_i = update_response[offset];
            ++offset;
        }
        byte[] card_challenge = Arrays.copyOfRange(update_response, offset, offset + 8);
        byte[] card_cryptogram = Arrays.copyOfRange(update_response, offset += card_challenge.length, offset + 8);
        offset += card_cryptogram.length;
        logger.debug("Host challenge: " + HexUtils.bin2hex((byte[])host_challenge));
        logger.debug("Card challenge: " + HexUtils.bin2hex((byte[])card_challenge));
        logger.debug("Card reports {}{} with key version {}", new Object[]{this.scpVersion, this.scpVersion == GPSecureChannel.SCP03 ? " i=" + String.format("%02x", scp_i) : "", String.format("%d (0x%02X)", this.scpKeyVersion, this.scpKeyVersion)});
        GPKeyInfo keyInfo = keys.getKeyInfo();
        if (keyInfo.getVersion() > 0 && this.scpKeyVersion != keyInfo.getVersion()) {
            throw new GPException("Key version mismatch: " + keyInfo.getVersion() + " != " + this.scpKeyVersion);
        }
        if (this.scpVersion == GPSecureChannel.SCP01 && securityLevel.contains((Object)APDUMode.RMAC)) {
            logger.debug("SCP01 does not support RMAC, removing.");
            securityLevel.remove((Object)APDUMode.RMAC);
        }
        byte[] seq = null;
        if (this.scpVersion == GPSecureChannel.SCP02) {
            seq = Arrays.copyOfRange(update_response, 12, 14);
        } else if (this.scpVersion == GPSecureChannel.SCP03 && update_response.length == 32) {
            seq = Arrays.copyOfRange(update_response, 29, 32);
        }
        GPCardKeys cardKeys = keys.diversify(this.scpVersion, diversification_data);
        logger.info("Diversified card keys: {}", (Object)cardKeys);
        byte[] kdd = this.scpVersion == GPSecureChannel.SCP02 ? (byte[])seq.clone() : GPUtils.concatenate(host_challenge, card_challenge);
        this.sessionKeys = cardKeys.getSessionKeys(kdd);
        logger.info("Session keys: {}", (Object)this.sessionKeys);
        byte[] cntx = GPUtils.concatenate(host_challenge, card_challenge);
        byte[] my_card_cryptogram = this.scpVersion == GPSecureChannel.SCP01 || this.scpVersion == GPSecureChannel.SCP02 ? GPCrypto.mac_3des_nulliv(this.sessionKeys.get(GPCardKeys.KeyPurpose.ENC), cntx) : GPCrypto.scp03_kdf(this.sessionKeys.get(GPCardKeys.KeyPurpose.MAC), (byte)0, cntx, 64);
        if (!Arrays.equals(card_cryptogram, my_card_cryptogram)) {
            if (System.console() != null) {
                System.err.println("Read more from https://github.com/martinpaljak/GlobalPlatformPro/wiki/Keys");
            }
            this.giveStrictWarning("Card cryptogram invalid!\nCard: " + HexUtils.bin2hex((byte[])card_cryptogram) + "\nHost: " + HexUtils.bin2hex((byte[])my_card_cryptogram) + "\n!!! DO NOT RE-TRY THE SAME COMMAND/KEYS OR YOU MAY BRICK YOUR CARD !!!");
        } else {
            logger.debug("Verified card cryptogram: " + HexUtils.bin2hex((byte[])my_card_cryptogram));
        }
        switch (this.scpVersion) {
            case SCP01: {
                host_cryptogram = GPCrypto.mac_3des_nulliv(this.sessionKeys.get(GPCardKeys.KeyPurpose.ENC), GPUtils.concatenate(card_challenge, host_challenge));
                this.wrapper = new SCP01Wrapper(this.sessionKeys, EnumSet.of(APDUMode.MAC), this.blockSize);
                break;
            }
            case SCP02: {
                host_cryptogram = GPCrypto.mac_3des_nulliv(this.sessionKeys.get(GPCardKeys.KeyPurpose.ENC), GPUtils.concatenate(card_challenge, host_challenge));
                this.wrapper = new SCP02Wrapper(this.sessionKeys, EnumSet.of(APDUMode.MAC), this.blockSize);
                break;
            }
            case SCP03: {
                host_cryptogram = GPCrypto.scp03_kdf(this.sessionKeys.get(GPCardKeys.KeyPurpose.MAC), (byte)1, cntx, 64);
                this.wrapper = new SCP03Wrapper(this.sessionKeys, EnumSet.of(APDUMode.MAC), this.blockSize);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown SCP");
            }
        }
        logger.debug("Calculated host cryptogram: " + HexUtils.bin2hex((byte[])host_cryptogram));
        int P1 = APDUMode.getSetValue(securityLevel);
        CommandAPDU externalAuthenticate = new CommandAPDU(-124, 130, P1, 0, host_cryptogram);
        response = this.transmit(externalAuthenticate);
        GPException.check(response, "External authenticate failed", new int[0]);
    }

    public ResponseAPDU transmit(CommandAPDU command) throws IOException {
        try {
            ResponseAPDU unwrapped = this.wrapper.unwrap(this.channel.transmit(this.wrapper.wrap(command)));
            return unwrapped;
        }
        catch (GPException e) {
            throw new IOException("Secure channel failure: " + e.getMessage(), e);
        }
    }

    private ResponseAPDU transmitLV(CommandAPDU command) throws IOException {
        logger.trace("LV payload: ");
        try {
            GPUtils.trace_lv(command.getData(), logger);
        }
        catch (Exception e) {
            logger.error("Invalid LV: {}" + HexUtils.bin2hex((byte[])command.getData()));
        }
        return this.transmit(command);
    }

    private ResponseAPDU transmitTLV(CommandAPDU command) throws IOException {
        logger.trace("TLV payload: ");
        try {
            GPUtils.trace_tlv(command.getData(), logger);
        }
        catch (Exception e) {
            logger.error("Invalid TLV: {}" + HexUtils.bin2hex((byte[])command.getData()));
        }
        return this.transmit(command);
    }

    private CommandAPDU tokenize(CommandAPDU command) throws IOException {
        try {
            command = this.tokenizer.applyToken(command);
            return command;
        }
        catch (GeneralSecurityException e) {
            logger.error("Can not apply token: " + e.getMessage(), (Throwable)e);
            throw new GPException("Can not apply DM token", e);
        }
    }

    public void loadCapFile(CAPFile cap, AID targetDomain) throws IOException, GPException {
        if (targetDomain == null) {
            targetDomain = this.sdAID;
        }
        this.loadCapFile(cap, targetDomain, false, false, null, null, LFDBH_SHA1);
    }

    public void loadCapFile(CAPFile cap, AID targetDomain, String hashFunction) throws IOException, GPException {
        if (targetDomain == null) {
            targetDomain = this.sdAID;
        }
        this.loadCapFile(cap, targetDomain, false, false, null, null, hashFunction);
    }

    public void loadCapFile(CAPFile cap, AID targetDomain, byte[] dap, String hash) throws IOException, GPException {
        if (targetDomain == null) {
            targetDomain = this.sdAID;
        }
        this.loadCapFile(cap, targetDomain, false, false, targetDomain, dap, hash);
    }

    public void loadCapFile(CAPFile cap, AID targetDomain, AID dapdomain, byte[] dap, String hashFunction) throws IOException, GPException {
        if (targetDomain == null) {
            targetDomain = this.sdAID;
        }
        this.loadCapFile(cap, targetDomain, false, false, dapdomain, dap, hashFunction);
    }

    private void loadCapFile(CAPFile cap, AID targetDomain, boolean includeDebug, boolean loadParam, AID dapDomain, byte[] dap, String hashFunction) throws GPException, IOException {
        if (this.getRegistry().allAIDs().contains(cap.getPackageAID())) {
            this.giveStrictWarning("Package with AID " + cap.getPackageAID() + " is already present on card");
        }
        boolean isHashRequired = dap != null || this.tokenizer.hasKey();
        byte[] hash = isHashRequired ? cap.getLoadFileDataHash(hashFunction) : new byte[]{};
        byte[] code = cap.getCode();
        byte[] loadParams = GPSession.getLoadParams(loadParam, code);
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            bo.write(cap.getPackageAID().getLength());
            bo.write(cap.getPackageAID().getBytes());
            bo.write(targetDomain.getLength());
            bo.write(targetDomain.getBytes());
            bo.write(hash.length);
            bo.write(hash);
            bo.write(loadParams.length);
            bo.write(loadParams);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        CommandAPDU command = new CommandAPDU(-128, -26, 2, 0, bo.toByteArray());
        command = this.tokenize(command);
        ResponseAPDU response = this.transmitLV(command);
        GPException.check(response, "INSTALL [for load] failed", new int[0]);
        ByteArrayOutputStream loadBlock = new ByteArrayOutputStream();
        try {
            if (dap != null && dapDomain != null) {
                loadBlock.write(226);
                loadBlock.write(GPUtils.encodeLength(dapDomain.getLength() + dap.length + GPUtils.encodeLength(dap.length).length + 3));
                loadBlock.write(79);
                loadBlock.write(dapDomain.getLength());
                loadBlock.write(dapDomain.getBytes());
                loadBlock.write(195);
                loadBlock.write(GPUtils.encodeLength(dap.length));
                loadBlock.write(dap);
            }
            loadBlock.write(196);
            loadBlock.write(GPUtils.encodeLength(code.length));
            loadBlock.write(code);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        List<byte[]> blocks = GPUtils.splitArray(loadBlock.toByteArray(), this.wrapper.getBlockSize());
        for (int i = 0; i < blocks.size(); ++i) {
            int p1 = i == blocks.size() - 1 ? -128 : 0;
            CommandAPDU load = new CommandAPDU(-128, -24, p1, (int)((byte)i), blocks.get(i));
            response = this.transmit(load);
            GPException.check(response, "LOAD failed", new int[0]);
        }
        this.dirty = true;
    }

    public void installAndMakeSelectable(AID packageAID, AID appletAID, AID instanceAID, GPRegistryEntry.Privileges privileges, byte[] installParams) throws GPException, IOException {
        if (instanceAID == null) {
            instanceAID = appletAID;
        }
        if (this.getRegistry().allAppletAIDs().contains(instanceAID)) {
            this.giveStrictWarning("Instance AID " + instanceAID + " is already present on card");
        }
        byte[] data = this.buildInstallData(packageAID, appletAID, instanceAID, privileges, installParams);
        CommandAPDU command = new CommandAPDU(-128, -26, 12, 0, data);
        command = this.tokenize(command);
        ResponseAPDU response = this.transmitLV(command);
        GPException.check(response, "INSTALL [for install and make selectable] failed", new int[0]);
        this.dirty = true;
    }

    public void installForInstall(AID packageAID, AID appletAID, AID instanceAID, GPRegistryEntry.Privileges privileges, byte[] installParams, PrivateKey key) throws GPException, IOException {
        if (instanceAID == null) {
            instanceAID = appletAID;
        }
        if (this.getRegistry().allAppletAIDs().contains(instanceAID)) {
            this.giveStrictWarning("Instance AID " + instanceAID + " is already present on card");
        }
        byte[] data = this.buildInstallData(packageAID, appletAID, instanceAID, privileges, installParams);
        CommandAPDU command = new CommandAPDU(-128, -26, 4, 0, data);
        command = this.tokenize(command);
        ResponseAPDU response = this.transmitLV(command);
        GPException.check(response, "INSTALL [for install] failed", new int[0]);
        this.dirty = true;
    }

    private byte[] buildInstallData(AID packageAID, AID appletAID, AID instanceAID, GPRegistryEntry.Privileges privileges, byte[] installParams) {
        if (instanceAID == null) {
            instanceAID = appletAID;
        }
        if (installParams == null || installParams.length == 0) {
            installParams = new byte[]{-55, 0};
        }
        if (installParams[0] != -55) {
            byte[] newparams = new byte[installParams.length + 2];
            newparams[0] = -55;
            newparams[1] = (byte)installParams.length;
            System.arraycopy(installParams, 0, newparams, 2, installParams.length);
            installParams = newparams;
        }
        byte[] privs = privileges.toBytes();
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            bo.write(packageAID.getLength());
            bo.write(packageAID.getBytes());
            bo.write(appletAID.getLength());
            bo.write(appletAID.getBytes());
            bo.write(instanceAID.getLength());
            bo.write(instanceAID.getBytes());
            bo.write(privs.length);
            bo.write(privs);
            bo.write(installParams.length);
            bo.write(installParams);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return bo.toByteArray();
    }

    public void extradite(AID what, AID to) throws GPException, IOException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            bo.write(to.getLength());
            bo.write(to.getBytes());
            bo.write(0);
            bo.write(what.getLength());
            bo.write(what.getBytes());
            bo.write(0);
            bo.write(0);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        CommandAPDU command = new CommandAPDU(-128, -26, 16, 0, bo.toByteArray());
        command = this.tokenize(command);
        ResponseAPDU response = this.transmitLV(command);
        GPException.check(response, "INSTALL [for extradition] failed", new int[0]);
        this.dirty = true;
    }

    public void installForPersonalization(AID aid) throws IOException, GPException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            bo.write(0);
            bo.write(0);
            bo.write(aid.getLength());
            bo.write(aid.getBytes());
            bo.write(0);
            bo.write(0);
            bo.write(0);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        CommandAPDU install = new CommandAPDU(-128, -26, 32, 0, bo.toByteArray(), 256);
        GPException.check(this.transmitLV(install), "INSTALL [for personalization] failed", new int[0]);
    }

    public byte[] personalizeSingle(AID aid, byte[] data, int P1) throws IOException, GPException {
        return this.personalize(aid, Collections.singletonList(data), P1).get(0);
    }

    public void personalize(AID aid, byte[] data, int P1) throws IOException, GPException {
        this.installForPersonalization(aid);
        this.storeData(data, P1);
    }

    public List<byte[]> personalize(AID aid, List<byte[]> data, int P1) throws IOException, GPException {
        this.installForPersonalization(aid);
        return this.storeData(data, P1);
    }

    public byte[] storeDataSingle(byte[] data, int P1) throws IOException, GPException {
        if (data.length > this.wrapper.getBlockSize()) {
            throw new IllegalArgumentException("block size is bigger than possibility to send: " + data.length + ">" + this.wrapper.getBlockSize());
        }
        return this.storeData(Collections.singletonList(data), P1).get(0);
    }

    public void storeData(byte[] data, int P1) throws IOException, GPException {
        List<byte[]> blocks = GPUtils.splitArray(data, this.wrapper.getBlockSize());
        this.storeData(blocks, P1);
    }

    public List<byte[]> storeData(List<byte[]> blocks, int P1) throws IOException, GPException {
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        for (int i = 0; i < blocks.size(); ++i) {
            int p1 = i == blocks.size() - 1 ? P1 | 0x80 : P1 & 0x7F;
            CommandAPDU store = new CommandAPDU(-128, -30, p1, i, blocks.get(i), 256);
            result.add(GPException.check(this.transmit(store), "STORE DATA failed", new int[0]).getData());
        }
        return result;
    }

    byte[] _storeDataSingle(byte[] data, int P1, int P2) throws IOException, GPException {
        CommandAPDU store = new CommandAPDU(-128, -30, P1, P2, data, 256);
        return GPException.check(this.transmit(store), "STORE DATA failed", new int[0]).getData();
    }

    public void makeDefaultSelected(AID aid) throws IOException, GPException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        GPRegistryEntry.Privileges ds = GPRegistryEntry.Privileges.set(GPRegistryEntry.Privilege.CardReset);
        byte privileges = ds.toByte();
        try {
            bo.write(0);
            bo.write(0);
            bo.write(aid.getLength());
            bo.write(aid.getBytes());
            bo.write(1);
            bo.write(privileges);
            bo.write(0);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        CommandAPDU command = new CommandAPDU(-128, -26, 8, 0, bo.toByteArray());
        command = this.tokenize(command);
        ResponseAPDU response = this.transmitLV(command);
        GPException.check(response, "INSTALL [for make selectable] failed", new int[0]);
        this.dirty = true;
    }

    public void lockUnlockApplet(AID app, boolean lock) throws IOException, GPException {
        CommandAPDU cmd = new CommandAPDU(-128, -16, 64, lock ? 128 : 0, app.getBytes());
        ResponseAPDU response = this.transmit(cmd);
        GPException.check(response, "SET STATUS failed", new int[0]);
        this.dirty = true;
    }

    public void setCardStatus(byte status) throws IOException, GPException {
        logger.debug("Setting status to {}", (Object)GPRegistryEntry.getLifeCycleString(GPRegistryEntry.Kind.IssuerSecurityDomain, status));
        CommandAPDU cmd = new CommandAPDU(-128, -16, 128, (int)status);
        ResponseAPDU response = this.transmit(cmd);
        GPException.check(response, "SET STATUS failed", new int[0]);
        this.dirty = true;
    }

    public void deleteAID(AID aid, boolean deleteDeps) throws GPException, IOException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            bo.write(79);
            bo.write(aid.getLength());
            bo.write(aid.getBytes());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        CommandAPDU command = new CommandAPDU(-128, -28, 0, deleteDeps ? 128 : 0, bo.toByteArray());
        command = this.tokenize(command);
        ResponseAPDU response = this.transmitTLV(command);
        GPException.check(response, "DELETE failed", new int[0]);
        this.dirty = true;
    }

    public void deleteKey(int keyver) throws GPException, IOException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        bo.write(210);
        bo.write(keyver);
        CommandAPDU delete = new CommandAPDU(-128, -28, 0, 0, bo.toByteArray());
        ResponseAPDU response = this.transmit(delete);
        GPException.check(response, "Deletion failed", new int[0]);
    }

    public void renameISD(AID newaid) throws GPException, IOException {
        CommandAPDU rename = new CommandAPDU(-128, -30, 144, 0, GPUtils.concatenate({79, (byte)newaid.getLength()}, newaid.getBytes()));
        ResponseAPDU response = this.transmit(rename);
        GPException.check(response, "Rename failed", new int[0]);
    }

    private byte[] encodeKey(GPSessionKeys dek, GPCardKeys other, GPCardKeys.KeyPurpose p) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (other.scp == GPSecureChannel.SCP03) {
                byte[] cgram = dek.encryptKey(other, p);
                byte[] check = other.kcv(p);
                baos.write(136);
                baos.write(cgram.length + 1);
                baos.write(other.getKeyInfo().getLength());
                baos.write(cgram);
                baos.write(check.length);
                baos.write(check);
            } else if (other.scp == GPSecureChannel.SCP01 || other.scp == GPSecureChannel.SCP02) {
                byte[] cgram = dek.encryptKey(other, p);
                byte[] kcv = other.kcv(p);
                baos.write(128);
                baos.write(cgram.length);
                baos.write(cgram);
                baos.write(kcv.length);
                baos.write(kcv);
            }
            return baos.toByteArray();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new GPException("Could not wrap key", e);
        }
    }

    public void putKeys(GPCardKeys keys, boolean replace) throws GPException, IOException {
        logger.debug("PUT KEY version {}", (Object)keys);
        List<GPKeyInfo> tmpl = this.getKeyInfoTemplate();
        if (tmpl.size() <= 0 && replace) {
            logger.warn("No key template on card but trying to replace. Implying add");
            replace = false;
        }
        int P1 = 0;
        if (replace) {
            P1 = keys.getKeyInfo().getVersion();
        }
        int P2 = 1;
        P2 |= 0x80;
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        keys = keys.diversify(this.sessionKeys.cardKeys.scp, this.sessionKeys.cardKeys.kdd);
        bo.write(keys.getKeyInfo().getVersion());
        for (GPCardKeys.KeyPurpose p : GPCardKeys.KeyPurpose.cardKeys()) {
            bo.write(this.encodeKey(this.sessionKeys, keys, p));
        }
        CommandAPDU command = new CommandAPDU(-128, -40, P1, P2, bo.toByteArray());
        ResponseAPDU response = this.transmit(command);
        GPException.check(response, "PUT KEY failed", new int[0]);
    }

    public void putKey(RSAPublicKey pubkey, int version) throws IOException, GPException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            bo.write(version);
            bo.write(161);
            byte[] modulus = GPUtils.positive(pubkey.getModulus());
            byte[] exponent = GPUtils.positive(pubkey.getPublicExponent());
            bo.write(modulus.length);
            bo.write(modulus);
            bo.write(160);
            bo.write(exponent.length);
            bo.write(exponent);
            bo.write(0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        CommandAPDU command = new CommandAPDU(-128, -40, 0, 1, bo.toByteArray());
        ResponseAPDU response = this.transmit(command);
        GPException.check(response, "PUT KEY failed", new int[0]);
    }

    public GPRegistry getRegistry() throws GPException, IOException {
        if (this.dirty) {
            this.registry = this.getStatus();
            this.dirty = false;
        }
        return this.registry;
    }

    private byte[] getConcatenatedStatus(GPRegistry reg, int p1, byte[] data) throws IOException, GPException {
        int p2 = reg.tags ? 2 : 0;
        CommandAPDU cmd = new CommandAPDU(-128, -14, p1, p2, data, 256);
        ResponseAPDU response = this.transmit(cmd);
        if (p1 == 128 && response.getSW() == 27270 && p2 == 2) {
            reg.tags = false;
            return this.getConcatenatedStatus(reg, p1, data);
        }
        int sw = response.getSW();
        if (sw != 36864 && sw != 25360) {
            if (sw == 27272) {
                return response.getData();
            }
            logger.warn("GET STATUS failed for " + HexUtils.bin2hex((byte[])cmd.getBytes()) + " with " + GPData.sw2str(response.getSW()));
            return response.getData();
        }
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            bo.write(response.getData());
            while (response.getSW() == 25360 && response.getData().length > 0) {
                cmd = new CommandAPDU(-128, -14, p1, p2 | 1, data, 256);
                response = this.transmit(cmd);
                GPException.check(response, "GET STATUS failed for " + HexUtils.bin2hex((byte[])cmd.getBytes()), 25360);
                bo.write(response.getData());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return bo.toByteArray();
    }

    private GPRegistry getStatus() throws IOException, GPException {
        GPRegistry registry = new GPRegistry();
        if (this.spec == GPSpec.OP201) {
            registry.tags = false;
        }
        byte[] data = this.getConcatenatedStatus(registry, 128, new byte[]{79, 0});
        registry.parse(128, data, GPRegistryEntry.Kind.IssuerSecurityDomain, this.spec);
        data = this.getConcatenatedStatus(registry, 64, new byte[]{79, 0});
        registry.parse(64, data, GPRegistryEntry.Kind.Application, this.spec);
        data = this.getConcatenatedStatus(registry, 32, new byte[]{79, 0});
        registry.parse(32, data, GPRegistryEntry.Kind.ExecutableLoadFile, this.spec);
        if (this.spec != GPSpec.OP201) {
            data = this.getConcatenatedStatus(registry, 16, new byte[]{79, 0});
            registry.parse(16, data, GPRegistryEntry.Kind.ExecutableLoadFile, this.spec);
        }
        return registry;
    }

    public static enum GPSpec {
        OP201,
        GP211,
        GP22;

    }

    public static enum APDUMode {
        CLR(0),
        MAC(1),
        ENC(2),
        RMAC(16),
        RENC(32);

        private final int value;

        private APDUMode(int value) {
            this.value = value;
        }

        public static int getSetValue(EnumSet<APDUMode> s) {
            int v = 0;
            for (APDUMode m : s) {
                v |= m.value;
            }
            return v;
        }

        public static APDUMode fromString(String s) {
            return APDUMode.valueOf(s.trim().toUpperCase());
        }
    }
}

