/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.HexUtils;
import com.payneteasy.tlv.BerTag;
import com.payneteasy.tlv.BerTlv;
import com.payneteasy.tlv.BerTlvParser;
import com.payneteasy.tlv.BerTlvs;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.javacard.gp.GPDataException;
import pro.javacard.gp.GPException;
import pro.javacard.gp.GPUtils;

public final class GPKeyInfo {
    private static final Logger logger = LoggerFactory.getLogger(GPKeyInfo.class);
    private Type type;
    private int version = 0;
    private int id = -1;
    private int length = -1;

    GPKeyInfo(int version, int id, int length, int type) {
        this.version = version;
        this.id = id;
        this.length = length;
        if (type == 128 || type == 129 || type == 130) {
            this.type = Type.DES3;
        } else if (type == 136) {
            this.type = Type.AES;
        } else if (type == 161 || type == 160) {
            this.type = Type.RSAPUB;
        } else if (type == 133) {
            this.type = Type.PSK;
        } else {
            throw new UnsupportedOperationException(String.format("Only AES, 3DES, PSK and RSA public keys are supported currently: 0x%02X", type));
        }
    }

    public static List<GPKeyInfo> parseTemplate(byte[] data) throws GPException {
        ArrayList<GPKeyInfo> r = new ArrayList<GPKeyInfo>();
        if (data == null || data.length == 0) {
            return r;
        }
        BerTlvParser parser = new BerTlvParser();
        BerTlvs tlvs = parser.parse(data);
        GPUtils.trace_tlv(data, logger);
        BerTlv keys = tlvs.find(new BerTag(224));
        if (keys != null && keys.isConstructed()) {
            for (BerTlv key : keys.findAll(new BerTag(192))) {
                int type;
                boolean extended;
                byte[] tmpl = key.getBytesValue();
                if (tmpl.length == 0) {
                    logger.info("Key template has zero length (empty). Skipping.");
                    continue;
                }
                if (tmpl.length < 4) {
                    throw new GPDataException("Key info template shorter than 4 bytes", tmpl);
                }
                int offset = 0;
                int id = tmpl[offset++] & 0xFF;
                int version = tmpl[offset++] & 0xFF;
                boolean bl = extended = (type = tmpl[offset++] & 0xFF) == 255;
                if (extended) {
                    type = tmpl[offset++] & 0xFF;
                }
                int length = tmpl[offset++] & 0xFF;
                if (extended) {
                    length = length << 8 | tmpl[offset++] & 0xFF;
                }
                if (extended) {
                    logger.warn("Extended format not parsed: " + HexUtils.bin2hex((byte[])Arrays.copyOfRange(tmpl, tmpl.length - 4, tmpl.length)));
                }
                r.add(new GPKeyInfo(version, id, length, type));
            }
        }
        return r;
    }

    public static void print(List<GPKeyInfo> list, PrintStream out) {
        boolean factory_keys = false;
        out.flush();
        for (GPKeyInfo k : list) {
            String nice = k.getType() == Type.RSAPUB && k.getLength() > 0 ? "(RSA-" + k.getLength() * 8 + " public)" : (k.getType() == Type.AES && k.getLength() > 0 ? "(AES-" + k.getLength() * 8 + ")" : "");
            if (k.getVersion() == 0 || k.getVersion() == 255) {
                factory_keys = true;
            }
            out.println(String.format("Version: %3d (0x%02X) ID: %3d (0x%02X) type: %-4s length: %3d %s", new Object[]{k.getVersion(), k.getVersion(), k.getID(), k.getID(), k.getType(), k.getLength(), nice}));
        }
        if (factory_keys) {
            out.println("Key version suggests factory keys");
        }
        out.flush();
    }

    public int getID() {
        return this.id;
    }

    public int getVersion() {
        return this.version;
    }

    public int getLength() {
        return this.length;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("type=" + (Object)((Object)this.type));
        if (this.version >= 1 && this.version <= 127) {
            s.append(" version=" + String.format("%d (0x%02X)", this.version, this.version));
        }
        if (this.id >= 0 && this.id <= 127) {
            s.append(" id=" + String.format("%d (0x%02X)", this.id, this.id));
        }
        s.append(" len=" + this.length);
        return s.toString();
    }

    public static String type2str(int type) {
        if (0 <= type && type <= 127) {
            return "Reserved for private use";
        }
        if (128 == type) {
            return "DES - mode (ECB/CBC) implicitly known";
        }
        if (129 == type) {
            return "Reserved (Triple DES)";
        }
        if (130 == type) {
            return "Triple DES in CBC mode";
        }
        if (131 == type) {
            return "DES in ECB mode";
        }
        if (132 == type) {
            return "DES in CBC mode";
        }
        if (133 == type) {
            return "Pre-Shared Key for Transport Layer Security";
        }
        if (136 == type) {
            return "AES (16, 24, or 32 long keys)";
        }
        if (144 == type) {
            return "HMAC-SHA1 - length of HMAC is implicitly known";
        }
        if (145 == type) {
            return "MAC-SHA1-160 - length of HMAC is 160 bits";
        }
        if (type == 134 || type == 135 || 137 <= type && type <= 143 || 146 <= type && type <= 159) {
            return "RFU (asymmetric algorithms)";
        }
        if (160 == type) {
            return "RSA Public Key - public exponent e component (clear text)";
        }
        if (161 == type) {
            return "RSA Public Key - modulus N component (clear text)";
        }
        if (162 == type) {
            return "RSA Private Key - modulus N component";
        }
        if (163 == type) {
            return "RSA Private Key - private exponent d component";
        }
        if (164 == type) {
            return "RSA Private Key - Chinese Remainder P component";
        }
        if (165 == type) {
            return "RSA Private Key - Chinese Remainder Q component";
        }
        if (166 == type) {
            return "RSA Private Key - Chinese Remainder PQ component";
        }
        if (167 == type) {
            return "RSA Private Key - Chinese Remainder DP1 component";
        }
        if (168 == type) {
            return "RSA Private Key - Chinese Remainder DQ1 component";
        }
        if (169 <= type && type <= 254) {
            return "RFU (asymmetric algorithms)";
        }
        if (255 == type) {
            return "Extended Format";
        }
        return "UNKNOWN";
    }

    public static enum Type {
        DES3,
        AES,
        RSAPUB,
        PSK;


        public String toString() {
            if (this.name().equals("RSAPUB")) {
                return "RSA";
            }
            return super.toString();
        }
    }
}

