/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.APDUBIBO;
import apdu4j.CommandAPDU;
import apdu4j.HexUtils;
import apdu4j.ResponseAPDU;
import com.payneteasy.tlv.BerTag;
import com.payneteasy.tlv.BerTlv;
import com.payneteasy.tlv.BerTlvParser;
import com.payneteasy.tlv.BerTlvs;
import java.io.IOException;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.javacard.gp.GPDataException;
import pro.javacard.gp.GPException;
import pro.javacard.gp.GPKeyInfo;
import pro.javacard.gp.GPRegistryEntry;
import pro.javacard.gp.GPSession;
import pro.javacard.gp.GPUtils;

public final class GPData {
    private static final Logger logger = LoggerFactory.getLogger(GPData.class);
    public static final byte readyStatus = 1;
    public static final byte initializedStatus = 7;
    public static final byte securedStatus = 15;
    public static final byte lockedStatus = 127;
    public static final byte terminatedStatus = -1;
    static final byte[] defaultISDBytes = HexUtils.hex2bin((String)"A000000151000000");
    static final Map<Integer, String> sw = new HashMap<Integer, String>();

    public static void pretty_print_card_data(byte[] data) {
        BerTlvParser parser = new BerTlvParser();
        BerTlvs tlvs = parser.parse(data);
        GPUtils.trace_tlv(data, logger);
        BerTlv cd = tlvs.find(new BerTag(102));
        if (cd != null && cd.isConstructed()) {
            BerTlv isdd = tlvs.find(new BerTag(115));
            if (isdd != null) {
                for (BerTlv vt : isdd.getValues()) {
                    Object p;
                    BerTlv ot = vt.find(new BerTag(6));
                    if (ot == null) continue;
                    String oid = GPData.oid2string(ot.getBytesValue());
                    System.out.println("Tag " + new BigInteger(1, vt.getTag().bytes).toString(16) + ": " + oid);
                    if (oid.equals("1.2.840.114283.1")) {
                        System.out.println("-> Global Platform card");
                    }
                    if (oid.startsWith("1.2.840.114283.2")) {
                        p = oid.substring("1.2.840.114283.2.".length()).split("\\.");
                        System.out.println("-> GP Version: " + String.join((CharSequence)".", (CharSequence[])p));
                    }
                    if (oid.startsWith("1.2.840.114283.4")) {
                        p = oid.substring("1.2.840.114283.4.".length()).split("\\.");
                        if (((String[])p).length == 2) {
                            System.out.println("-> GP SCP0" + (String)p[0] + " i=" + String.format("%02x", Integer.valueOf((String)p[1])));
                        } else if (oid.equals("1.2.840.114283.4.0")) {
                            System.out.println("-> GP SCP80 i=00");
                        }
                    }
                    if (!oid.startsWith("1.3.6.1.4.1.42.2.110.1") || ((String)(p = oid.substring("1.3.6.1.4.1.42.2.110.1.".length()))).length() != 1) continue;
                    System.out.println("-> JavaCard v" + (String)p);
                }
            }
        } else {
            System.out.println("No Card Data");
        }
    }

    public static void pretty_print_card_capabilities(byte[] data) throws GPDataException {
        BerTlv caps;
        if (data[0] == 103 && data[2] == 103) {
            logger.warn("Bogus data detected, fixing double tag");
            data = Arrays.copyOfRange(data, 2, data.length);
        }
        BerTlvParser parser = new BerTlvParser();
        BerTlvs tlvs = parser.parse(data);
        GPUtils.trace_tlv(data, logger);
        if (tlvs != null && (caps = tlvs.find(new BerTag(103))) != null) {
            for (BerTlv v : caps.getValues()) {
                BerTlv t = v.find(new BerTag(160));
                if (t != null) {
                    BerTlv scp = t.find(new BerTag(128));
                    if (scp != null) {
                        BerTlv keylens;
                        System.out.format("Supports: SCP%02X", scp.getIntValue());
                        BerTlv is = t.find(new BerTag(129));
                        if (is != null) {
                            byte[] isv = is.getBytesValue();
                            for (int i = 0; i < isv.length; ++i) {
                                System.out.format(" i=%02X", isv[i]);
                            }
                        }
                        if ((keylens = t.find(new BerTag(130))) != null) {
                            System.out.print(" with");
                            if ((keylens.getIntValue() & 1) == 1) {
                                System.out.print(" AES-128");
                            }
                            if ((keylens.getIntValue() & 2) == 2) {
                                System.out.print(" AES-196");
                            }
                            if ((keylens.getIntValue() & 4) == 4) {
                                System.out.print(" AES-256");
                            }
                        }
                    }
                    System.out.println();
                    continue;
                }
                t = v.find(new BerTag(129));
                if (t != null) {
                    System.out.println("Supported DOM privileges: " + GPRegistryEntry.Privileges.fromBytes(t.getBytesValue()));
                    continue;
                }
                t = v.find(new BerTag(130));
                if (t != null) {
                    System.out.println("Supported APP privileges: " + GPRegistryEntry.Privileges.fromBytes(t.getBytesValue()));
                    continue;
                }
                t = v.find(new BerTag(131));
                if (t != null) {
                    System.out.println("Supported LFDB hash: " + HexUtils.bin2hex((byte[])t.getBytesValue()));
                    continue;
                }
                t = v.find(new BerTag(133));
                if (t != null) {
                    System.out.println("Supported Token Verification ciphers: " + HexUtils.bin2hex((byte[])t.getBytesValue()));
                    continue;
                }
                t = v.find(new BerTag(134));
                if (t != null) {
                    System.out.println("Supported Receipt Generation ciphers: " + HexUtils.bin2hex((byte[])t.getBytesValue()));
                    continue;
                }
                t = v.find(new BerTag(135));
                if (t != null) {
                    System.out.println("Supported DAP Verification ciphers: " + HexUtils.bin2hex((byte[])t.getBytesValue()));
                    continue;
                }
                t = v.find(new BerTag(136));
                if (t == null) continue;
                System.out.println("Supported ECC Key Parameters: " + HexUtils.bin2hex((byte[])t.getBytesValue()));
            }
        }
    }

    public static void dump(APDUBIBO channel) throws IOException, GPException {
        byte[] keyInfo;
        byte[] cin;
        byte[] iin;
        byte[] cplc = GPData.fetchCPLC(channel);
        if (cplc != null) {
            System.out.println(CPLC.fromBytes(cplc).toPrettyString());
        }
        if ((iin = GPData.getData(channel, 0, 66, "IIN", false)) != null) {
            System.out.println("IIN: " + HexUtils.bin2hex((byte[])iin));
        }
        if ((cin = GPData.getData(channel, 0, 69, "CIN", false)) != null) {
            System.out.println("CIN: " + HexUtils.bin2hex((byte[])cin));
        }
        System.out.println("Card Data: ");
        byte[] cardData = GPData.getData(channel, 0, 102, "Card Data", false);
        if (cardData != null) {
            GPData.pretty_print_card_data(cardData);
        }
        System.out.println("Card Capabilities: ");
        byte[] cardCapabilities = GPData.getData(channel, 0, 103, "Card Capabilities", false);
        if (cardCapabilities != null) {
            GPData.pretty_print_card_capabilities(cardCapabilities);
        }
        if ((keyInfo = GPData.fetchKeyInfoTemplate(channel)) != null) {
            GPKeyInfo.print(GPKeyInfo.parseTemplate(keyInfo), System.out);
        }
    }

    public static byte[] fetchCPLC(APDUBIBO channel) throws IOException {
        return GPData.getData(channel, 159, 127, "CPLC", true);
    }

    public static byte[] fetchKeyInfoTemplate(APDUBIBO channel) throws IOException {
        return GPData.getData(channel, 0, 224, "Key Info Template", false);
    }

    public static String sw2str(int sw) {
        String msg = GPData.sw.get(sw);
        if (msg == null) {
            return String.format("0x%04X", sw);
        }
        return String.format("0x%04X (%s)", sw, msg);
    }

    public static String oid2string(byte[] oid) {
        try {
            ASN1ObjectIdentifier realoid;
            if (oid[0] != 6) {
                oid = GPUtils.concatenate({6, (byte)oid.length}, oid);
            }
            if ((realoid = (ASN1ObjectIdentifier)ASN1ObjectIdentifier.fromByteArray((byte[])oid)) == null) {
                throw new IllegalArgumentException("Could not parse OID from " + HexUtils.bin2hex((byte[])oid));
            }
            return realoid.toString();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not handle " + HexUtils.bin2hex((byte[])oid));
        }
    }

    public static GPSession.GPSpec oid2version(byte[] bytes) throws GPDataException {
        String oid = GPData.oid2string(bytes);
        if (oid.equals("1.2.840.114283.2.2.1.1")) {
            return GPSession.GPSpec.GP211;
        }
        if (oid.equals("1.2.840.114283.2.2.2")) {
            return GPSession.GPSpec.GP22;
        }
        if (oid.equals("1.2.840.114283.2.2.2.1")) {
            return GPSession.GPSpec.GP22;
        }
        throw new GPDataException("Unknown GP version OID: " + oid, bytes);
    }

    public static byte[] getData(APDUBIBO channel, int p1, int p2, String name, boolean failsafe) throws IOException {
        logger.trace("GET DATA({})", (Object)name);
        ResponseAPDU resp = channel.transmit(new CommandAPDU(-128, 202, p1, p2, 256));
        if (failsafe && resp.getSW() != 36864) {
            resp = channel.transmit(new CommandAPDU(0, 202, p1, p2, 256));
        }
        if (resp.getSW() == 36864) {
            return resp.getData();
        }
        if (resp.getSW() == 27272) {
            logger.debug("GET DATA({}): N/A", (Object)name);
            return null;
        }
        logger.warn("GET DATA({}) not supported", (Object)name);
        return null;
    }

    static {
        sw.put(25600, "No specific diagnosis");
        sw.put(26368, "Wrong length (Lc)");
        sw.put(27904, "Invalid INStruction");
        sw.put(28160, "Invalid CLAss");
        sw.put(25219, "Card Life Cycle State is CARD_LOCKED");
        sw.put(25985, "Memory failure");
        sw.put(26754, "Secure messaging not supported");
        sw.put(27010, "Security status not satisfied");
        sw.put(27013, "Conditions of use not satisfied");
        sw.put(27264, "Wrong data/incorrect values in data");
        sw.put(27265, "Function not supported e.g. card Life Cycle State is CARD_LOCKED");
        sw.put(27266, "Application/file not found");
        sw.put(27268, "Not enough memory space");
        sw.put(27270, "Incorrect P1/P2");
        sw.put(27272, "Referenced data not found");
    }

    public static final class CPLC {
        private HashMap<Field, byte[]> values = new HashMap();

        private CPLC(byte[] data) {
            int offset = 0;
            this.values.put(Field.ICFabricator, Arrays.copyOfRange(data, offset, offset + 2));
            this.values.put(Field.ICType, Arrays.copyOfRange(data, offset += 2, offset + 2));
            this.values.put(Field.OperatingSystemID, Arrays.copyOfRange(data, offset += 2, offset + 2));
            this.values.put(Field.OperatingSystemReleaseDate, Arrays.copyOfRange(data, offset += 2, offset + 2));
            this.values.put(Field.OperatingSystemReleaseLevel, Arrays.copyOfRange(data, offset += 2, offset + 2));
            this.values.put(Field.ICFabricationDate, Arrays.copyOfRange(data, offset += 2, offset + 2));
            this.values.put(Field.ICSerialNumber, Arrays.copyOfRange(data, offset += 2, offset + 4));
            this.values.put(Field.ICBatchIdentifier, Arrays.copyOfRange(data, offset += 4, offset + 2));
            this.values.put(Field.ICModuleFabricator, Arrays.copyOfRange(data, offset += 2, offset + 2));
            this.values.put(Field.ICModulePackagingDate, Arrays.copyOfRange(data, offset += 2, offset + 2));
            this.values.put(Field.ICCManufacturer, Arrays.copyOfRange(data, offset += 2, offset + 2));
            this.values.put(Field.ICEmbeddingDate, Arrays.copyOfRange(data, offset += 2, offset + 2));
            this.values.put(Field.ICPrePersonalizer, Arrays.copyOfRange(data, offset += 2, offset + 2));
            this.values.put(Field.ICPrePersonalizationEquipmentDate, Arrays.copyOfRange(data, offset += 2, offset + 2));
            this.values.put(Field.ICPrePersonalizationEquipmentID, Arrays.copyOfRange(data, offset += 2, offset + 4));
            this.values.put(Field.ICPersonalizer, Arrays.copyOfRange(data, offset += 4, offset + 2));
            this.values.put(Field.ICPersonalizationDate, Arrays.copyOfRange(data, offset += 2, offset + 2));
            this.values.put(Field.ICPersonalizationEquipmentID, Arrays.copyOfRange(data, offset += 2, offset + 4));
            offset += 4;
        }

        public static CPLC fromBytes(byte[] data) throws GPDataException {
            if (data == null) {
                throw new IllegalArgumentException("data is null");
            }
            if (data.length < 42) {
                throw new GPDataException(String.format("Input can't be valid CPLC if length is only %02X!", data.length));
            }
            if (data[0] == -97 && data[1] == 127 && data[2] == 42) {
                data = Arrays.copyOfRange(data, 3, data.length);
            }
            return new CPLC(data);
        }

        public byte[] get(Field f) {
            return this.values.get((Object)f);
        }

        public String toString() {
            return Arrays.asList(Field.values()).stream().map(i -> i.toString() + "=" + HexUtils.bin2hex((byte[])this.values.get(i))).collect(Collectors.joining(", ", "[CPLC: ", "]"));
        }

        public String toPrettyString() {
            return Arrays.asList(Field.values()).stream().map(i -> i.toString() + "=" + HexUtils.bin2hex((byte[])this.values.get(i)) + (i.toString().endsWith("Date") ? " (" + CPLC.toDateFailsafe(this.values.get(i)) + ")" : "")).collect(Collectors.joining("\n      ", "CPLC: ", "\n"));
        }

        public static String toDate(byte[] v) throws GPDataException {
            String sv = HexUtils.bin2hex((byte[])v);
            try {
                int y = Integer.parseInt(sv.substring(0, 1));
                int d = Integer.parseInt(sv.substring(1, 4));
                if (d > 366) {
                    throw new GPDataException("Invalid CPLC date format: " + sv);
                }
                if (d == 0) {
                    d = 1;
                }
                GregorianCalendar gc = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
                gc.set(1, 2010 + y);
                gc.set(6, d);
                SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
                return f.format(gc.getTime());
            }
            catch (NumberFormatException e) {
                throw new GPDataException("Invalid CPLC date: " + sv, e);
            }
        }

        public static String toDateFailsafe(byte[] v) {
            try {
                return CPLC.toDate(v);
            }
            catch (GPDataException e) {
                logger.warn("Invalid CPLC date: " + HexUtils.bin2hex((byte[])v));
                return "invalid date format";
            }
        }

        public static byte[] today() {
            return CPLC.fromDate(new GregorianCalendar());
        }

        public static byte[] fromDate(GregorianCalendar d) {
            return HexUtils.hex2bin((String)String.format("%d%03d", d.get(1) - 2010, d.get(6)));
        }

        public static enum Field {
            ICFabricator,
            ICType,
            OperatingSystemID,
            OperatingSystemReleaseDate,
            OperatingSystemReleaseLevel,
            ICFabricationDate,
            ICSerialNumber,
            ICBatchIdentifier,
            ICModuleFabricator,
            ICModulePackagingDate,
            ICCManufacturer,
            ICEmbeddingDate,
            ICPrePersonalizer,
            ICPrePersonalizationEquipmentDate,
            ICPrePersonalizationEquipmentID,
            ICPersonalizer,
            ICPersonalizationDate,
            ICPersonalizationEquipmentID;

        }
    }
}

