/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.CommandAPDU;
import apdu4j.HexUtils;
import apdu4j.ResponseAPDU;
import java.io.IOException;
import java.io.PrintStream;
import pro.javacard.AID;
import pro.javacard.gp.GPException;
import pro.javacard.gp.GPRegistry;
import pro.javacard.gp.GPRegistryEntry;
import pro.javacard.gp.GPSession;
import pro.javacard.gp.GPUtils;

public class GPCommands {
    private static void storeDGI(GPSession gp, byte[] payload) throws GPException, IOException {
        CommandAPDU cmd = new CommandAPDU(-128, -30, 128, 0, payload);
        ResponseAPDU response = gp.transmit(cmd);
        GPException.check(response, "STORE DATA failed", new int[0]);
    }

    public static void setPrePerso(GPSession gp, byte[] data) throws GPException, IOException {
        if (data == null || data.length != 8) {
            throw new IllegalArgumentException("PrePerso data must be 8 bytes");
        }
        byte[] payload = GPUtils.concatenate({-97, 103, (byte)data.length}, data);
        GPCommands.storeDGI(gp, payload);
    }

    public static void setPerso(GPSession gp, byte[] data) throws GPException, IOException {
        if (data == null || data.length != 8) {
            throw new IllegalArgumentException("Perso data must be 8 bytes");
        }
        byte[] payload = GPUtils.concatenate({-97, 102, (byte)data.length}, data);
        GPCommands.storeDGI(gp, payload);
    }

    public static void listRegistry(GPRegistry reg, PrintStream out, boolean verbose) {
        String tab = "     ";
        for (GPRegistryEntry e : reg) {
            AID aid = e.getAID();
            out.print(e.getType().toShortString() + ": " + HexUtils.bin2hex((byte[])aid.getBytes()) + " (" + e.getLifeCycleString() + ")");
            if (e.getType() != GPRegistryEntry.Kind.IssuerSecurityDomain && verbose) {
                out.println(" (" + GPUtils.byteArrayToReadableString(aid.getBytes()) + ")");
            } else {
                out.println();
            }
            if (e.getDomain() != null) {
                out.println(tab + "Parent:  " + e.getDomain());
            }
            if (e.getType() == GPRegistryEntry.Kind.ExecutableLoadFile) {
                if (e.getVersion() != null) {
                    out.println(tab + "Version: " + e.getVersionString());
                }
                for (AID a : e.getModules()) {
                    out.print(tab + "Applet:  " + HexUtils.bin2hex((byte[])a.getBytes()));
                    if (verbose) {
                        out.println(" (" + GPUtils.byteArrayToReadableString(a.getBytes()) + ")");
                        continue;
                    }
                    out.println();
                }
            } else {
                if (e.getLoadFile() != null) {
                    out.println(tab + "From:    " + e.getLoadFile());
                }
                out.println(tab + "Privs:   " + e.getPrivileges());
            }
            out.println();
        }
    }
}

