/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.HexUtils;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.List;
import pro.javacard.gp.GPKeyInfo;
import pro.javacard.gp.GPSecureChannel;
import pro.javacard.gp.GPSessionKeys;

public abstract class GPCardKeys {
    protected GPSecureChannel scp;
    protected byte[] kdd;

    public abstract GPKeyInfo getKeyInfo();

    public abstract byte[] encrypt(byte[] var1) throws GeneralSecurityException;

    public abstract byte[] encryptKey(GPCardKeys var1, KeyPurpose var2) throws GeneralSecurityException;

    public abstract GPSessionKeys getSessionKeys(byte[] var1);

    public abstract byte[] kcv(KeyPurpose var1);

    public GPCardKeys diversify(GPSecureChannel scp, byte[] kdd) {
        this.scp = scp;
        this.kdd = (byte[])kdd.clone();
        return this;
    }

    public byte[] getKDD() {
        return (byte[])this.kdd.clone();
    }

    public String toString() {
        return String.format("KCV-s ENC=%s MAC=%s DEK=%s for %s", new Object[]{HexUtils.bin2hex((byte[])this.kcv(KeyPurpose.ENC)), HexUtils.bin2hex((byte[])this.kcv(KeyPurpose.MAC)), HexUtils.bin2hex((byte[])this.kcv(KeyPurpose.DEK)), this.scp});
    }

    public static enum KeyPurpose {
        ENC(1),
        MAC(2),
        DEK(3),
        RMAC(4);

        private final int value;

        private KeyPurpose(int value) {
            this.value = value;
        }

        public byte getValue() {
            return (byte)(this.value & 0xFF);
        }

        public static List<KeyPurpose> cardKeys() {
            return Arrays.asList(ENC, MAC, DEK);
        }
    }
}

