/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.HexUtils;
import com.payneteasy.tlv.BerTag;
import com.payneteasy.tlv.BerTlv;
import com.payneteasy.tlv.BerTlvLogger;
import com.payneteasy.tlv.BerTlvParser;
import com.payneteasy.tlv.BerTlvs;
import com.payneteasy.tlv.IBerTlvLogger;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import javax.crypto.Cipher;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.javacard.AID;
import pro.javacard.CAPFile;
import pro.javacard.gp.GPCrypto;
import pro.javacard.gp.GPData;
import pro.javacard.gp.GPDataException;
import pro.javacard.gp.GPException;
import pro.javacard.gp.GPKey;
import pro.javacard.gp.GPRegistry;
import pro.javacard.gp.GPRegistryEntry;
import pro.javacard.gp.GPSessionKeyProvider;
import pro.javacard.gp.GPUtils;
import pro.javacard.gp.SCP0102Wrapper;
import pro.javacard.gp.SCP03Wrapper;
import pro.javacard.gp.SecureChannelWrapper;

public class GlobalPlatform
extends CardChannel
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(GlobalPlatform.class);
    private static final String LFDBH_SHA1 = "SHA1";
    public static final int SCP_ANY = 0;
    public static final int SCP_01_05 = 1;
    public static final int SCP_01_15 = 2;
    public static final int SCP_02_04 = 3;
    public static final int SCP_02_05 = 4;
    public static final int SCP_02_0A = 5;
    public static final int SCP_02_0B = 6;
    public static final int SCP_02_14 = 7;
    public static final int SCP_02_15 = 8;
    public static final int SCP_02_1A = 9;
    public static final int SCP_02_1B = 10;
    public static final EnumSet<APDUMode> defaultMode = EnumSet.of(APDUMode.MAC);
    public static final byte CLA_GP = -128;
    public static final byte CLA_MAC = -124;
    public static final byte INS_INITIALIZE_UPDATE = 80;
    public static final byte INS_INSTALL = -26;
    public static final byte INS_LOAD = -24;
    public static final byte INS_DELETE = -28;
    public static final byte INS_GET_STATUS = -14;
    public static final byte INS_SET_STATUS = -16;
    public static final byte INS_PUT_KEY = -40;
    public static final byte INS_STORE_DATA = -30;
    public static final byte INS_GET_DATA = -54;
    public static final byte P1_INSTALL_AND_MAKE_SELECTABLE = 12;
    public static final byte P1_INSTALL_FOR_INSTALL = 4;
    protected boolean strict = true;
    GPSpec spec = GPSpec.GP211;
    private AID sdAID = null;
    private int scpMajorVersion = 0;
    private int scpKeyVersion = 0;
    private int blockSize = 255;
    private GPSessionKeyProvider sessionKeys = null;
    private SecureChannelWrapper wrapper = null;
    private CardChannel channel;
    private GPRegistry registry = null;
    private boolean dirty = true;

    public GlobalPlatform(CardChannel channel, AID sdAID) {
        if (channel == null) {
            throw new IllegalArgumentException("A card session is required");
        }
        this.channel = channel;
        this.sdAID = sdAID;
    }

    public static GlobalPlatform discover(CardChannel channel) throws GPException, CardException {
        BerTlv isdaid;
        byte[] identify_aid;
        CommandAPDU identify;
        ResponseAPDU identify_resp;
        byte[] identify_data;
        if (channel == null) {
            throw new IllegalArgumentException("channel is null");
        }
        CommandAPDU command = new CommandAPDU(0, 164, 4, 0, 256);
        ResponseAPDU response = channel.transmit(command);
        if (response.getSW() == 27266 && (identify_data = (identify_resp = channel.transmit(identify = new CommandAPDU(0, 164, 4, 0, identify_aid = HexUtils.hex2bin((String)"A000000167413000FF"), 256))).getData()).length > 15 && identify_data[14] == 0) {
            throw new GPException("Unfused JCOP detected");
        }
        if (response.getSW() == 27271) {
            logger.debug("Trying default ISD AID ...");
            return GlobalPlatform.connect(channel, new AID(GPData.defaultISDBytes));
        }
        GPException.check(response, "Could not SELECT default selected", 25219);
        BerTlvParser parser = new BerTlvParser();
        BerTlvs tlvs = parser.parse(response.getData());
        BerTlvLogger.log((String)"    ", (BerTlvs)tlvs, (IBerTlvLogger)GPData.getLoggerInstance());
        BerTlv fcitag = tlvs.find(new BerTag(111));
        if (fcitag != null && (isdaid = fcitag.find(new BerTag(132))) != null && isdaid.getBytesValue().length > 0) {
            AID detectedAID = new AID(isdaid.getBytesValue());
            logger.debug("Auto-detected ISD: " + detectedAID);
            return new GlobalPlatform(channel, detectedAID);
        }
        throw new GPDataException("Could not auto-detect ISD AID", response.getData());
    }

    public static GlobalPlatform connect(CardChannel channel, AID sdAID) throws CardException, GPException {
        if (channel == null) {
            throw new IllegalArgumentException("A card session is required");
        }
        if (sdAID == null) {
            throw new IllegalArgumentException("Security Domain AID is required");
        }
        logger.debug("(I)SD AID: " + sdAID);
        GlobalPlatform gp = new GlobalPlatform(channel, sdAID);
        gp.select(sdAID);
        return gp;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getVersion() {
        try (InputStream versionfile = GlobalPlatform.class.getResourceAsStream("pro_version.txt");){
            String version = "unknown-development";
            if (versionfile != null) {
                try (BufferedReader vinfo = new BufferedReader(new InputStreamReader(versionfile, StandardCharsets.US_ASCII));){
                    version = vinfo.readLine();
                }
            }
            String string = version;
            return string;
        }
        catch (IOException e) {
            return "unknown-error";
        }
    }

    @Override
    public void close() {
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void setBlockSize(int size) {
        this.blockSize = size;
    }

    public void setSpec(GPSpec spec) {
        this.spec = spec;
    }

    public AID getAID() {
        return new AID(this.sdAID.getBytes());
    }

    public CardChannel getCardChannel() {
        return this.channel;
    }

    protected void giveStrictWarning(String message) throws GPException {
        message = "STRICT WARNING: " + message;
        if (this.strict) {
            throw new GPException(message);
        }
        logger.warn(message);
    }

    public int getScpKeyVersion() {
        return this.scpKeyVersion;
    }

    void select(AID sdAID) throws GPException, CardException {
        CommandAPDU command = new CommandAPDU(0, 164, 4, 0, sdAID.getBytes(), 256);
        ResponseAPDU resp = this.channel.transmit(command);
        if (resp.getSW() == 25219) {
            logger.warn("SELECT ISD returned 6283 - CARD_LOCKED");
        }
        GPException.check(resp, "Could not SELECT Security Domain", 25219);
        this.parse_select_response(resp.getData());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parse_select_response(byte[] fci) throws GPException {
        BerTlvParser parser = new BerTlvParser();
        BerTlvs tlvs = parser.parse(fci);
        BerTlvLogger.log((String)"    ", (BerTlvs)tlvs, (IBerTlvLogger)GPData.getLoggerInstance());
        BerTlv fcitag = tlvs.find(new BerTag(111));
        if (fcitag != null) {
            BerTlv prop;
            AID detectedAID;
            BerTlv isdaid = fcitag.find(new BerTag(132));
            if (isdaid != null && !(detectedAID = new AID(isdaid.getBytesValue())).equals((Object)this.sdAID)) {
                this.giveStrictWarning(String.format("SD AID in FCI (%s) does not match the requested AID (%s)!", detectedAID, this.sdAID));
            }
            if ((prop = fcitag.find(new BerTag(165))) != null) {
                BerTlv maxbs;
                BerTlv lc;
                BerTlv isdd = prop.find(new BerTag(115));
                if (isdd != null) {
                    BerTlv oidtag = isdd.find(new BerTag(6));
                    if (oidtag != null) {
                        BerTlv veroid;
                        if (!Arrays.equals(oidtag.getBytesValue(), HexUtils.hex2bin((String)"2A864886FC6B01"))) throw new GPDataException("Invalid CardRecognitionData", oidtag.getBytesValue());
                        BerTlv vertag = isdd.find(new BerTag(96));
                        if (vertag != null && (veroid = vertag.find(new BerTag(6))) != null) {
                            this.spec = GPData.oid2version(veroid.getBytesValue());
                            logger.debug("Auto-detected GP version: " + (Object)((Object)this.spec));
                        }
                    } else {
                        logger.warn("Not global platform OID");
                    }
                }
                if ((lc = prop.find(new BerTag(159, 110))) != null) {
                    logger.debug("Lifecycle data (ignored): " + HexUtils.bin2hex((byte[])lc.getBytesValue()));
                }
                if ((maxbs = prop.find(new BerTag(159, 101))) == null) return;
                this.setBlockSize(maxbs.getBytesValue());
                return;
            } else {
                logger.warn("No mandatory proprietary info present in FCI");
            }
            return;
        } else {
            logger.warn("No FCI returned to SELECT");
        }
    }

    private void setBlockSize(byte[] blocksize) {
        int bs = new BigInteger(1, blocksize).intValue();
        if (bs > this.blockSize) {
            logger.warn("Ignoring auto-detected block size that exceeds set maximum: " + bs);
        } else {
            this.blockSize = bs;
            logger.debug("Auto-detected block size: " + this.blockSize);
        }
    }

    List<GPKey> getKeyInfoTemplate() throws CardException, GPException {
        ArrayList<GPKey> result = new ArrayList<GPKey>();
        result.addAll(GPData.get_key_template_list(GPData.fetchKeyInfoTemplate(this)));
        return result;
    }

    public void openSecureChannel(GPSessionKeyProvider keys, byte[] host_challenge, int scpVersion, EnumSet<APDUMode> securityLevel) throws CardException, GPException {
        CommandAPDU initUpdate;
        ResponseAPDU response;
        int sw;
        if (securityLevel.contains((Object)APDUMode.ENC)) {
            securityLevel.add(APDUMode.MAC);
        }
        if (host_challenge == null) {
            host_challenge = new byte[8];
            GPCrypto.random.nextBytes(host_challenge);
            logger.trace("Generated host challenge: " + HexUtils.bin2hex((byte[])host_challenge));
        }
        if ((sw = (response = this.channel.transmit(initUpdate = new CommandAPDU(-128, 80, keys.getVersion(), scpVersion == 1 ? keys.getID() : 0, host_challenge, 256))).getSW()) == 27010 || sw == 27011) {
            throw new GPException(sw, "INITIALIZE UPDATE failed, card LOCKED?");
        }
        GPException.check(response, "INITIALIZE UPDATE failed", new int[0]);
        byte[] update_response = response.getData();
        if (update_response.length != 28 && update_response.length != 29 && update_response.length != 32) {
            throw new GPException("Invalid INITIALIZE UPDATE response length: " + update_response.length);
        }
        int offset = 0;
        byte[] diversification_data = Arrays.copyOfRange(update_response, 0, 10);
        this.scpKeyVersion = update_response[offset += diversification_data.length] & 0xFF;
        this.scpMajorVersion = update_response[++offset];
        ++offset;
        int scp_i = -1;
        if (this.scpMajorVersion == 3) {
            scp_i = update_response[offset];
            ++offset;
        }
        byte[] card_challenge = Arrays.copyOfRange(update_response, offset, offset + 8);
        byte[] card_cryptogram = Arrays.copyOfRange(update_response, offset += card_challenge.length, offset + 8);
        offset += card_cryptogram.length;
        logger.debug("Host challenge: " + HexUtils.bin2hex((byte[])host_challenge));
        logger.debug("Card challenge: " + HexUtils.bin2hex((byte[])card_challenge));
        logger.debug("Card reports SCP0{}{} with key version {}", new Object[]{this.scpMajorVersion, this.scpMajorVersion == 3 ? " i=" + String.format("%02x", scp_i) : "", String.format("%d (0x%02X)", this.scpKeyVersion, this.scpKeyVersion)});
        if (keys.getVersion() > 0 && this.scpKeyVersion != keys.getVersion()) {
            throw new GPException("Key version mismatch: " + keys.getVersion() + " != " + this.scpKeyVersion);
        }
        if (scpVersion != this.scpMajorVersion && scpVersion != 0) {
            logger.debug("Overriding SCP version: card reports " + this.scpMajorVersion + " but user requested " + scpVersion);
            this.scpMajorVersion = scpVersion;
        }
        if (this.scpMajorVersion == 1) {
            scpVersion = 1;
        } else if (this.scpMajorVersion == 2) {
            scpVersion = 8;
        } else if (this.scpMajorVersion == 3) {
            scpVersion = 3;
        }
        logger.debug("Will do SCP0{} ({})", (Object)this.scpMajorVersion, (Object)scpVersion);
        if (this.scpMajorVersion == 1 && securityLevel.contains((Object)APDUMode.RMAC)) {
            logger.debug("SCP01 does not support RMAC, removing.");
            securityLevel.remove((Object)APDUMode.RMAC);
        }
        byte[] seq = null;
        if (this.scpMajorVersion == 2) {
            seq = Arrays.copyOfRange(update_response, 12, 14);
        } else if (this.scpMajorVersion == 3 && update_response.length == 32) {
            seq = Arrays.copyOfRange(update_response, 29, 32);
        }
        keys.calculate(this.scpMajorVersion, diversification_data, host_challenge, card_challenge, seq);
        byte[] my_card_cryptogram = null;
        byte[] cntx = GPUtils.concatenate(host_challenge, card_challenge);
        my_card_cryptogram = this.scpMajorVersion == 1 || this.scpMajorVersion == 2 ? GPCrypto.mac_3des_nulliv(keys.getKeyFor(GPSessionKeyProvider.KeyPurpose.ENC), cntx) : GPCrypto.scp03_kdf(keys.getKeyFor(GPSessionKeyProvider.KeyPurpose.MAC), (byte)0, cntx, 64);
        if (!Arrays.equals(card_cryptogram, my_card_cryptogram)) {
            if (System.console() != null) {
                System.err.println("Read more from https://github.com/martinpaljak/GlobalPlatformPro/wiki/Keys");
            }
            this.giveStrictWarning("Card cryptogram invalid!\nCard: " + HexUtils.bin2hex((byte[])card_cryptogram) + "\nHost: " + HexUtils.bin2hex((byte[])my_card_cryptogram) + "\n!!! DO NOT RE-TRY THE SAME COMMAND/KEYS OR YOU MAY BRICK YOUR CARD !!!");
        } else {
            logger.debug("Verified card cryptogram: " + HexUtils.bin2hex((byte[])my_card_cryptogram));
        }
        byte[] host_cryptogram = null;
        if (this.scpMajorVersion == 1 || this.scpMajorVersion == 2) {
            host_cryptogram = GPCrypto.mac_3des_nulliv(keys.getKeyFor(GPSessionKeyProvider.KeyPurpose.ENC), GPUtils.concatenate(card_challenge, host_challenge));
            this.wrapper = new SCP0102Wrapper(keys, scpVersion, EnumSet.of(APDUMode.MAC), null, null, this.blockSize);
        } else {
            host_cryptogram = GPCrypto.scp03_kdf(keys.getKeyFor(GPSessionKeyProvider.KeyPurpose.MAC), (byte)1, cntx, 64);
            this.wrapper = new SCP03Wrapper(keys, scpVersion, EnumSet.of(APDUMode.MAC), null, null, this.blockSize);
        }
        logger.debug("Calculated host cryptogram: " + HexUtils.bin2hex((byte[])host_cryptogram));
        int P1 = APDUMode.getSetValue(securityLevel);
        CommandAPDU externalAuthenticate = new CommandAPDU(-124, 130, P1, 0, host_cryptogram);
        response = this.transmit(externalAuthenticate);
        GPException.check(response, "External authenticate failed", new int[0]);
        this.sessionKeys = keys;
        this.wrapper.setSecurityLevel(securityLevel);
        if (this.scpMajorVersion != 3) {
            SCP0102Wrapper w = (SCP0102Wrapper)this.wrapper;
            if (securityLevel.contains((Object)APDUMode.RMAC)) {
                w.setRMACIV(w.getIV());
            }
        }
    }

    @Override
    public Card getCard() {
        return null;
    }

    @Override
    public int getChannelNumber() {
        return 0;
    }

    @Override
    public ResponseAPDU transmit(CommandAPDU command) throws CardException {
        try {
            CommandAPDU wc = this.wrapper.wrap(command);
            ResponseAPDU wr = this.channel.transmit(wc);
            return this.wrapper.unwrap(wr);
        }
        catch (GPException e) {
            throw new CardException("Secure channel failure: " + e.getMessage(), e);
        }
    }

    @Override
    public int transmit(ByteBuffer byteBuffer, ByteBuffer byteBuffer1) throws CardException {
        throw new IllegalStateException("Use the other transmit");
    }

    public int getSCPVersion() {
        return this.scpMajorVersion;
    }

    public void loadCapFile(CAPFile cap, AID target) throws CardException, GPException {
        if (target == null) {
            target = this.sdAID;
        }
        this.loadCapFile(cap, target, false, false, null, LFDBH_SHA1);
    }

    public void loadCapFile(CAPFile cap, AID target, byte[] dap, String hash) throws CardException, GPException {
        if (target == null) {
            target = this.sdAID;
        }
        this.loadCapFile(cap, target, false, false, dap, hash);
    }

    private void loadCapFile(CAPFile cap, AID sdaid, boolean includeDebug, boolean loadParam, byte[] dap, String lfdbh) throws GPException, CardException {
        byte[] byArray;
        if (this.getRegistry().allAIDs().contains(cap.getPackageAID())) {
            this.giveStrictWarning("Package with AID " + cap.getPackageAID() + " is already present on card");
        }
        byte[] hash = dap != null ? cap.getLoadFileDataHash(lfdbh, includeDebug) : new byte[]{};
        byte[] code = cap.getCode(includeDebug);
        if (loadParam) {
            byte[] byArray2 = new byte[6];
            byArray2[0] = -17;
            byArray2[1] = 4;
            byArray2[2] = -58;
            byArray2[3] = 2;
            byArray2[4] = (byte)((code.length & 0xFF00) >> 8);
            byArray = byArray2;
            byArray2[5] = (byte)(code.length & 0xFF);
        } else {
            byArray = new byte[]{};
        }
        byte[] loadParams = byArray;
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            bo.write(cap.getPackageAID().getLength());
            bo.write(cap.getPackageAID().getBytes());
            bo.write(sdaid.getLength());
            bo.write(sdaid.getBytes());
            bo.write(hash.length);
            bo.write(hash);
            bo.write(loadParams.length);
            bo.write(loadParams);
            bo.write(0);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        CommandAPDU installForLoad = new CommandAPDU(-128, -26, 2, 0, bo.toByteArray());
        ResponseAPDU response = this.transmit(installForLoad);
        GPException.check(response, "INSTALL [for load] failed", new int[0]);
        ByteArrayOutputStream loadblock = new ByteArrayOutputStream();
        try {
            if (dap != null) {
                loadblock.write(226);
                loadblock.write(GPUtils.encodeLength(sdaid.getLength() + dap.length + GPUtils.encodeLength(dap.length).length + 3));
                loadblock.write(79);
                loadblock.write(sdaid.getLength());
                loadblock.write(sdaid.getBytes());
                loadblock.write(195);
                loadblock.write(GPUtils.encodeLength(dap.length));
                loadblock.write(dap);
            }
            loadblock.write(196);
            loadblock.write(GPUtils.encodeLength(code.length));
            loadblock.write(code);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        List<byte[]> blocks = GPUtils.splitArray(loadblock.toByteArray(), this.wrapper.getBlockSize());
        for (int i = 0; i < blocks.size(); ++i) {
            CommandAPDU load = new CommandAPDU(-128, -24, i == blocks.size() - 1 ? 128 : 0, (int)((byte)i), blocks.get(i));
            response = this.transmit(load);
            GPException.check(response, "LOAD failed", new int[0]);
        }
        this.dirty = true;
    }

    @Deprecated
    public void installAndMakeSelectable(AID packageAID, AID appletAID, AID instanceAID, byte privileges, byte[] installParams, byte[] installToken) throws GPException, CardException {
        this.installAndMakeSelectable(packageAID, appletAID, instanceAID, GPRegistryEntry.Privileges.fromByte(privileges), installParams, installToken);
    }

    public void installAndMakeSelectable(AID packageAID, AID appletAID, AID instanceAID, GPRegistryEntry.Privileges privileges, byte[] installParams, byte[] installToken) throws GPException, CardException {
        if (instanceAID == null) {
            instanceAID = appletAID;
        }
        if (this.getRegistry().allAppletAIDs().contains(instanceAID)) {
            this.giveStrictWarning("Instance AID " + instanceAID + " is already present on card");
        }
        byte[] data = this.buildInstallData(packageAID, appletAID, instanceAID, privileges, installParams, installToken);
        CommandAPDU install = new CommandAPDU(-128, -26, 12, 0, data);
        ResponseAPDU response = this.transmit(install);
        GPException.check(response, "INSTALL [for install and make selectable] failed", new int[0]);
        this.dirty = true;
    }

    public void installForInstall(AID packageAID, AID appletAID, AID instanceAID, GPRegistryEntry.Privileges privileges, byte[] installParams, byte[] installToken) throws GPException, CardException {
        if (instanceAID == null) {
            instanceAID = appletAID;
        }
        if (this.getRegistry().allAppletAIDs().contains(instanceAID)) {
            this.giveStrictWarning("Instance AID " + instanceAID + " is already present on card");
        }
        byte[] data = this.buildInstallData(packageAID, appletAID, instanceAID, privileges, installParams, installToken);
        CommandAPDU install = new CommandAPDU(-128, -26, 4, 0, data);
        ResponseAPDU response = this.transmit(install);
        GPException.check(response, "INSTALL [for install] failed", new int[0]);
        this.dirty = true;
    }

    private byte[] buildInstallData(AID packageAID, AID appletAID, AID instanceAID, GPRegistryEntry.Privileges privileges, byte[] installParams, byte[] installToken) {
        if (instanceAID == null) {
            instanceAID = appletAID;
        }
        if (installParams == null || installParams.length == 0) {
            installParams = new byte[]{-55, 0};
        }
        if (installParams[0] != -55) {
            byte[] newparams = new byte[installParams.length + 2];
            newparams[0] = -55;
            newparams[1] = (byte)installParams.length;
            System.arraycopy(installParams, 0, newparams, 2, installParams.length);
            installParams = newparams;
        }
        if (installToken == null) {
            installToken = new byte[]{};
        }
        byte[] privs = privileges.toBytes();
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            bo.write(packageAID.getLength());
            bo.write(packageAID.getBytes());
            bo.write(appletAID.getLength());
            bo.write(appletAID.getBytes());
            bo.write(instanceAID.getLength());
            bo.write(instanceAID.getBytes());
            bo.write(privs.length);
            bo.write(privs);
            bo.write(installParams.length);
            bo.write(installParams);
            bo.write(installToken.length);
            bo.write(installToken);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return bo.toByteArray();
    }

    public void extradite(AID what, AID to) throws GPException, CardException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            bo.write(to.getLength());
            bo.write(to.getBytes());
            bo.write(0);
            bo.write(what.getLength());
            bo.write(what.getBytes());
            bo.write(0);
            bo.write(0);
            bo.write(0);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        CommandAPDU install = new CommandAPDU(-128, -26, 16, 0, bo.toByteArray());
        ResponseAPDU response = this.transmit(install);
        GPException.check(response, "INSTALL [for extradition] failed", new int[0]);
        this.dirty = true;
    }

    public void personalize(AID aid, byte[] data) throws CardException, GPException {
        this.personalize(aid, data, 128);
    }

    public void personalize(AID aid, byte[] data, int P1) throws CardException, GPException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            bo.write(0);
            bo.write(0);
            bo.write(aid.getLength());
            bo.write(aid.getBytes());
            bo.write(0);
            bo.write(0);
            bo.write(0);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        CommandAPDU install = new CommandAPDU(-128, -26, 32, 0, bo.toByteArray(), 256);
        ResponseAPDU response = this.transmit(install);
        GPException.check(response, "INSTALL [for personalization] failed", new int[0]);
        this.storeData(data, P1);
    }

    public void storeData(byte[] data, int P1) throws CardException, GPException {
        List<byte[]> blocks = GPUtils.splitArray(data, this.wrapper.getBlockSize());
        for (int i = 0; i < blocks.size(); ++i) {
            CommandAPDU load = new CommandAPDU(-128, -30, i == blocks.size() - 1 ? P1 | 0x80 : P1 & 0x7F, i, blocks.get(i), 256);
            ResponseAPDU response = this.transmit(load);
            GPException.check(response, "STORE DATA failed", new int[0]);
        }
    }

    public void makeDefaultSelected(AID aid) throws CardException, GPException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        GPRegistryEntry.Privileges ds = GPRegistryEntry.Privileges.set(GPRegistryEntry.Privilege.CardReset);
        byte privileges = ds.toByte();
        try {
            bo.write(0);
            bo.write(0);
            bo.write(aid.getLength());
            bo.write(aid.getBytes());
            bo.write(1);
            bo.write(privileges);
            bo.write(0);
            bo.write(0);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        CommandAPDU install = new CommandAPDU(-128, -26, 8, 0, bo.toByteArray());
        ResponseAPDU response = this.transmit(install);
        GPException.check(response, "INSTALL [for make selectable] failed", new int[0]);
        this.dirty = true;
    }

    public void lockUnlockApplet(AID app, boolean lock) throws CardException, GPException {
        CommandAPDU cmd = new CommandAPDU(-128, -16, 64, lock ? 128 : 0, app.getBytes());
        ResponseAPDU response = this.transmit(cmd);
        GPException.check(response, "SET STATUS failed", new int[0]);
        this.dirty = true;
    }

    public void setCardStatus(byte status) throws CardException, GPException {
        logger.debug("Setting status to {}", (Object)GPRegistryEntry.getLifeCycleString(GPRegistryEntry.Kind.IssuerSecurityDomain, status));
        CommandAPDU cmd = new CommandAPDU(-128, -16, 128, status);
        ResponseAPDU response = this.transmit(cmd);
        GPException.check(response, "SET STATUS failed", new int[0]);
        this.dirty = true;
    }

    public void deleteAID(AID aid, boolean deleteDeps) throws GPException, CardException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            bo.write(79);
            bo.write(aid.getLength());
            bo.write(aid.getBytes());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        CommandAPDU delete = new CommandAPDU(-128, -28, 0, deleteDeps ? 128 : 0, bo.toByteArray());
        ResponseAPDU response = this.transmit(delete);
        GPException.check(response, "Deletion failed", new int[0]);
        this.dirty = true;
    }

    public void deleteKey(int keyver) throws GPException, CardException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        bo.write(210);
        bo.write(keyver);
        CommandAPDU delete = new CommandAPDU(-128, -28, 0, 0, bo.toByteArray());
        ResponseAPDU response = this.transmit(delete);
        GPException.check(response, "Deletion failed", new int[0]);
    }

    public void renameISD(AID newaid) throws GPException, CardException {
        CommandAPDU rename = new CommandAPDU(-128, -30, 144, 0, GPUtils.concatenate({79, (byte)newaid.getLength()}, newaid.getBytes()));
        ResponseAPDU response = this.transmit(rename);
        GPException.check(response, "Rename failed", new int[0]);
    }

    private byte[] encodeKey(GPKey key, GPKey dek, boolean withCheck) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (key.getType() == GPKey.Type.DES3) {
                Cipher cipher = Cipher.getInstance("DESede/ECB/NoPadding");
                cipher.init(1, dek.getKeyAs(GPKey.Type.DES3));
                byte[] cgram = cipher.doFinal(key.getBytes(), 0, 16);
                baos.write(128);
                baos.write(cgram.length);
                baos.write(cgram);
                if (withCheck) {
                    byte[] kcv = GPCrypto.kcv_3des(key);
                    baos.write(kcv.length);
                    baos.write(kcv);
                } else {
                    baos.write(0);
                }
            } else if (key.getType() == GPKey.Type.AES) {
                byte[] cgram = GPCrypto.scp03_encrypt_key(dek, key);
                byte[] check = GPCrypto.scp03_key_check_value(key);
                baos.write(136);
                baos.write(cgram.length + 1);
                baos.write(key.getLength());
                baos.write(cgram);
                baos.write(check.length);
                baos.write(check);
            } else {
                throw new IllegalArgumentException("Don't know how to handle " + (Object)((Object)key.getType()));
            }
            return baos.toByteArray();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public void putKeys(List<GPKey> keys, boolean replace) throws GPException, CardException {
        if (keys.size() < 1 || keys.size() > 3) {
            throw new IllegalArgumentException("Can add 1 or up to 3 keys at a time");
        }
        if (keys.size() > 1) {
            for (int i = 1; i < keys.size(); ++i) {
                if (keys.get(i - 1).getID() == keys.get(i).getID() - 1) continue;
                throw new IllegalArgumentException("Key ID-s of multiple keys must be sequential!");
            }
        }
        logger.debug("PUT KEY version {}", (Object)keys.get(0).getVersion());
        for (GPKey k : keys) {
            logger.trace("PUT KEY:" + k);
        }
        List<GPKey> tmpl = this.getKeyInfoTemplate();
        if (tmpl.size() <= 0 && replace) {
            logger.warn("No key template on card but trying to replace. Implying add");
            replace = false;
        }
        int P1 = 0;
        if (replace) {
            P1 = keys.get(0).getVersion();
        }
        int P2 = keys.get(0).getID();
        if (keys.size() > 1) {
            P2 |= 0x80;
        }
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            bo.write(keys.get(0).getVersion());
            for (GPKey k : keys) {
                bo.write(this.encodeKey(k, this.sessionKeys.getKeyFor(GPSessionKeyProvider.KeyPurpose.DEK), true));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        CommandAPDU command = new CommandAPDU(-128, -40, P1, P2, bo.toByteArray());
        ResponseAPDU response = this.transmit(command);
        GPException.check(response, "PUT KEY failed", new int[0]);
    }

    public void putKey(RSAPublicKey pubkey, int version) throws CardException, GPException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            bo.write(version);
            bo.write(161);
            byte[] modulus = GPUtils.positive(pubkey.getModulus());
            byte[] exponent = GPUtils.positive(pubkey.getPublicExponent());
            bo.write(modulus.length);
            bo.write(modulus);
            bo.write(160);
            bo.write(exponent.length);
            bo.write(exponent);
            bo.write(0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        CommandAPDU command = new CommandAPDU(-128, -40, 0, 1, bo.toByteArray());
        ResponseAPDU response = this.transmit(command);
        GPException.check(response, "PUT KEY failed", new int[0]);
    }

    public GPRegistry getRegistry() throws GPException, CardException {
        if (this.dirty) {
            this.registry = this.getStatus();
            this.dirty = false;
        }
        return this.registry;
    }

    private byte[] getConcatenatedStatus(GPRegistry reg, int p1, byte[] data) throws CardException, GPException {
        int p2 = reg.tags ? 2 : 0;
        CommandAPDU cmd = new CommandAPDU(-128, -14, p1, p2, data, 256);
        ResponseAPDU response = this.transmit(cmd);
        if (p1 == 128 && response.getSW() == 27270 && p2 == 2) {
            reg.tags = false;
            return this.getConcatenatedStatus(reg, p1, data);
        }
        int sw = response.getSW();
        if (sw != 36864 && sw != 25360) {
            if (sw == 27272) {
                return response.getData();
            }
            logger.warn("GET STATUS failed for " + HexUtils.bin2hex((byte[])cmd.getBytes()) + " with " + GPData.sw2str(response.getSW()));
            return response.getData();
        }
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            bo.write(response.getData());
            while (response.getSW() == 25360 && response.getData().length > 0) {
                cmd = new CommandAPDU(-128, -14, p1, p2 | 1, data, 256);
                response = this.transmit(cmd);
                GPException.check(response, "GET STATUS failed for " + HexUtils.bin2hex((byte[])cmd.getBytes()), 25360);
                bo.write(response.getData());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return bo.toByteArray();
    }

    private GPRegistry getStatus() throws CardException, GPException {
        GPRegistry registry = new GPRegistry();
        if (this.spec == GPSpec.OP201) {
            registry.tags = false;
        }
        byte[] data = this.getConcatenatedStatus(registry, 128, new byte[]{79, 0});
        registry.parse(128, data, GPRegistryEntry.Kind.IssuerSecurityDomain, this.spec);
        data = this.getConcatenatedStatus(registry, 64, new byte[]{79, 0});
        registry.parse(64, data, GPRegistryEntry.Kind.Application, this.spec);
        data = this.getConcatenatedStatus(registry, 32, new byte[]{79, 0});
        registry.parse(32, data, GPRegistryEntry.Kind.ExecutableLoadFile, this.spec);
        if (this.spec != GPSpec.OP201) {
            data = this.getConcatenatedStatus(registry, 16, new byte[]{79, 0});
            registry.parse(16, data, GPRegistryEntry.Kind.ExecutableLoadFile, this.spec);
        }
        return registry;
    }

    public static enum GPSpec {
        OP201,
        GP211,
        GP22;

    }

    public static enum APDUMode {
        CLR(0),
        MAC(1),
        ENC(2),
        RMAC(16),
        RENC(32);

        private final int value;

        private APDUMode(int value) {
            this.value = value;
        }

        public static int getSetValue(EnumSet<APDUMode> s) {
            int v = 0;
            for (APDUMode m : s) {
                v |= m.value;
            }
            return v;
        }

        public static APDUMode fromString(String s) {
            return APDUMode.valueOf(s.trim().toUpperCase());
        }
    }
}

