/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.generators.KDFCounterBytesGenerator;
import org.bouncycastle.crypto.macs.CMac;
import org.bouncycastle.crypto.params.KDFCounterParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import pro.javacard.gp.GPKey;

public final class GPCrypto {
    static final byte[] null_bytes_8 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    static final byte[] null_bytes_16 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static final byte[] one_bytes_16 = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    static final String DES3_CBC_CIPHER = "DESede/CBC/NoPadding";
    static final String DES3_ECB_CIPHER = "DESede/ECB/NoPadding";
    static final String DES_CBC_CIPHER = "DES/CBC/NoPadding";
    static final String DES_ECB_CIPHER = "DES/ECB/NoPadding";
    static final String AES_CBC_CIPHER = "AES/CBC/NoPadding";
    static final IvParameterSpec iv_null_8 = new IvParameterSpec(null_bytes_8);
    static final IvParameterSpec iv_null_16 = new IvParameterSpec(null_bytes_16);
    static final SecureRandom random;

    public static byte[] pad80(byte[] text, int offset, int length, int blocksize) {
        if (length == -1) {
            length = text.length - offset;
        }
        int totalLength = length;
        ++totalLength;
        while (totalLength % blocksize != 0) {
            ++totalLength;
        }
        int padlength = totalLength - length;
        byte[] result = new byte[totalLength];
        System.arraycopy(text, offset, result, 0, length);
        result[length] = -128;
        for (int i = 1; i < padlength; ++i) {
            result[length + i] = 0;
        }
        return result;
    }

    public static byte[] pad80(byte[] text, int blocksize) {
        return GPCrypto.pad80(text, 0, text.length, blocksize);
    }

    public static byte[] unpad80(byte[] text) throws BadPaddingException {
        int offset;
        if (text.length < 1) {
            throw new BadPaddingException("Invalid ISO 7816-4 padding");
        }
        for (offset = text.length - 1; offset > 0 && text[offset] == 0; --offset) {
        }
        if (text[offset] != -128) {
            throw new BadPaddingException("Invalid ISO 7816-4 padding");
        }
        return Arrays.copyOf(text, offset);
    }

    private static void buffer_increment(byte[] buffer, int offset, int len) {
        if (len < 1) {
            return;
        }
        for (int i = offset + len - 1; i >= offset; --i) {
            if (buffer[i] != -1) {
                int n = i;
                buffer[n] = (byte)(buffer[n] + 1);
                break;
            }
            buffer[i] = 0;
        }
    }

    public static void buffer_increment(byte[] buffer) {
        GPCrypto.buffer_increment(buffer, 0, buffer.length);
    }

    public static byte[] mac_3des(GPKey key, byte[] text, byte[] iv) {
        byte[] d = GPCrypto.pad80(text, 8);
        return GPCrypto.mac_3des(key.getKeyAs(GPKey.Type.DES3), d, 0, d.length, iv);
    }

    public static byte[] mac_3des_nulliv(GPKey key, byte[] d) {
        return GPCrypto.mac_3des(key, d, null_bytes_8);
    }

    static byte[] mac_3des(Key key, byte[] text, int offset, int length, byte[] iv) {
        try {
            Cipher cipher = Cipher.getInstance(DES3_CBC_CIPHER);
            cipher.init(1, key, new IvParameterSpec(iv));
            byte[] result = new byte[8];
            byte[] res = cipher.doFinal(text, offset, length);
            System.arraycopy(res, res.length - 8, result, 0, 8);
            return result;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("MAC computation failed.", e);
        }
    }

    public static byte[] mac_des_3des(GPKey key, byte[] text, byte[] iv) {
        byte[] d = GPCrypto.pad80(text, 8);
        return GPCrypto.mac_des_3des(key, d, 0, d.length, iv);
    }

    private static byte[] mac_des_3des(GPKey key, byte[] text, int offset, int length, byte[] iv) {
        try {
            byte[] temp;
            Cipher cipher1 = Cipher.getInstance(DES_CBC_CIPHER);
            cipher1.init(1, key.getKeyAs(GPKey.Type.DES), new IvParameterSpec(iv));
            Cipher cipher2 = Cipher.getInstance(DES3_CBC_CIPHER);
            cipher2.init(1, key.getKeyAs(GPKey.Type.DES3), new IvParameterSpec(iv));
            byte[] result = new byte[8];
            if (length > 8) {
                temp = cipher1.doFinal(text, offset, length - 8);
                System.arraycopy(temp, temp.length - 8, result, 0, 8);
                cipher2.init(1, key.getKeyAs(GPKey.Type.DES3), new IvParameterSpec(result));
            }
            temp = cipher2.doFinal(text, offset + length - 8, 8);
            System.arraycopy(temp, temp.length - 8, result, 0, 8);
            return result;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("MAC computation failed.", e);
        }
    }

    public static byte[] scp03_mac(GPKey key, byte[] msg, int lengthbits) {
        return GPCrypto.scp03_mac(key.getBytes(), msg, lengthbits);
    }

    public static byte[] scp03_mac(byte[] keybytes, byte[] msg, int lengthBits) {
        AESEngine cipher = new AESEngine();
        CMac cmac = new CMac((BlockCipher)cipher);
        cmac.init((CipherParameters)new KeyParameter(keybytes));
        cmac.update(msg, 0, msg.length);
        byte[] out = new byte[cmac.getMacSize()];
        cmac.doFinal(out, 0);
        return Arrays.copyOf(out, lengthBits / 8);
    }

    public static byte[] scp03_kdf(GPKey key, byte constant, byte[] context, int blocklen_bits) {
        return GPCrypto.scp03_kdf(key.getBytes(), constant, context, blocklen_bits);
    }

    private static byte[] scp03_kdf(byte[] key, byte constant, byte[] context, int blocklen_bits) {
        byte[] label = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            bo.write(label);
            bo.write(constant);
            bo.write(0);
            bo.write(blocklen_bits >> 8 & 0xFF);
            bo.write(blocklen_bits & 0xFF);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        byte[] blocka = bo.toByteArray();
        byte[] blockb = context;
        return GPCrypto.scp03_kdf(key, blocka, blockb, blocklen_bits / 8);
    }

    public static byte[] scp03_kdf(byte[] key, byte[] a, byte[] b, int bytes) {
        AESEngine cipher = new AESEngine();
        CMac cmac = new CMac((BlockCipher)cipher);
        KDFCounterBytesGenerator kdf = new KDFCounterBytesGenerator((Mac)cmac);
        kdf.init((DerivationParameters)new KDFCounterParameters(key, a, b, 8));
        byte[] cgram = new byte[bytes];
        kdf.generateBytes(cgram, 0, cgram.length);
        return cgram;
    }

    public static byte[] scp03_key_check_value(GPKey key) {
        try {
            Cipher c = Cipher.getInstance(AES_CBC_CIPHER);
            c.init(1, key.getKeyAs(GPKey.Type.AES), iv_null_16);
            byte[] cv = c.doFinal(one_bytes_16);
            return Arrays.copyOfRange(cv, 0, 3);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Could not calculate KCV", e);
        }
    }

    public static byte[] scp03_encrypt_key(GPKey dek, GPKey key) {
        try {
            int n = key.getLength() % 16 + 1;
            byte[] plaintext = new byte[n * key.getLength()];
            random.nextBytes(plaintext);
            System.arraycopy(key.getBytes(), 0, plaintext, 0, key.getLength());
            Cipher c = Cipher.getInstance(AES_CBC_CIPHER);
            c.init(1, dek.getKeyAs(GPKey.Type.AES), iv_null_16);
            byte[] cgram = c.doFinal(plaintext);
            return cgram;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Could not encrypt key", e);
        }
    }

    public static byte[] kcv_3des(GPKey key) {
        try {
            Cipher cipher = Cipher.getInstance(DES3_ECB_CIPHER);
            cipher.init(1, key.getKeyAs(GPKey.Type.DES3));
            byte[] check = cipher.doFinal(null_bytes_8);
            return Arrays.copyOf(check, 3);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException("Could not calculate KCV", e);
        }
    }

    public static PublicKey pem2pubkey(InputStream in) throws IOException {
        Throwable throwable = null;
        try (PEMParser pem = new PEMParser((Reader)new InputStreamReader(in, StandardCharsets.US_ASCII));){
            Object ohh = pem.readObject();
            if (ohh instanceof PEMKeyPair) {
                PEMKeyPair kp = (PEMKeyPair)ohh;
                PublicKey publicKey = new JcaPEMKeyConverter().getKeyPair(kp).getPublic();
                return publicKey;
            }
            if (ohh instanceof SubjectPublicKeyInfo) {
                PublicKey publicKey = new JcaPEMKeyConverter().getPublicKey((SubjectPublicKeyInfo)ohh);
                return publicKey;
            }
            try {
                throw new IllegalArgumentException("Can not read PEM");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    static {
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
            random.nextBytes(new byte[2]);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Need SecureRandom to run");
        }
    }
}

