/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard;

import java.util.Objects;
import pro.javacard.AID;

public class CAPPackage {
    final AID aid;
    final int minor;
    final int major;
    final String name;

    public CAPPackage(AID aid, int major, int minor) {
        this(aid, major, minor, null);
    }

    public CAPPackage(AID aid, int major, int minor, String name) {
        this.aid = aid;
        this.major = major;
        this.minor = minor;
        this.name = name;
    }

    public boolean equals(Object other) {
        if (other instanceof CAPPackage) {
            CAPPackage o = (CAPPackage)other;
            return this.aid.equals(o.aid) && this.major == o.major && this.minor == o.minor;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.aid, this.major, this.minor);
    }

    public String toString() {
        return (this.name == null ? "(unknown)" : this.name + " ") + this.aid + String.format(" v%d.%d", this.major, this.minor);
    }

    public String getVersionString() {
        return String.format("%d.%d", this.major, this.minor);
    }

    public AID getAid() {
        return this.aid;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMajor() {
        return this.major;
    }
}

