/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import pro.javacard.CAPFile;

public class CAPFileSigner {
    public static void addSignature(CAPFile cap, PrivateKey key) throws GeneralSecurityException {
        RSAPrivateKey rkey;
        if (key instanceof RSAPrivateKey && (rkey = (RSAPrivateKey)key).getModulus().bitLength() == 1024) {
            Signature signer = Signature.getInstance("SHA1withRSA");
            signer.initSign(key);
            signer.update(cap.getLoadFileDataHash("SHA1", false));
            byte[] dap = signer.sign();
            cap.entries.put("META-INF/dap.rsa.sha1", dap);
            signer.initSign(key);
            signer.update(cap.getLoadFileDataHash("SHA-256", false));
            dap = signer.sign();
            cap.entries.put("META-INF/dap.rsa.sha256", dap);
            return;
        }
        throw new IllegalArgumentException("Only 1024 bit RSA keys are supported!");
    }

    public static KeyPair pem2keypair(String f) throws IOException {
        try (PEMParser pem = new PEMParser((Reader)new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));){
            PEMKeyPair kp = (PEMKeyPair)pem.readObject();
            KeyPair keyPair = new JcaPEMKeyConverter().getKeyPair(kp);
            return keyPair;
        }
    }
}

