/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSpec;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.profile.AbstractPerfAsmProfiler;
import org.openjdk.jmh.profile.PerfSupport;
import org.openjdk.jmh.profile.ProfilerException;
import org.openjdk.jmh.util.InputStreamDrainer;
import org.openjdk.jmh.util.Utils;

public class LinuxPerfAsmProfiler
extends AbstractPerfAsmProfiler {
    private final long sampleFrequency;
    private OptionSpec<Long> optFrequency;

    public LinuxPerfAsmProfiler(String initLine) throws ProfilerException {
        super(initLine, "cycles");
        Collection<String> failMsg = Utils.tryWith(PerfSupport.PERF_EXEC, "stat", "--log-fd", "2", "echo", "1");
        if (!failMsg.isEmpty()) {
            throw new ProfilerException(failMsg.toString());
        }
        try {
            this.sampleFrequency = this.set.valueOf(this.optFrequency);
        }
        catch (OptionException e) {
            throw new ProfilerException(e.getMessage());
        }
    }

    @Override
    protected void addMyOptions(OptionParser parser) {
        this.optFrequency = parser.accepts("frequency", "Sampling frequency. This is synonymous to perf record --freq #").withRequiredArg().ofType(Long.class).describedAs("freq").defaultsTo(1000L, (Long[])new Long[0]);
    }

    @Override
    public Collection<String> addJVMInvokeOptions(BenchmarkParams params) {
        return Arrays.asList(PerfSupport.PERF_EXEC, "record", "--freq", String.valueOf(this.sampleFrequency), "--event", Utils.join(this.events, ","), "--output", this.perfBinData.getAbsolutePath());
    }

    @Override
    public String getDescription() {
        return "Linux perf + PrintAssembly Profiler";
    }

    @Override
    protected void parseEvents() {
        try (FileOutputStream fos = new FileOutputStream(this.perfParsedData.file());){
            ProcessBuilder pb = new ProcessBuilder(PerfSupport.PERF_EXEC, "script", "--fields", "time,event,ip,sym,dso", "--input", this.perfBinData.getAbsolutePath());
            Process p = pb.start();
            InputStreamDrainer errDrainer = new InputStreamDrainer(p.getErrorStream(), fos);
            InputStreamDrainer outDrainer = new InputStreamDrainer(p.getInputStream(), fos);
            errDrainer.start();
            outDrainer.start();
            p.waitFor();
            errDrainer.join();
            outDrainer.join();
        }
        catch (IOException | InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    static PerfLine parsePerfLine(String line) {
        long addr;
        int addrIdx;
        double time;
        if (line.startsWith("#")) {
            return null;
        }
        int lastLength = -1;
        while (line.length() != lastLength) {
            lastLength = line.length();
            line = line.replace("  ", " ");
        }
        int timeIdx = line.indexOf(": ");
        if (timeIdx == -1) {
            return null;
        }
        String strTime = line.substring(0, timeIdx);
        line = line.substring(timeIdx + 2);
        try {
            time = Double.parseDouble(strTime);
        }
        catch (NumberFormatException e) {
            return null;
        }
        int libIdx = line.lastIndexOf(" (");
        if (libIdx == -1) {
            return null;
        }
        String lib = line.substring(libIdx);
        lib = lib.substring(lib.lastIndexOf("/") + 1).replace("(", "").replace(")", "");
        int evIdx = (line = line.substring(0, libIdx)).indexOf(": ");
        if (evIdx == -1) {
            return null;
        }
        String evName = line.substring(0, evIdx);
        int tagIdx = evName.lastIndexOf(":");
        if (tagIdx != -1) {
            evName = evName.substring(0, tagIdx);
        }
        if ((addrIdx = (line = line.substring(evIdx + 2)).indexOf(" ")) == -1) {
            return null;
        }
        String strAddr = line.substring(0, addrIdx);
        line = line.substring(addrIdx + 1);
        try {
            addr = Long.parseLong(strAddr, 16);
        }
        catch (NumberFormatException e) {
            try {
                addr = new BigInteger(strAddr, 16).longValue();
                if (addr < 0L && lib.contains("unknown")) {
                    lib = "kernel";
                }
            }
            catch (NumberFormatException e1) {
                addr = 0L;
            }
        }
        String symbol = line;
        return new PerfLine(time, evName, addr, symbol, lib);
    }

    /*
     * Exception decompiling
     */
    @Override
    protected AbstractPerfAsmProfiler.PerfEvents readEvents(double skipMs, double lenMs) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected String perfBinaryExtension() {
        return ".perfbin";
    }

    static class PerfLine {
        final double time;
        final String event;
        final long addr;
        final String symbol;
        final String lib;

        public PerfLine(double time, String event, long addr, String symbol, String lib) {
            this.time = time;
            this.event = event;
            this.addr = addr;
            this.symbol = symbol;
            this.lib = lib;
        }

        public double time() {
            return this.time;
        }

        public String eventName() {
            return this.event;
        }

        public long addr() {
            return this.addr;
        }

        public String symbol() {
            return this.symbol;
        }

        public String lib() {
            return this.lib;
        }
    }
}

