/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.condition;

import org.junit.jupiter.api.condition.DisabledForJreRange;
import org.junit.jupiter.api.condition.EnabledOnJreCondition;
import org.junit.jupiter.api.condition.JRE;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.Preconditions;

class DisabledForJreRangeCondition
implements ExecutionCondition {
    private static final ConditionEvaluationResult ENABLED_BY_DEFAULT = ConditionEvaluationResult.enabled("@DisabledForJreRange is not present");

    DisabledForJreRangeCondition() {
    }

    @Override
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        return AnnotationUtils.findAnnotation(context.getElement(), DisabledForJreRange.class).map(disabledForJreRange -> {
            JRE min = disabledForJreRange.min();
            JRE max = disabledForJreRange.max();
            Preconditions.condition(min != JRE.JAVA_8 || max != JRE.OTHER, "You must declare a non-default value for min or max in @DisabledForJreRange");
            Preconditions.condition(max.compareTo(min) >= 0, "@DisabledForJreRange.min must be less than or equal to @DisabledForJreRange.max");
            return JRE.isCurrentVersionWithinRange(min, max) ? EnabledOnJreCondition.DISABLED_ON_CURRENT_JRE : EnabledOnJreCondition.ENABLED_ON_CURRENT_JRE;
        }).orElse(ENABLED_BY_DEFAULT);
    }
}

