/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.MathUnsupportedOperationException;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SchurTransformer;
import org.apache.commons.math3.linear.SingularMatrixException;
import org.apache.commons.math3.linear.TriDiagonalTransformer;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;

public class EigenDecomposition {
    private static final double EPSILON = 1.0E-12;
    private byte maxIter = (byte)30;
    private double[] main;
    private double[] secondary;
    private TriDiagonalTransformer transformer;
    private double[] realEigenvalues;
    private double[] imagEigenvalues;
    private ArrayRealVector[] eigenvectors;
    private RealMatrix cachedV;
    private RealMatrix cachedD;
    private RealMatrix cachedVt;
    private final boolean isSymmetric;

    public EigenDecomposition(RealMatrix matrix) throws MathArithmeticException {
        double symTol = (double)(10 * matrix.getRowDimension() * matrix.getColumnDimension()) * Precision.EPSILON;
        this.isSymmetric = MatrixUtils.isSymmetric(matrix, symTol);
        if (this.isSymmetric) {
            this.transformToTridiagonal(matrix);
            this.findEigenVectors(this.transformer.getQ().getData());
        } else {
            SchurTransformer t = this.transformToSchur(matrix);
            this.findEigenVectorsFromSchur(t);
        }
    }

    @Deprecated
    public EigenDecomposition(RealMatrix matrix, double splitTolerance) throws MathArithmeticException {
        this(matrix);
    }

    public EigenDecomposition(double[] main, double[] secondary) {
        this.isSymmetric = true;
        this.main = (double[])main.clone();
        this.secondary = (double[])secondary.clone();
        this.transformer = null;
        int size = main.length;
        double[][] z = new double[size][size];
        for (int i2 = 0; i2 < size; ++i2) {
            z[i2][i2] = 1.0;
        }
        this.findEigenVectors(z);
    }

    @Deprecated
    public EigenDecomposition(double[] main, double[] secondary, double splitTolerance) {
        this(main, secondary);
    }

    public RealMatrix getV() {
        if (this.cachedV == null) {
            int m = this.eigenvectors.length;
            this.cachedV = MatrixUtils.createRealMatrix(m, m);
            for (int k = 0; k < m; ++k) {
                this.cachedV.setColumnVector(k, this.eigenvectors[k]);
            }
        }
        return this.cachedV;
    }

    public RealMatrix getD() {
        if (this.cachedD == null) {
            this.cachedD = MatrixUtils.createRealDiagonalMatrix(this.realEigenvalues);
            for (int i2 = 0; i2 < this.imagEigenvalues.length; ++i2) {
                if (Precision.compareTo(this.imagEigenvalues[i2], 0.0, 1.0E-12) > 0) {
                    this.cachedD.setEntry(i2, i2 + 1, this.imagEigenvalues[i2]);
                    continue;
                }
                if (Precision.compareTo(this.imagEigenvalues[i2], 0.0, 1.0E-12) >= 0) continue;
                this.cachedD.setEntry(i2, i2 - 1, this.imagEigenvalues[i2]);
            }
        }
        return this.cachedD;
    }

    public RealMatrix getVT() {
        if (this.cachedVt == null) {
            int m = this.eigenvectors.length;
            this.cachedVt = MatrixUtils.createRealMatrix(m, m);
            for (int k = 0; k < m; ++k) {
                this.cachedVt.setRowVector(k, this.eigenvectors[k]);
            }
        }
        return this.cachedVt;
    }

    public boolean hasComplexEigenvalues() {
        for (int i2 = 0; i2 < this.imagEigenvalues.length; ++i2) {
            if (Precision.equals(this.imagEigenvalues[i2], 0.0, 1.0E-12)) continue;
            return true;
        }
        return false;
    }

    public double[] getRealEigenvalues() {
        return (double[])this.realEigenvalues.clone();
    }

    public double getRealEigenvalue(int i2) {
        return this.realEigenvalues[i2];
    }

    public double[] getImagEigenvalues() {
        return (double[])this.imagEigenvalues.clone();
    }

    public double getImagEigenvalue(int i2) {
        return this.imagEigenvalues[i2];
    }

    public RealVector getEigenvector(int i2) {
        return this.eigenvectors[i2].copy();
    }

    public double getDeterminant() {
        double determinant = 1.0;
        for (double lambda : this.realEigenvalues) {
            determinant *= lambda;
        }
        return determinant;
    }

    public RealMatrix getSquareRoot() {
        if (!this.isSymmetric) {
            throw new MathUnsupportedOperationException();
        }
        double[] sqrtEigenValues = new double[this.realEigenvalues.length];
        for (int i2 = 0; i2 < this.realEigenvalues.length; ++i2) {
            double eigen = this.realEigenvalues[i2];
            if (eigen <= 0.0) {
                throw new MathUnsupportedOperationException();
            }
            sqrtEigenValues[i2] = FastMath.sqrt(eigen);
        }
        RealMatrix sqrtEigen = MatrixUtils.createRealDiagonalMatrix(sqrtEigenValues);
        RealMatrix v = this.getV();
        RealMatrix vT = this.getVT();
        return v.multiply(sqrtEigen).multiply(vT);
    }

    public DecompositionSolver getSolver() {
        if (this.hasComplexEigenvalues()) {
            throw new MathUnsupportedOperationException();
        }
        return new Solver(this.realEigenvalues, this.imagEigenvalues, this.eigenvectors);
    }

    private void transformToTridiagonal(RealMatrix matrix) {
        this.transformer = new TriDiagonalTransformer(matrix);
        this.main = this.transformer.getMainDiagonalRef();
        this.secondary = this.transformer.getSecondaryDiagonalRef();
    }

    private void findEigenVectors(double[][] householderMatrix) {
        int i2;
        double[][] z = (double[][])householderMatrix.clone();
        int n = this.main.length;
        this.realEigenvalues = new double[n];
        this.imagEigenvalues = new double[n];
        double[] e = new double[n];
        for (int i3 = 0; i3 < n - 1; ++i3) {
            this.realEigenvalues[i3] = this.main[i3];
            e[i3] = this.secondary[i3];
        }
        this.realEigenvalues[n - 1] = this.main[n - 1];
        e[n - 1] = 0.0;
        double maxAbsoluteValue = 0.0;
        for (i2 = 0; i2 < n; ++i2) {
            if (FastMath.abs(this.realEigenvalues[i2]) > maxAbsoluteValue) {
                maxAbsoluteValue = FastMath.abs(this.realEigenvalues[i2]);
            }
            if (!(FastMath.abs(e[i2]) > maxAbsoluteValue)) continue;
            maxAbsoluteValue = FastMath.abs(e[i2]);
        }
        if (maxAbsoluteValue != 0.0) {
            for (i2 = 0; i2 < n; ++i2) {
                if (FastMath.abs(this.realEigenvalues[i2]) <= Precision.EPSILON * maxAbsoluteValue) {
                    this.realEigenvalues[i2] = 0.0;
                }
                if (!(FastMath.abs(e[i2]) <= Precision.EPSILON * maxAbsoluteValue)) continue;
                e[i2] = 0.0;
            }
        }
        for (int j = 0; j < n; ++j) {
            int m;
            int its = 0;
            do {
                int i4;
                for (m = j; m < n - 1; ++m) {
                    double delta = FastMath.abs(this.realEigenvalues[m]) + FastMath.abs(this.realEigenvalues[m + 1]);
                    if (FastMath.abs(e[m]) + delta == delta) break;
                }
                if (m == j) continue;
                if (its == this.maxIter) {
                    throw new MaxCountExceededException((Localizable)LocalizedFormats.CONVERGENCE_FAILED, this.maxIter, new Object[0]);
                }
                ++its;
                double q = (this.realEigenvalues[j + 1] - this.realEigenvalues[j]) / (2.0 * e[j]);
                double t = FastMath.sqrt(1.0 + q * q);
                q = q < 0.0 ? this.realEigenvalues[m] - this.realEigenvalues[j] + e[j] / (q - t) : this.realEigenvalues[m] - this.realEigenvalues[j] + e[j] / (q + t);
                double u = 0.0;
                double s = 1.0;
                double c = 1.0;
                for (i4 = m - 1; i4 >= j; --i4) {
                    double p = s * e[i4];
                    double h = c * e[i4];
                    if (FastMath.abs(p) >= FastMath.abs(q)) {
                        c = q / p;
                        t = FastMath.sqrt(c * c + 1.0);
                        e[i4 + 1] = p * t;
                        s = 1.0 / t;
                        c *= s;
                    } else {
                        s = p / q;
                        t = FastMath.sqrt(s * s + 1.0);
                        e[i4 + 1] = q * t;
                        c = 1.0 / t;
                        s *= c;
                    }
                    if (e[i4 + 1] == 0.0) {
                        int n2 = i4 + 1;
                        this.realEigenvalues[n2] = this.realEigenvalues[n2] - u;
                        e[m] = 0.0;
                        break;
                    }
                    q = this.realEigenvalues[i4 + 1] - u;
                    t = (this.realEigenvalues[i4] - q) * s + 2.0 * c * h;
                    u = s * t;
                    this.realEigenvalues[i4 + 1] = q + u;
                    q = c * t - h;
                    for (int ia = 0; ia < n; ++ia) {
                        p = z[ia][i4 + 1];
                        z[ia][i4 + 1] = s * z[ia][i4] + c * p;
                        z[ia][i4] = c * z[ia][i4] - s * p;
                    }
                }
                if (t == 0.0 && i4 >= j) continue;
                int n3 = j;
                this.realEigenvalues[n3] = this.realEigenvalues[n3] - u;
                e[j] = q;
                e[m] = 0.0;
            } while (m != j);
        }
        for (i2 = 0; i2 < n; ++i2) {
            int j;
            int k = i2;
            double p = this.realEigenvalues[i2];
            for (j = i2 + 1; j < n; ++j) {
                if (!(this.realEigenvalues[j] > p)) continue;
                k = j;
                p = this.realEigenvalues[j];
            }
            if (k == i2) continue;
            this.realEigenvalues[k] = this.realEigenvalues[i2];
            this.realEigenvalues[i2] = p;
            for (j = 0; j < n; ++j) {
                p = z[j][i2];
                z[j][i2] = z[j][k];
                z[j][k] = p;
            }
        }
        maxAbsoluteValue = 0.0;
        for (i2 = 0; i2 < n; ++i2) {
            if (!(FastMath.abs(this.realEigenvalues[i2]) > maxAbsoluteValue)) continue;
            maxAbsoluteValue = FastMath.abs(this.realEigenvalues[i2]);
        }
        if (maxAbsoluteValue != 0.0) {
            for (i2 = 0; i2 < n; ++i2) {
                if (!(FastMath.abs(this.realEigenvalues[i2]) < Precision.EPSILON * maxAbsoluteValue)) continue;
                this.realEigenvalues[i2] = 0.0;
            }
        }
        this.eigenvectors = new ArrayRealVector[n];
        double[] tmp = new double[n];
        for (int i5 = 0; i5 < n; ++i5) {
            for (int j = 0; j < n; ++j) {
                tmp[j] = z[j][i5];
            }
            this.eigenvectors[i5] = new ArrayRealVector(tmp);
        }
    }

    private SchurTransformer transformToSchur(RealMatrix matrix) {
        SchurTransformer schurTransform = new SchurTransformer(matrix);
        double[][] matT = schurTransform.getT().getData();
        this.realEigenvalues = new double[matT.length];
        this.imagEigenvalues = new double[matT.length];
        for (int i2 = 0; i2 < this.realEigenvalues.length; ++i2) {
            if (i2 == this.realEigenvalues.length - 1 || Precision.equals(matT[i2 + 1][i2], 0.0, 1.0E-12)) {
                this.realEigenvalues[i2] = matT[i2][i2];
                continue;
            }
            double x = matT[i2 + 1][i2 + 1];
            double p = 0.5 * (matT[i2][i2] - x);
            double z = FastMath.sqrt(FastMath.abs(p * p + matT[i2 + 1][i2] * matT[i2][i2 + 1]));
            this.realEigenvalues[i2] = x + p;
            this.imagEigenvalues[i2] = z;
            this.realEigenvalues[i2 + 1] = x + p;
            this.imagEigenvalues[i2 + 1] = -z;
            ++i2;
        }
        return schurTransform;
    }

    private Complex cdiv(double xr, double xi, double yr, double yi) {
        return new Complex(xr, xi).divide(new Complex(yr, yi));
    }

    private void findEigenVectorsFromSchur(SchurTransformer schur) throws MathArithmeticException {
        double[][] matrixT = schur.getT().getData();
        double[][] matrixP = schur.getP().getData();
        int n = matrixT.length;
        double norm = 0.0;
        for (int i2 = 0; i2 < n; ++i2) {
            for (int j = FastMath.max(i2 - 1, 0); j < n; ++j) {
                norm += FastMath.abs(matrixT[i2][j]);
            }
        }
        if (Precision.equals(norm, 0.0, 1.0E-12)) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_NORM, new Object[0]);
        }
        double r = 0.0;
        double s = 0.0;
        double z = 0.0;
        for (int idx = n - 1; idx >= 0; --idx) {
            double t;
            int i3;
            int l;
            double p = this.realEigenvalues[idx];
            double q = this.imagEigenvalues[idx];
            if (Precision.equals(q, 0.0)) {
                l = idx;
                matrixT[idx][idx] = 1.0;
                for (i3 = idx - 1; i3 >= 0; --i3) {
                    double w = matrixT[i3][i3] - p;
                    r = 0.0;
                    for (int j = l; j <= idx; ++j) {
                        r += matrixT[i3][j] * matrixT[j][idx];
                    }
                    if ((double)Precision.compareTo(this.imagEigenvalues[i3], 0.0, 1.0E-12) < 0.0) {
                        z = w;
                        s = r;
                        continue;
                    }
                    l = i3;
                    if (Precision.equals(this.imagEigenvalues[i3], 0.0)) {
                        matrixT[i3][idx] = w != 0.0 ? -r / w : -r / (Precision.EPSILON * norm);
                    } else {
                        double x = matrixT[i3][i3 + 1];
                        double y = matrixT[i3 + 1][i3];
                        q = (this.realEigenvalues[i3] - p) * (this.realEigenvalues[i3] - p) + this.imagEigenvalues[i3] * this.imagEigenvalues[i3];
                        matrixT[i3][idx] = t = (x * s - z * r) / q;
                        matrixT[i3 + 1][idx] = FastMath.abs(x) > FastMath.abs(z) ? (-r - w * t) / x : (-s - y * t) / z;
                    }
                    double t2 = FastMath.abs(matrixT[i3][idx]);
                    if (!(Precision.EPSILON * t2 * t2 > 1.0)) continue;
                    for (int j = i3; j <= idx; ++j) {
                        matrixT[j][idx] = matrixT[j][idx] / t2;
                    }
                }
                continue;
            }
            if (!(q < 0.0)) continue;
            l = idx - 1;
            if (FastMath.abs(matrixT[idx][idx - 1]) > FastMath.abs(matrixT[idx - 1][idx])) {
                matrixT[idx - 1][idx - 1] = q / matrixT[idx][idx - 1];
                matrixT[idx - 1][idx] = -(matrixT[idx][idx] - p) / matrixT[idx][idx - 1];
            } else {
                Complex result = this.cdiv(0.0, -matrixT[idx - 1][idx], matrixT[idx - 1][idx - 1] - p, q);
                matrixT[idx - 1][idx - 1] = result.getReal();
                matrixT[idx - 1][idx] = result.getImaginary();
            }
            matrixT[idx][idx - 1] = 0.0;
            matrixT[idx][idx] = 1.0;
            for (i3 = idx - 2; i3 >= 0; --i3) {
                double ra = 0.0;
                double sa = 0.0;
                for (int j = l; j <= idx; ++j) {
                    ra += matrixT[i3][j] * matrixT[j][idx - 1];
                    sa += matrixT[i3][j] * matrixT[j][idx];
                }
                double w = matrixT[i3][i3] - p;
                if ((double)Precision.compareTo(this.imagEigenvalues[i3], 0.0, 1.0E-12) < 0.0) {
                    z = w;
                    r = ra;
                    s = sa;
                    continue;
                }
                l = i3;
                if (Precision.equals(this.imagEigenvalues[i3], 0.0)) {
                    Complex c = this.cdiv(-ra, -sa, w, q);
                    matrixT[i3][idx - 1] = c.getReal();
                    matrixT[i3][idx] = c.getImaginary();
                } else {
                    double x = matrixT[i3][i3 + 1];
                    double y = matrixT[i3 + 1][i3];
                    double vr = (this.realEigenvalues[i3] - p) * (this.realEigenvalues[i3] - p) + this.imagEigenvalues[i3] * this.imagEigenvalues[i3] - q * q;
                    double vi = (this.realEigenvalues[i3] - p) * 2.0 * q;
                    if (Precision.equals(vr, 0.0) && Precision.equals(vi, 0.0)) {
                        vr = Precision.EPSILON * norm * (FastMath.abs(w) + FastMath.abs(q) + FastMath.abs(x) + FastMath.abs(y) + FastMath.abs(z));
                    }
                    Complex c = this.cdiv(x * r - z * ra + q * sa, x * s - z * sa - q * ra, vr, vi);
                    matrixT[i3][idx - 1] = c.getReal();
                    matrixT[i3][idx] = c.getImaginary();
                    if (FastMath.abs(x) > FastMath.abs(z) + FastMath.abs(q)) {
                        matrixT[i3 + 1][idx - 1] = (-ra - w * matrixT[i3][idx - 1] + q * matrixT[i3][idx]) / x;
                        matrixT[i3 + 1][idx] = (-sa - w * matrixT[i3][idx] - q * matrixT[i3][idx - 1]) / x;
                    } else {
                        Complex c2 = this.cdiv(-r - y * matrixT[i3][idx - 1], -s - y * matrixT[i3][idx], z, q);
                        matrixT[i3 + 1][idx - 1] = c2.getReal();
                        matrixT[i3 + 1][idx] = c2.getImaginary();
                    }
                }
                t = FastMath.max(FastMath.abs(matrixT[i3][idx - 1]), FastMath.abs(matrixT[i3][idx]));
                if (!(Precision.EPSILON * t * t > 1.0)) continue;
                for (int j = i3; j <= idx; ++j) {
                    matrixT[j][idx - 1] = matrixT[j][idx - 1] / t;
                    matrixT[j][idx] = matrixT[j][idx] / t;
                }
            }
        }
        for (int i4 = 0; i4 < n; ++i4) {
            if (!(i4 < 0 | i4 > n - 1)) continue;
            for (int j = i4; j < n; ++j) {
                matrixP[i4][j] = matrixT[i4][j];
            }
        }
        for (int j = n - 1; j >= 0; --j) {
            for (int i5 = 0; i5 <= n - 1; ++i5) {
                z = 0.0;
                for (int k = 0; k <= FastMath.min(j, n - 1); ++k) {
                    z += matrixP[i5][k] * matrixT[k][j];
                }
                matrixP[i5][j] = z;
            }
        }
        this.eigenvectors = new ArrayRealVector[n];
        double[] tmp = new double[n];
        for (int i6 = 0; i6 < n; ++i6) {
            for (int j = 0; j < n; ++j) {
                tmp[j] = matrixP[j][i6];
            }
            this.eigenvectors[i6] = new ArrayRealVector(tmp);
        }
    }

    private static class Solver
    implements DecompositionSolver {
        private double[] realEigenvalues;
        private double[] imagEigenvalues;
        private final ArrayRealVector[] eigenvectors;

        private Solver(double[] realEigenvalues, double[] imagEigenvalues, ArrayRealVector[] eigenvectors) {
            this.realEigenvalues = realEigenvalues;
            this.imagEigenvalues = imagEigenvalues;
            this.eigenvectors = eigenvectors;
        }

        public RealVector solve(RealVector b) {
            if (!this.isNonSingular()) {
                throw new SingularMatrixException();
            }
            int m = this.realEigenvalues.length;
            if (b.getDimension() != m) {
                throw new DimensionMismatchException(b.getDimension(), m);
            }
            double[] bp = new double[m];
            for (int i2 = 0; i2 < m; ++i2) {
                ArrayRealVector v = this.eigenvectors[i2];
                double[] vData = v.getDataRef();
                double s = v.dotProduct(b) / this.realEigenvalues[i2];
                for (int j = 0; j < m; ++j) {
                    int n = j;
                    bp[n] = bp[n] + s * vData[j];
                }
            }
            return new ArrayRealVector(bp, false);
        }

        public RealMatrix solve(RealMatrix b) {
            if (!this.isNonSingular()) {
                throw new SingularMatrixException();
            }
            int m = this.realEigenvalues.length;
            if (b.getRowDimension() != m) {
                throw new DimensionMismatchException(b.getRowDimension(), m);
            }
            int nColB = b.getColumnDimension();
            double[][] bp = new double[m][nColB];
            double[] tmpCol = new double[m];
            for (int k = 0; k < nColB; ++k) {
                int i2;
                for (i2 = 0; i2 < m; ++i2) {
                    tmpCol[i2] = b.getEntry(i2, k);
                    bp[i2][k] = 0.0;
                }
                for (i2 = 0; i2 < m; ++i2) {
                    int j;
                    ArrayRealVector v = this.eigenvectors[i2];
                    double[] vData = v.getDataRef();
                    double s = 0.0;
                    for (j = 0; j < m; ++j) {
                        s += v.getEntry(j) * tmpCol[j];
                    }
                    s /= this.realEigenvalues[i2];
                    for (j = 0; j < m; ++j) {
                        double[] dArray = bp[j];
                        int n = k;
                        dArray[n] = dArray[n] + s * vData[j];
                    }
                }
            }
            return new Array2DRowRealMatrix(bp, false);
        }

        public boolean isNonSingular() {
            for (int i2 = 0; i2 < this.realEigenvalues.length; ++i2) {
                if (this.realEigenvalues[i2] != 0.0 || this.imagEigenvalues[i2] != 0.0) continue;
                return false;
            }
            return true;
        }

        public RealMatrix getInverse() {
            if (!this.isNonSingular()) {
                throw new SingularMatrixException();
            }
            int m = this.realEigenvalues.length;
            double[][] invData = new double[m][m];
            for (int i2 = 0; i2 < m; ++i2) {
                double[] invI = invData[i2];
                for (int j = 0; j < m; ++j) {
                    double invIJ = 0.0;
                    for (int k = 0; k < m; ++k) {
                        double[] vK = this.eigenvectors[k].getDataRef();
                        invIJ += vK[i2] * vK[j] / this.realEigenvalues[k];
                    }
                    invI[j] = invIJ;
                }
            }
            return MatrixUtils.createRealMatrix(invData);
        }
    }
}

