/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.nativebytebuffers;

import com.github.marschall.nativebytebuffers.AllocationFailedException;
import com.github.marschall.nativebytebuffers.LibraryLoader;
import java.nio.ByteBuffer;
import java.util.Objects;

public final class Stdlib {
    private Stdlib() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static ByteBuffer malloc(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("non postive size: " + size);
        }
        ByteBuffer buffer = Stdlib.malloc0(size);
        if (buffer == null) {
            throw new AllocationFailedException("malloc failed");
        }
        return buffer;
    }

    private static native ByteBuffer malloc0(int var0);

    public static void free(ByteBuffer buffer) {
        Objects.requireNonNull(buffer, "buffer");
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("only direct buffers can be fee()ed");
        }
        Stdlib.free0(buffer);
    }

    private static native void free0(ByteBuffer var0);

    static {
        LibraryLoader.assertInitialized();
    }
}

