/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.nativebytebuffers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

final class LibraryLoader {
    static final boolean INITIALIZED;

    private static String getVersion() {
        String string;
        block10: {
            String fileName = "native-bytebuffers.version";
            InputStream stream = LibraryLoader.class.getClassLoader().getResourceAsStream(fileName);
            try {
                if (stream == null) {
                    throw new AssertionError((Object)("could not load resource: " + fileName));
                }
                ByteArrayOutputStream bos = new ByteArrayOutputStream(16);
                byte[] buffer = new byte[16];
                int read = 0;
                do {
                    if (read <= 0) continue;
                    bos.write(buffer, 0, read);
                } while ((read = stream.read(buffer)) != -1);
                string = new String(bos.toByteArray(), StandardCharsets.US_ASCII);
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new AssertionError("could not load file: " + fileName, e);
                }
            }
            stream.close();
        }
        return string;
    }

    private static Path extractLibrary(String fileName) {
        Path tempFile;
        try {
            tempFile = Files.createTempFile("native-bytebuffers-", ".so", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new AssertionError("could not create temp file", e);
        }
        try (OutputStream output = Files.newOutputStream(tempFile, new OpenOption[0]);
             InputStream input = LibraryLoader.class.getClassLoader().getResourceAsStream(fileName);){
            if (input == null) {
                throw new AssertionError((Object)("could not load resource: " + fileName));
            }
            byte[] buffer = new byte[8192];
            int read = 0;
            do {
                if (read <= 0) continue;
                output.write(buffer, 0, read);
            } while ((read = input.read(buffer)) != -1);
        }
        catch (IOException e) {
            throw new AssertionError("could copy to temp file: " + fileName, e);
        }
        return tempFile;
    }

    static void assertInitialized() {
        if (!INITIALIZED) {
            throw new IllegalStateException("not initialized");
        }
    }

    private LibraryLoader() {
        throw new AssertionError((Object)"not instantiable");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        boolean initialized = false;
        String version = LibraryLoader.getVersion();
        String libraryName = "native-bytebuffers-" + version;
        try {
            Runtime.getRuntime().loadLibrary(libraryName);
            initialized = true;
        }
        catch (UnsatisfiedLinkError e) {
            String fileName = System.mapLibraryName(libraryName);
            Path extracted = LibraryLoader.extractLibrary(fileName);
            try {
                System.load(extracted.toAbsolutePath().toString());
                initialized = true;
            }
            finally {
                try {
                    Files.delete(extracted);
                }
                catch (IOException e1) {
                    throw new AssertionError("could not delete temp file: " + fileName, e);
                }
            }
        }
        INITIALIZED = initialized;
    }
}

