/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.MethodDescriptor;
import org.junit.jupiter.engine.descriptor.MethodBasedTestDescriptor;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;

class DefaultMethodDescriptor
implements MethodDescriptor {
    private final MethodBasedTestDescriptor testDescriptor;

    DefaultMethodDescriptor(MethodBasedTestDescriptor testDescriptor) {
        this.testDescriptor = testDescriptor;
    }

    MethodBasedTestDescriptor getTestDescriptor() {
        return this.testDescriptor;
    }

    @Override
    public final Method getMethod() {
        return this.testDescriptor.getTestMethod();
    }

    @Override
    public boolean isAnnotated(Class<? extends Annotation> annotationType) {
        Preconditions.notNull(annotationType, "annotationType must not be null");
        return AnnotationUtils.isAnnotated(this.getMethod(), annotationType);
    }

    @Override
    public <A extends Annotation> Optional<A> findAnnotation(Class<A> annotationType) {
        Preconditions.notNull(annotationType, "annotationType must not be null");
        return AnnotationUtils.findAnnotation(this.getMethod(), annotationType);
    }

    @Override
    public <A extends Annotation> List<A> findRepeatableAnnotations(Class<A> annotationType) {
        Preconditions.notNull(annotationType, "annotationType must not be null");
        return AnnotationUtils.findRepeatableAnnotations(this.getMethod(), annotationType);
    }

    public String toString() {
        return new ToStringBuilder(this).append("method", this.getMethod().toGenericString()).toString();
    }
}

