/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.nativebytebuffers;

import com.github.marschall.nativebytebuffers.AllocationFailedException;
import com.github.marschall.nativebytebuffers.LibraryLoader;
import java.nio.ByteBuffer;
import java.util.Objects;

public final class Mman {
    private Mman() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static ByteBuffer mmap(int length) {
        return Mman.mmap(length, 33);
    }

    public static ByteBuffer mmap(int length, int flags) {
        if (length <= 0) {
            throw new IllegalArgumentException("non postive length: " + length);
        }
        ByteBuffer buffer = Mman.mmap0(length, flags);
        if (buffer == null) {
            throw new AllocationFailedException("mmap failed");
        }
        return buffer;
    }

    private static native ByteBuffer mmap0(int var0, int var1);

    public static void munmap(ByteBuffer buffer) {
        Objects.requireNonNull(buffer, "buffer");
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("only direct buffers can be munmap()ed");
        }
        Mman.munmap0(buffer);
    }

    private static native void munmap0(ByteBuffer var0);

    public static long getpagesize() {
        return Mman.getpagesize0();
    }

    private static native long getpagesize0();

    static {
        LibraryLoader.assertInitialized();
    }
}

