/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import com.github.marschall.memoryfilesystem.StringTransformer;
import java.text.Normalizer;
import java.util.Locale;

public final class StringTransformers {
    public static final StringTransformer IDENTIY = new IdentityTransformer();
    public static final StringTransformer MAC_OS = new MacOS();

    public StringTransformer caseInsensitive() {
        return StringTransformers.caseInsensitive(Locale.getDefault());
    }

    public static StringTransformer caseInsensitive(Locale locale) {
        return new CaseInsenstive(locale);
    }

    public static StringTransformer caseInsensitiveMacOS(Locale locale) {
        return new CaseInsenstiveMacOS(locale);
    }

    static final class IdentityTransformer
    implements StringTransformer {
        IdentityTransformer() {
        }

        @Override
        public String transform(String s) {
            return s;
        }
    }

    static final class CaseInsenstive
    implements StringTransformer {
        private final Locale locale;

        CaseInsenstive(Locale locale) {
            this.locale = locale;
        }

        @Override
        public String transform(String s) {
            return s.toUpperCase(this.locale);
        }
    }

    static final class CaseInsenstiveMacOS
    implements StringTransformer {
        private final Locale locale;

        CaseInsenstiveMacOS(Locale locale) {
            this.locale = locale;
        }

        @Override
        public String transform(String s) {
            return Normalizer.normalize(s, Normalizer.Form.NFD).toUpperCase(this.locale);
        }
    }

    static final class MacOS
    implements StringTransformer {
        MacOS() {
        }

        @Override
        public String transform(String s) {
            return Normalizer.normalize(s, Normalizer.Form.NFD);
        }
    }
}

