/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import java.io.IOException;
import java.nio.file.attribute.UserPrincipal;
import java.util.concurrent.Callable;

public final class CurrentUser {
    private static final ThreadLocal<UserPrincipal> USER = new ThreadLocal();

    private CurrentUser() {
        throw new AssertionError((Object)"not instantiable");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V> V useDuring(UserPrincipal user, UserTask<V> task) throws IOException {
        UserPrincipal previous = USER.get();
        try {
            USER.set(user);
            V v = task.call();
            return v;
        }
        finally {
            if (previous == null) {
                USER.remove();
            } else {
                USER.set(previous);
            }
        }
    }

    static UserPrincipal get() {
        return USER.get();
    }

    public static void remove() {
        USER.remove();
    }

    static interface UserTask<V>
    extends Callable<V> {
        @Override
        public V call() throws IOException;
    }
}

