/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import com.github.marschall.memoryfilesystem.InitializingFileAttributeView;
import com.github.marschall.memoryfilesystem.MemoryDirectoryStream;
import com.github.marschall.memoryfilesystem.MemoryEntry;
import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttributeView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class MemoryDirectory
extends MemoryEntry {
    private final Map<String, MemoryEntry> entries = new HashMap<String, MemoryEntry>();
    private final BasicFileAttributes attributes = new MemoryDirectoryFileAttributes();
    private final InitializingFileAttributeView basicFileAttributeView = new MemoryDirectoryFileAttributesView();

    MemoryDirectory(String originalName) {
        this(originalName, Collections.emptySet());
    }

    MemoryDirectory(String originalName, Set<Class<? extends FileAttributeView>> additionalViews) {
        super(originalName, additionalViews);
    }

    DirectoryStream<Path> newDirectoryStream(Path basePath, DirectoryStream.Filter<? super Path> filter) {
        ArrayList<String> elements = new ArrayList<String>(this.entries.keySet());
        return new MemoryDirectoryStream(basePath, filter, elements);
    }

    @Override
    InitializingFileAttributeView getBasicFileAttributeView() {
        return this.basicFileAttributeView;
    }

    @Override
    BasicFileAttributes getBasicFileAttributes() {
        return this.attributes;
    }

    MemoryEntry getEntry(String name) {
        return this.entries.get(name);
    }

    MemoryEntry getEntryOrException(String name, Path path) throws IOException {
        MemoryEntry entry = this.getEntry(name);
        if (entry == null) {
            throw new NoSuchFileException(path.toString());
        }
        return entry;
    }

    boolean isEmpty() {
        return this.entries.isEmpty();
    }

    void checkEmpty(Path path) throws IOException {
        if (this.isEmpty()) {
            throw new DirectoryNotEmptyException(path.toString());
        }
    }

    void addEntry(String name, MemoryEntry entry) throws IOException {
        MemoryEntry previous = this.entries.put(name, entry);
        if (previous != null) {
            this.entries.put(name, previous);
            throw new FileAlreadyExistsException("entry " + name + " already exists");
        }
        this.modified();
    }

    public String toString() {
        return "directory(" + this.getOriginalName() + ')';
    }

    void removeEntry(String name) {
        this.entries.remove(name);
        this.modified();
    }

    final class MemoryDirectoryFileAttributes
    extends MemoryEntry.MemoryEntryFileAttributes {
        MemoryDirectoryFileAttributes() {
            super(MemoryDirectory.this);
        }

        @Override
        public boolean isRegularFile() {
            return false;
        }

        @Override
        public boolean isDirectory() {
            return true;
        }

        @Override
        public boolean isSymbolicLink() {
            return false;
        }

        @Override
        public boolean isOther() {
            return false;
        }

        @Override
        public long size() {
            return -1L;
        }

        @Override
        public Object fileKey() {
            return MemoryDirectory.this;
        }
    }

    class MemoryDirectoryFileAttributesView
    extends MemoryEntry.MemoryEntryFileAttributesView {
        MemoryDirectoryFileAttributesView() {
            super(MemoryDirectory.this);
        }

        @Override
        public BasicFileAttributes readAttributes() throws IOException {
            return MemoryDirectory.this.attributes;
        }
    }
}

