/*
 * Decompiled with CFR 0.152.
 */
package com.github.maricn.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.LayoutBase;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlackAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private static final String API_URL = "https://slack.com/api/chat.postMessage";
    private static Layout<ILoggingEvent> defaultLayout = new LayoutBase<ILoggingEvent>(){

        public String doLayout(ILoggingEvent event) {
            StringBuffer sbuf = new StringBuffer(128);
            sbuf.append("-- ");
            sbuf.append("[");
            sbuf.append(event.getLevel());
            sbuf.append("]");
            sbuf.append(event.getLoggerName());
            sbuf.append(" - ");
            sbuf.append(event.getFormattedMessage().replaceAll("\n", "\n\t"));
            return sbuf.toString();
        }
    };
    private String token;
    private String channel;
    private Layout<ILoggingEvent> layout = defaultLayout;

    protected void append(ILoggingEvent evt) {
        try {
            URL url = new URL(API_URL);
            StringWriter w = new StringWriter();
            w.append("token=").append(this.token).append("&");
            w.append("text=").append(URLEncoder.encode(this.layout.doLayout((Object)evt), "UTF-8")).append('&');
            if (this.channel != null) {
                w.append("channel=").append(URLEncoder.encode(this.channel, "UTF-8"));
            }
            byte[] bytes = w.toString().getBytes("UTF-8");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setFixedLengthStreamingMode(bytes.length);
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            OutputStream os = conn.getOutputStream();
            os.write(bytes);
            os.flush();
            os.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.addError("Error posting log to Slack.com (" + this.channel + "): " + evt, ex);
        }
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public Layout<ILoggingEvent> getLayout() {
        return this.layout;
    }

    public void setLayout(Layout<ILoggingEvent> layout) {
        this.layout = layout;
    }
}

