/*
 * Decompiled with CFR 0.152.
 */
package com.luues.openoffice.utils;

import com.luues.openoffice.config.ConfigConstants;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class FtpUtils {
    @Autowired
    private ConfigConstants configConstants;
    private final Logger LOGGER = LoggerFactory.getLogger(FtpUtils.class);

    public FTPClient connect(String host, int port, String username, String password, String controlEncoding) throws IOException {
        int reply;
        FTPClient ftpClient = new FTPClient();
        ftpClient.connect(host, port);
        if (!StringUtils.isEmpty((Object)username) && !StringUtils.isEmpty((Object)password)) {
            ftpClient.login(username, password);
        }
        if (!FTPReply.isPositiveCompletion((int)(reply = ftpClient.getReplyCode()))) {
            ftpClient.disconnect();
        }
        ftpClient.setControlEncoding(controlEncoding);
        ftpClient.setFileType(2);
        return ftpClient;
    }

    public void download(String ftpUrl, String localFilePath, String ftpUsername, String ftpPassword, String ftpControlEncoding) throws IOException {
        String username = StringUtils.isEmpty((Object)ftpUsername) ? this.configConstants.getFtpUsername() : ftpUsername;
        String password = StringUtils.isEmpty((Object)ftpPassword) ? this.configConstants.getFtpPassword() : ftpPassword;
        String controlEncoding = StringUtils.isEmpty((Object)ftpControlEncoding) ? this.configConstants.getFtpControlEncoding() : ftpControlEncoding;
        URL url = new URL(ftpUrl);
        String host = url.getHost();
        int port = url.getPort() == -1 ? url.getDefaultPort() : url.getPort();
        String remoteFilePath = url.getPath();
        this.LOGGER.debug("FTP connection url:{}, username:{}, password:{}, controlEncoding:{}, localFilePath:{}", new Object[]{ftpUrl, username, password, controlEncoding, localFilePath});
        FTPClient ftpClient = this.connect(host, port, username, password, controlEncoding);
        FileOutputStream outputStream = new FileOutputStream(localFilePath);
        ftpClient.enterLocalPassiveMode();
        boolean downloadResult = ftpClient.retrieveFile(new String(remoteFilePath.getBytes(controlEncoding), "ISO-8859-1"), (OutputStream)outputStream);
        this.LOGGER.debug("FTP download result {}", (Object)downloadResult);
        outputStream.flush();
        ((OutputStream)outputStream).close();
        ftpClient.logout();
        ftpClient.disconnect();
    }
}

