/*
 * Decompiled with CFR 0.152.
 */
package com.luues.openoffice.utils;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteFileUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteFileUtil.class);

    public static boolean deleteFile(String fileName) {
        File file = new File(fileName);
        if (file.exists() && file.isFile()) {
            if (file.delete()) {
                LOGGER.info("\u5220\u9664\u5355\u4e2a\u6587\u4ef6" + fileName + "\u6210\u529f\uff01");
                return true;
            }
            LOGGER.info("\u5220\u9664\u5355\u4e2a\u6587\u4ef6" + fileName + "\u5931\u8d25\uff01");
            return false;
        }
        LOGGER.info("\u5220\u9664\u5355\u4e2a\u6587\u4ef6\u5931\u8d25\uff1a" + fileName + "\u4e0d\u5b58\u5728\uff01");
        return false;
    }

    public static boolean deleteDirectory(String dir) {
        File dirFile;
        if (!dir.endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        if (!(dirFile = new File(dir)).exists() || !dirFile.isDirectory()) {
            LOGGER.info("\u5220\u9664\u76ee\u5f55\u5931\u8d25\uff1a" + dir + "\u4e0d\u5b58\u5728\uff01");
            return false;
        }
        boolean flag = true;
        File[] files = dirFile.listFiles();
        for (int i = 0; i < files.length && !(files[i].isFile() ? !(flag = DeleteFileUtil.deleteFile(files[i].getAbsolutePath())) : files[i].isDirectory() && !(flag = DeleteFileUtil.deleteDirectory(files[i].getAbsolutePath()))); ++i) {
        }
        if (!flag) {
            LOGGER.info("\u5220\u9664\u76ee\u5f55\u5931\u8d25\uff01");
            return false;
        }
        return true;
    }
}

