/*
 * Decompiled with CFR 0.152.
 */
package com.luues.openoffice.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.luues.openoffice.model.FileAttribute;
import com.luues.openoffice.model.ReturnResponse;
import com.luues.openoffice.service.FilePreview;
import com.luues.openoffice.utils.DownloadUtils;
import com.luues.openoffice.utils.FileUtils;
import com.luues.openoffice.utils.ZipReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class CompressFilePreviewImpl
implements FilePreview {
    @Autowired
    FileUtils fileUtils;
    @Autowired
    DownloadUtils downloadUtils;
    @Autowired
    ZipReader zipReader;

    @Override
    public JSONObject filePreviewHandle(FileAttribute fileAttribute) {
        JSONObject jsonObject = new JSONObject();
        String fileName = fileAttribute.getName();
        String suffix = fileAttribute.getSuffix();
        String fileTree = null;
        if (!StringUtils.hasText((String)this.fileUtils.getConvertedFile(fileName))) {
            ReturnResponse<String> response = this.downloadUtils.downLoad(fileAttribute, fileName);
            if (0 != response.getCode()) {
                jsonObject.put("fileType", (Object)suffix);
                jsonObject.put("msg", (Object)response.getMsg());
                jsonObject.put("path", (Object)"fileNotSupported");
                return jsonObject;
            }
            String filePath = response.getContent();
            if ("zip".equalsIgnoreCase(suffix) || "jar".equalsIgnoreCase(suffix) || "gzip".equalsIgnoreCase(suffix)) {
                fileTree = this.zipReader.readZipFile(filePath, fileName);
            } else if ("rar".equalsIgnoreCase(suffix)) {
                fileTree = this.zipReader.unRar(filePath, fileName);
            } else if ("7z".equalsIgnoreCase(suffix)) {
                fileTree = this.zipReader.read7zFile(filePath, fileName);
            }
            if (fileTree != null && !"null".equals(fileTree)) {
                this.fileUtils.addConvertedFile(fileName, fileTree);
            }
        } else {
            fileTree = this.fileUtils.getConvertedFile(fileName);
        }
        if (fileTree != null && !"null".equals(fileTree)) {
            jsonObject.put("fileTree", (Object)fileTree);
            jsonObject.put("path", (Object)"compress");
            return jsonObject;
        }
        jsonObject.put("fileType", (Object)suffix);
        jsonObject.put("msg", (Object)"\u538b\u7f29\u6587\u4ef6\u7c7b\u578b\u4e0d\u53d7\u652f\u6301\uff0c\u5c1d\u8bd5\u5728\u538b\u7f29\u7684\u65f6\u5019\u9009\u62e9RAR4\u683c\u5f0f");
        jsonObject.put("path", (Object)"fileNotSupported");
        return jsonObject;
    }
}

