/*
 * Decompiled with CFR 0.152.
 */
package com.luues.openoffice.service.cache.impl;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.googlecode.concurrentlinkedhashmap.Weighers;
import com.luues.openoffice.service.cache.CacheService;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnExpression(value="'${cache.type:default}'.equals('default')")
public class CacheServiceJDKImpl
implements CacheService {
    private Map<String, String> pdfCache;
    private Map<String, List<String>> imgCache;
    private Map<String, Integer> pdfImagesCache;
    private static final int QUEUE_SIZE = 500000;
    private BlockingQueue blockingQueue = new ArrayBlockingQueue(500000);

    @Override
    public void initPDFCachePool(Integer capacity) {
        this.pdfCache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity((long)capacity.intValue()).weigher(Weighers.singleton()).build();
    }

    @Override
    public void initIMGCachePool(Integer capacity) {
        this.imgCache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity((long)capacity.intValue()).weigher(Weighers.singleton()).build();
    }

    @Override
    public void initPdfImagesCachePool(Integer capacity) {
        this.pdfImagesCache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity((long)capacity.intValue()).weigher(Weighers.singleton()).build();
    }

    @Override
    public void putPDFCache(String key, String value) {
        if (this.pdfCache == null) {
            this.initPDFCachePool(CacheService.DEFAULT_PDF_CAPACITY);
        }
        this.pdfCache.put(key, value);
    }

    @Override
    public void putImgCache(String key, List<String> value) {
        if (this.imgCache == null) {
            this.initIMGCachePool(CacheService.DEFAULT_IMG_CAPACITY);
        }
        this.imgCache.put(key, value);
    }

    @Override
    public Map<String, String> getPDFCache() {
        if (this.pdfCache == null) {
            this.initPDFCachePool(CacheService.DEFAULT_PDF_CAPACITY);
        }
        return this.pdfCache;
    }

    @Override
    public String getPDFCache(String key) {
        if (this.pdfCache == null) {
            this.initPDFCachePool(CacheService.DEFAULT_PDF_CAPACITY);
        }
        return this.pdfCache.get(key);
    }

    @Override
    public Map<String, List<String>> getImgCache() {
        if (this.imgCache == null) {
            this.initPDFCachePool(CacheService.DEFAULT_IMG_CAPACITY);
        }
        return this.imgCache;
    }

    @Override
    public List<String> getImgCache(String key) {
        if (this.imgCache == null) {
            this.initPDFCachePool(CacheService.DEFAULT_IMG_CAPACITY);
        }
        return this.imgCache.get(key);
    }

    @Override
    public Integer getPdfImageCache(String key) {
        if (this.pdfImagesCache == null) {
            this.initPdfImagesCachePool(CacheService.DEFAULT_PDFIMG_CAPACITY);
        }
        return this.pdfImagesCache.get(key);
    }

    @Override
    public void putPdfImageCache(String pdfFilePath, int num) {
        if (this.pdfImagesCache == null) {
            this.initPdfImagesCachePool(CacheService.DEFAULT_PDFIMG_CAPACITY);
        }
        this.pdfImagesCache.put(pdfFilePath, num);
    }

    @Override
    public void cleanCache() {
        this.initPDFCachePool(CacheService.DEFAULT_PDF_CAPACITY);
        this.initIMGCachePool(CacheService.DEFAULT_IMG_CAPACITY);
        this.initPdfImagesCachePool(CacheService.DEFAULT_PDFIMG_CAPACITY);
    }

    @Override
    public void addQueueTask(String url) {
        this.blockingQueue.add(url);
    }

    @Override
    public String takeQueueTask() throws InterruptedException {
        return String.valueOf(this.blockingQueue.take());
    }
}

