/*
 * Decompiled with CFR 0.152.
 */
package com.luues.openoffice.core.office;

import com.luues.openoffice.core.office.RetryTimeoutException;
import com.luues.openoffice.core.office.TemporaryException;

abstract class Retryable {
    Retryable() {
    }

    protected abstract void attempt() throws TemporaryException, Exception;

    public void execute(long interval, long timeout) throws RetryTimeoutException, Exception {
        this.execute(0L, interval, timeout);
    }

    public void execute(long delay, long interval, long timeout) throws RetryTimeoutException, Exception {
        long start = System.currentTimeMillis();
        if (delay > 0L) {
            this.sleep(delay);
        }
        while (true) {
            try {
                this.attempt();
                return;
            }
            catch (TemporaryException temporaryException) {
                if (System.currentTimeMillis() - start < timeout) {
                    this.sleep(interval);
                    continue;
                }
                throw new RetryTimeoutException(temporaryException.getCause());
            }
            break;
        }
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

