/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public enum Native {

    private static final String libnameShort = "zstd-jni";
    private static final String libname = "libzstd-jni";
    private static final String errorMsg = "Unsupported OS/arch, cannot find " + Native.resourceName() + " or load " + "zstd-jni" + " from system libraries. Please try building from source the jar or providing " + "libzstd-jni" + " in you system.";
    private static boolean loaded = false;

    private static String osName() {
        String string = System.getProperty("os.name").toLowerCase().replace(' ', '_');
        if (string.startsWith("win")) {
            return "win";
        }
        if (string.startsWith("mac")) {
            return "darwin";
        }
        return string;
    }

    private static String osArch() {
        return System.getProperty("os.arch");
    }

    private static String libExtension() {
        if (Native.osName().contains("os_x") || Native.osName().contains("darwin")) {
            return "dylib";
        }
        if (Native.osName().contains("win")) {
            return "dll";
        }
        return "so";
    }

    private static String resourceName() {
        return "/" + Native.osName() + "/" + Native.osArch() + "/" + libname + "." + Native.libExtension();
    }

    public static synchronized boolean isLoaded() {
        return loaded;
    }

    private static UnsatisfiedLinkError linkError(UnsatisfiedLinkError unsatisfiedLinkError) {
        UnsatisfiedLinkError unsatisfiedLinkError2 = new UnsatisfiedLinkError(unsatisfiedLinkError.getMessage() + "\n" + errorMsg);
        unsatisfiedLinkError2.setStackTrace(unsatisfiedLinkError.getStackTrace());
        return unsatisfiedLinkError2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void load() {
        if (loaded) {
            return;
        }
        String string = Native.resourceName();
        InputStream inputStream = Native.class.getResourceAsStream(string);
        if (inputStream == null) {
            try {
                System.loadLibrary(libnameShort);
                loaded = true;
                return;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw Native.linkError(unsatisfiedLinkError);
            }
        }
        try {
            File file = File.createTempFile(libname, "." + Native.libExtension());
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                int n;
                byte[] byArray = new byte[4096];
                while ((n = inputStream.read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n);
                }
                try {
                    fileOutputStream.close();
                    fileOutputStream = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    System.load(file.getAbsolutePath());
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    try {
                        System.loadLibrary(libnameShort);
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                        throw Native.linkError(unsatisfiedLinkError2);
                    }
                }
                loaded = true;
            }
            finally {
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
                if (file != null && file.exists()) {
                    if (!loaded) {
                        file.delete();
                    } else {
                        file.deleteOnExit();
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new ExceptionInInitializerError("Cannot unpack libzstd-jni");
        }
    }
}

