/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.util.Native;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ZstdOutputStream
extends FilterOutputStream {
    private long ctx = ZstdOutputStream.createCCtx();
    private static final int blockSize;
    private static final int oBuffSize;
    private int iBuffSize = 0;
    private ByteBuffer iBuff = null;
    private byte[] oBuff = null;
    private int iPos = 0;

    private static native long createCCtx();

    private static native int freeCCtx(long var0);

    private static native int findIBuffSize(int var0);

    private static native int compressBegin(long var0, int var2);

    private static native int compressContinue(long var0, byte[] var2, long var3, ByteBuffer var5, long var6, long var8);

    private static native int compressEnd(long var0, byte[] var2, long var3, ByteBuffer var5, long var6, long var8);

    public ZstdOutputStream(OutputStream outputStream, int n) throws IOException {
        super(outputStream);
        this.iBuffSize = ZstdOutputStream.findIBuffSize(n);
        this.iBuff = ByteBuffer.allocateDirect(this.iBuffSize);
        this.oBuff = new byte[oBuffSize];
        if (this.iBuff == null || this.oBuff == null) {
            throw new IOException("Error allocating the buffers");
        }
        int n2 = ZstdOutputStream.compressBegin(this.ctx, n);
        if (Zstd.isError(n2)) {
            throw new IOException("Compression error: cannot create header: " + Zstd.getErrorName(n2));
        }
        this.out.write(this.oBuff, 0, n2);
    }

    public ZstdOutputStream(OutputStream outputStream) throws IOException {
        this(outputStream, 1);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3 = this.iPos + blockSize - this.iBuff.position();
            if (n2 < n3) {
                this.iBuff.put(byArray, n, n2);
                n2 = 0;
                continue;
            }
            this.iBuff.put(byArray, n, n3);
            n += n3;
            n2 -= n3;
            long l = ZstdOutputStream.compressContinue(this.ctx, this.oBuff, oBuffSize, this.iBuff, this.iPos, blockSize);
            if (Zstd.isError(l)) {
                throw new IOException("Compression error: " + Zstd.getErrorName(l));
            }
            this.out.write(this.oBuff, 0, (int)l);
            this.iPos += blockSize;
            if (this.iPos != this.iBuffSize) continue;
            this.iPos = 0;
            this.iBuff.position(0);
        }
    }

    @Override
    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        int n = 0;
        int n2 = this.iBuff.position();
        n = ZstdOutputStream.compressEnd(this.ctx, this.oBuff, oBuffSize, this.iBuff, this.iPos, n2 - this.iPos);
        if (Zstd.isError(n)) {
            throw new IOException("Compression error: " + Zstd.getErrorName(n));
        }
        this.out.write(this.oBuff, 0, n);
        ZstdOutputStream.freeCCtx(this.ctx);
        this.out.close();
    }

    static {
        Native.load();
        blockSize = Zstd.blockSizeMax();
        oBuffSize = (int)Zstd.compressBound(blockSize) + 1;
    }
}

