/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.client.pipeline;

import com.github.loki4j.client.http.ApacheHttpClient;
import com.github.loki4j.client.http.HttpConfig;
import com.github.loki4j.client.http.JavaHttpClient;
import com.github.loki4j.client.http.Loki4jHttpClient;
import com.github.loki4j.client.util.ByteBufferFactory;
import com.github.loki4j.client.util.Loki4jLogger;
import com.github.loki4j.client.writer.JsonWriter;
import com.github.loki4j.client.writer.ProtobufWriter;
import com.github.loki4j.client.writer.Writer;
import java.util.function.BiFunction;
import java.util.function.Function;

public class PipelineConfig {
    public static final WriterFactory json = new WriterFactory((capacity, bufferFactory) -> new JsonWriter((int)capacity), "application/json");
    public static final WriterFactory protobuf = new WriterFactory((capacity, bbFactory) -> new ProtobufWriter((int)capacity, (ByteBufferFactory)bbFactory), "application/x-protobuf");
    public static final Function<HttpConfig, Loki4jHttpClient> defaultHttpClientFactory = cfg -> cfg.clientSpecific instanceof HttpConfig.JavaHttpConfig ? new JavaHttpClient((HttpConfig)cfg) : new ApacheHttpClient((HttpConfig)cfg);
    public final String name;
    public final int batchMaxItems;
    public final int batchMaxBytes;
    public final long batchTimeoutMs;
    public final boolean staticLabels;
    public final long sendQueueMaxBytes;
    public final int maxRetries;
    public final long minRetryBackoffMs;
    public final long maxRetryBackoffMs;
    public final int maxRetryJitterMs;
    public final boolean dropRateLimitedBatches;
    public final long internalQueuesCheckTimeoutMs;
    public final boolean useDirectBuffers;
    public final boolean drainOnStop;
    public final boolean metricsEnabled;
    public final WriterFactory writerFactory;
    public final HttpConfig httpConfig;
    public final Function<HttpConfig, Loki4jHttpClient> httpClientFactory;
    public final Function<Object, Loki4jLogger> internalLoggingFactory;

    public static HttpConfig.Builder apache(int maxConnections, long connectionKeepAliveMs) {
        return HttpConfig.builder().setClientConfig(new HttpConfig.ApacheHttpConfig(maxConnections, connectionKeepAliveMs));
    }

    public static HttpConfig.Builder java(long innerThreadsExpirationMs) {
        return HttpConfig.builder().setClientConfig(new HttpConfig.JavaHttpConfig(innerThreadsExpirationMs));
    }

    private PipelineConfig(String name, int batchMaxItems, int batchMaxBytes, long batchTimeoutMs, boolean staticLabels, long sendQueueMaxBytes, int maxRetries, long minRetryBackoffMs, long maxRetryBackoffMs, int maxRetryJitterMs, boolean dropRateLimitedBatches, long internalQueuesCheckTimeoutMs, boolean useDirectBuffers, boolean drainOnStop, boolean metricsEnabled, WriterFactory writerFactory, HttpConfig httpConfig, Function<HttpConfig, Loki4jHttpClient> httpClientFactory, Function<Object, Loki4jLogger> internalLoggingFactory) {
        this.name = name;
        this.batchMaxItems = batchMaxItems;
        this.batchMaxBytes = batchMaxBytes;
        this.batchTimeoutMs = batchTimeoutMs;
        this.staticLabels = staticLabels;
        this.sendQueueMaxBytes = sendQueueMaxBytes;
        this.maxRetries = maxRetries;
        this.minRetryBackoffMs = minRetryBackoffMs;
        this.maxRetryBackoffMs = maxRetryBackoffMs;
        this.maxRetryJitterMs = maxRetryJitterMs;
        this.dropRateLimitedBatches = dropRateLimitedBatches;
        this.internalQueuesCheckTimeoutMs = internalQueuesCheckTimeoutMs;
        this.useDirectBuffers = useDirectBuffers;
        this.drainOnStop = drainOnStop;
        this.metricsEnabled = metricsEnabled;
        this.writerFactory = writerFactory;
        this.httpConfig = httpConfig;
        this.httpClientFactory = httpClientFactory;
        this.internalLoggingFactory = internalLoggingFactory;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public static class WriterFactory {
        public final BiFunction<Integer, ByteBufferFactory, Writer> factory;
        public final String contentType;

        public WriterFactory(BiFunction<Integer, ByteBufferFactory, Writer> factory, String contentType) {
            this.factory = factory;
            this.contentType = contentType;
        }
    }

    public static class Builder {
        private String name = "loki4j";
        private int batchMaxItems = 1000;
        private int batchMaxBytes = 0x400000;
        private long batchTimeoutMs = 60000L;
        private boolean staticLabels = false;
        private long sendQueueMaxBytes = this.batchMaxBytes * 10;
        private int maxRetries = 2;
        private long minRetryBackoffMs = 500L;
        private long maxRetryBackoffMs = 60000L;
        private int maxRetryJitterMs = 500;
        private boolean dropRateLimitedBatches = false;
        private long internalQueuesCheckTimeoutMs = 25L;
        private boolean useDirectBuffers = true;
        private boolean drainOnStop = true;
        private boolean metricsEnabled = false;
        private WriterFactory writer = json;
        private HttpConfig.Builder httpConfigBuilder = PipelineConfig.java(300000L);
        private Function<HttpConfig, Loki4jHttpClient> httpClientFactory = defaultHttpClientFactory;
        private Function<Object, Loki4jLogger> internalLoggingFactory;

        public PipelineConfig build() {
            return new PipelineConfig(this.name, this.batchMaxItems, this.batchMaxBytes, this.batchTimeoutMs, this.staticLabels, this.sendQueueMaxBytes, this.maxRetries, this.minRetryBackoffMs, this.maxRetryBackoffMs, this.maxRetryJitterMs, this.dropRateLimitedBatches, this.internalQueuesCheckTimeoutMs, this.useDirectBuffers, this.drainOnStop, this.metricsEnabled, this.writer, this.httpConfigBuilder.build(this.writer.contentType), this.httpClientFactory, this.internalLoggingFactory);
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setBatchMaxItems(int batchMaxItems) {
            this.batchMaxItems = batchMaxItems;
            return this;
        }

        public Builder setBatchMaxBytes(int batchMaxBytes) {
            this.batchMaxBytes = batchMaxBytes;
            return this;
        }

        public Builder setBatchTimeoutMs(long batchTimeoutMs) {
            this.batchTimeoutMs = batchTimeoutMs;
            return this;
        }

        public Builder setStaticLabels(boolean staticLabels) {
            this.staticLabels = staticLabels;
            return this;
        }

        public Builder setSendQueueMaxBytes(long sendQueueMaxBytes) {
            this.sendQueueMaxBytes = sendQueueMaxBytes;
            return this;
        }

        public Builder setMaxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder setMinRetryBackoffMs(long minRetryBackoffMs) {
            this.minRetryBackoffMs = minRetryBackoffMs;
            return this;
        }

        public Builder setMaxRetryBackoffMs(long maxRetryBackoffMs) {
            this.maxRetryBackoffMs = maxRetryBackoffMs;
            return this;
        }

        public Builder setMaxRetryJitterMs(int maxRetryJitterMs) {
            this.maxRetryJitterMs = maxRetryJitterMs;
            return this;
        }

        public Builder setDropRateLimitedBatches(boolean dropRateLimitedBatches) {
            this.dropRateLimitedBatches = dropRateLimitedBatches;
            return this;
        }

        public Builder setInternalQueuesCheckTimeoutMs(long internalQueuesCheckTimeoutMs) {
            this.internalQueuesCheckTimeoutMs = internalQueuesCheckTimeoutMs;
            return this;
        }

        public Builder setUseDirectBuffers(boolean useDirectBuffers) {
            this.useDirectBuffers = useDirectBuffers;
            return this;
        }

        public Builder setDrainOnStop(boolean drainOnStop) {
            this.drainOnStop = drainOnStop;
            return this;
        }

        public Builder setMetricsEnabled(boolean metricsEnabled) {
            this.metricsEnabled = metricsEnabled;
            return this;
        }

        public Builder setWriter(WriterFactory writer) {
            this.writer = writer;
            return this;
        }

        public Builder setHttpConfig(HttpConfig.Builder httpConfigBuilder) {
            this.httpConfigBuilder = httpConfigBuilder;
            return this;
        }

        public Builder setHttpClientFactory(Function<HttpConfig, Loki4jHttpClient> httpClientFactory) {
            this.httpClientFactory = httpClientFactory;
            return this;
        }

        public Builder setInternalLoggingFactory(Function<Object, Loki4jLogger> internalLoggingFactory) {
            this.internalLoggingFactory = internalLoggingFactory;
            return this;
        }
    }
}

