/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.client.batch;

import com.github.loki4j.client.batch.BatchCondition;
import com.github.loki4j.client.batch.LogRecord;
import java.util.Arrays;
import java.util.Comparator;

public class LogRecordBatch {
    private long batchId;
    private LogRecord[] records;
    private int len;
    private int streamCount;
    private BatchCondition condition;
    private int estimatedSizeBytes;

    public LogRecordBatch(int capacity) {
        this.records = new LogRecord[capacity];
        this.clear();
    }

    public LogRecordBatch(LogRecord[] source) {
        this.records = new LogRecord[source.length];
        this.clear();
        this.initFrom(source, source.length, 1, BatchCondition.UNKNOWN, 0);
    }

    public void initFrom(LogRecord[] source, int len, int streamCount, BatchCondition condition, int estimatedSizeBytes) {
        if (len > this.records.length) {
            throw new RuntimeException(String.format("Source length %s exceeds available capacity %s", len, this.records.length));
        }
        this.batchId = System.nanoTime();
        System.arraycopy(source, 0, this.records, 0, len);
        this.len = len;
        this.streamCount = streamCount;
        this.condition = condition;
        this.estimatedSizeBytes = estimatedSizeBytes;
    }

    public void clear() {
        this.batchId = 0L;
        this.len = 0;
        this.streamCount = 0;
        Arrays.setAll(this.records, i -> null);
        this.condition = BatchCondition.UNKNOWN;
        this.estimatedSizeBytes = 0;
    }

    public void sort(Comparator<LogRecord> comp) {
        Arrays.sort(this.records, 0, this.len, comp);
    }

    public LogRecord get(int index) {
        if (index < 0 || index >= this.len) {
            throw new IndexOutOfBoundsException("LogRecordBatch: Index out of range: " + index);
        }
        return this.records[index];
    }

    public long batchId() {
        return this.batchId;
    }

    public int size() {
        return this.len;
    }

    public int streamCount() {
        return this.streamCount;
    }

    public boolean isEmpty() {
        return this.len == 0;
    }

    public int capacity() {
        return this.records.length;
    }

    public BatchCondition getCondition() {
        return this.condition;
    }

    public int getEstimatedSizeBytes() {
        return this.estimatedSizeBytes;
    }

    public LogRecord[] toArray() {
        return Arrays.copyOf(this.records, this.len);
    }

    public String toString() {
        return String.format("#%x (%s, %s records, %s streams, est. size %,d bytes)", new Object[]{this.batchId, this.condition, this.len, this.streamCount, this.estimatedSizeBytes});
    }
}

