/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.client.batch;

import com.github.loki4j.client.batch.LogRecordStream;
import com.github.loki4j.client.util.StringUtils;
import java.util.Arrays;

public class LogRecord {
    public final long timestampMs;
    public final int nanosInMs;
    public final LogRecordStream stream;
    public final String message;
    public final int messageUtf8SizeBytes;
    public final String[] metadata;
    public final int metadataUtf8SizeBytes;

    private LogRecord(long timestampMs, int nanosInMs, LogRecordStream stream, String message, String[] metadata) {
        this.timestampMs = timestampMs;
        this.nanosInMs = nanosInMs;
        this.stream = stream;
        this.message = message;
        this.messageUtf8SizeBytes = StringUtils.utf8Length(message);
        this.metadata = metadata;
        int metadataUtf8SizeBytes = 0;
        for (int i = 0; i < metadata.length; ++i) {
            metadataUtf8SizeBytes += StringUtils.utf8Length(metadata[i]);
        }
        this.metadataUtf8SizeBytes = metadataUtf8SizeBytes;
    }

    public static LogRecord create(long timestampMs, int nanosInMs, LogRecordStream stream, String message, String[] metadata) {
        return new LogRecord(timestampMs, nanosInMs, stream, message, metadata);
    }

    public String toString() {
        return "LogRecord [ts=" + this.timestampMs + ", nanos=" + this.nanosInMs + ", stream=" + this.stream + ", message=" + this.message + ", metadata=" + Arrays.toString(this.metadata) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.timestampMs ^ this.timestampMs >>> 32);
        result = 31 * result + this.nanosInMs;
        result = 31 * result + (this.stream == null ? 0 : this.stream.hashCode());
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LogRecord other = (LogRecord)obj;
        if (this.timestampMs != other.timestampMs) {
            return false;
        }
        if (this.nanosInMs != other.nanosInMs) {
            return false;
        }
        if (this.stream == null ? other.stream != null : !this.stream.equals(other.stream)) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        return !(this.metadata == null ? other.metadata != null : !Arrays.equals(this.metadata, other.metadata));
    }
}

