/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.client.writer;

import com.github.loki4j.client.batch.LogRecord;
import com.github.loki4j.client.batch.LogRecordBatch;
import com.github.loki4j.client.batch.LogRecordStream;
import com.github.loki4j.client.writer.Writer;
import com.github.loki4j.pkg.dslplatform.json.RawJsonWriter;
import java.nio.ByteBuffer;

public final class JsonWriter
implements Writer {
    private final RawJsonWriter raw;

    public JsonWriter(int capacity) {
        this.raw = new RawJsonWriter(capacity);
    }

    @Override
    public void serializeBatch(LogRecordBatch batch) {
        LogRecordStream currentStream = batch.get((int)0).stream;
        this.beginStreams(batch.get(0), currentStream.labels);
        for (int i = 1; i < batch.size(); ++i) {
            if (batch.get((int)i).stream != currentStream) {
                currentStream = batch.get((int)i).stream;
                this.nextStream(batch.get(i), currentStream.labels);
                continue;
            }
            this.nextRecord(batch.get(i));
        }
        this.endStreams();
    }

    @Override
    public int size() {
        return this.raw.size();
    }

    @Override
    public void toByteBuffer(ByteBuffer buffer) {
        this.raw.toByteBuffer(buffer);
    }

    @Override
    public byte[] toByteArray() {
        return this.raw.toByteArray();
    }

    @Override
    public final void reset() {
        this.raw.reset();
    }

    private void beginStreams(LogRecord firstRecord, String[] firstLabels) {
        this.raw.writeByte((byte)123);
        this.raw.writeAsciiString("streams");
        this.raw.writeByte((byte)58);
        this.raw.writeByte((byte)91);
        this.stream(firstRecord, firstLabels);
    }

    private void nextStream(LogRecord firstRecord, String[] labels) {
        this.raw.writeByte((byte)93);
        this.raw.writeByte((byte)125);
        this.raw.writeByte((byte)44);
        this.stream(firstRecord, labels);
    }

    private void stream(LogRecord firstRecord, String[] labels) {
        this.raw.writeByte((byte)123);
        this.raw.writeAsciiString("stream");
        this.raw.writeByte((byte)58);
        this.labels(labels);
        this.raw.writeByte((byte)44);
        this.raw.writeAsciiString("values");
        this.raw.writeByte((byte)58);
        this.raw.writeByte((byte)91);
        this.record(firstRecord);
    }

    private void labels(String[] labels) {
        this.raw.writeByte((byte)123);
        if (labels.length > 0) {
            for (int i = 0; i < labels.length; i += 2) {
                this.raw.writeString(labels[i]);
                this.raw.writeByte((byte)58);
                this.raw.writeString(labels[i + 1]);
                if (i >= labels.length - 2) continue;
                this.raw.writeByte((byte)44);
            }
        }
        this.raw.writeByte((byte)125);
    }

    private void nextRecord(LogRecord record) {
        this.raw.writeByte((byte)44);
        this.record(record);
    }

    private void record(LogRecord record) {
        this.raw.writeByte((byte)91);
        this.raw.writeAsciiString(record.timestampMs + this.nanosToStr(record.nanos));
        this.raw.writeByte((byte)44);
        this.raw.writeString(record.message);
        this.raw.writeByte((byte)93);
    }

    private String nanosToStr(int nanos) {
        char[] c = new char[6];
        int rem = nanos;
        for (int i = c.length - 1; i >= 0; --i) {
            c[i] = (char)(48 + rem % 10);
            rem /= 10;
        }
        return new String(c);
    }

    private void endStreams() {
        this.raw.writeByte((byte)93);
        this.raw.writeByte((byte)125);
        this.raw.writeByte((byte)93);
        this.raw.writeByte((byte)125);
    }
}

