/*
 * Decompiled with CFR 0.152.
 */
package com.lin.utils;

import com.lin.helper.DatabaseHelper;
import org.apache.commons.dbcp2.BasicDataSource;

public final class DBTools {
    private String url;
    private String username;
    private String password;
    private String driverClassName;

    private DBTools() {
    }

    public static DBTools url(String url) {
        return DBToolsHolder.INSTANCE.setUrl(url);
    }

    private DBTools setUrl(String url) {
        this.url = url;
        return this;
    }

    public static DBTools dbName(String dbName) {
        return DBToolsHolder.INSTANCE.setDbName(dbName);
    }

    private DBTools setDbName(String dbName) {
        if (this.url == null) {
            this.url = "jdbc:mysql://localhost:3306/" + dbName;
        }
        return this;
    }

    public DBTools username(String username) {
        this.username = username;
        return this;
    }

    public DBTools password(String password) {
        this.password = password;
        return this;
    }

    public DBTools driverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
        return this;
    }

    public void connect() {
        BasicDataSource dataSource = DatabaseHelper.getDataSource();
        if (this.url.isEmpty()) {
            throw new RuntimeException("\u6570\u636e\u5e93url\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.url.contains("jdbc:mysql")) {
            if (!this.url.contains("?")) {
                this.url = this.url + "?useSSL=true&useUnicode=true&characterEncoding=UTF-8&useOldAliasMetadataBehavior=true&autoReconnect=true&serverTimezone=UTC";
            } else if (this.url.contains("?")) {
                this.url = this.url + "&useSSL=true&useUnicode=true&characterEncoding=UTF-8&useOldAliasMetadataBehavior=true&autoReconnect=true&serverTimezone=UTC";
            }
        }
        dataSource.setUrl(this.url);
        dataSource.setUsername(this.username != null ? this.username : "root");
        dataSource.setPassword(this.password != null ? this.password : "123456");
        dataSource.setDriverClassName(this.driverClassName != null ? this.driverClassName : "com.mysql.jdbc.Driver");
        if (this.url.contains("jdbc:oracle")) {
            DatabaseHelper.executeUpdate("alter session set nls_date_format='yyyy-MM-dd hh24:mi:ss'", new Object[0]);
        }
    }

    private static final class DBToolsHolder {
        private static final DBTools INSTANCE = new DBTools();

        private DBToolsHolder() {
        }
    }
}

