/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.toolbox.plugins;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.swing.JInternalFrame;
import org.openpdf.text.Document;
import org.openpdf.text.pdf.PRAcroForm;
import org.openpdf.text.pdf.PdfCopy;
import org.openpdf.text.pdf.PdfImportedPage;
import org.openpdf.text.pdf.PdfReader;
import org.openpdf.toolbox.AbstractTool;
import org.openpdf.toolbox.arguments.AbstractArgument;
import org.openpdf.toolbox.arguments.FileArgument;
import org.openpdf.toolbox.arguments.filters.PdfFilter;

public class ReversePages
extends AbstractTool {
    FileArgument destfile = null;

    public ReversePages() {
        this.menuoptions = 3;
        FileArgument inputfile = null;
        inputfile = new FileArgument(this, "srcfile", "The file you want to reorder", false, new PdfFilter());
        this.arguments.add(inputfile);
        this.destfile = new FileArgument(this, "destfile", "The file to which the reordered version of the original PDF has to be written", true, new PdfFilter());
        this.arguments.add(this.destfile);
        inputfile.addPropertyChangeListener(this.destfile);
    }

    public static void main(String[] args) {
        ReversePages tool = new ReversePages();
        if (args.length < 2) {
            System.err.println(tool.getUsage());
        }
        tool.setMainArguments(args);
        tool.execute();
    }

    @Override
    protected void createFrame() {
        this.internalFrame = new JInternalFrame("ReversePages", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== ReversePages OPENED ===");
    }

    @Override
    public void execute() {
        try {
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            File src = (File)this.getValue("srcfile");
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file");
            }
            File dest = (File)this.getValue("destfile");
            PdfReader reader = new PdfReader(src.getAbsolutePath());
            System.out.println("The original file had " + reader.getNumberOfPages() + " pages.");
            int pages = reader.getNumberOfPages();
            ArrayList<Integer> li = new ArrayList<Integer>();
            for (int i = pages; i > 0; --i) {
                li.add(i);
            }
            reader.selectPages(li);
            System.err.println("The new file has " + pages + " pages.");
            Document document = new Document(reader.getPageSizeWithRotation(1));
            PdfCopy copy = new PdfCopy(document, (OutputStream)new FileOutputStream(dest.getAbsolutePath()));
            document.open();
            int i = 0;
            while (i < pages) {
                System.out.println("Processed page " + ++i);
                PdfImportedPage page = copy.getImportedPage(reader, i);
                copy.addPage(page);
            }
            PRAcroForm form = reader.getAcroForm();
            if (form != null) {
                copy.copyAcroForm(reader);
            }
            document.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void valueHasChanged(AbstractArgument arg) {
        if (this.internalFrame == null) {
            return;
        }
        if (this.destfile.getValue() == null && arg.getName().equalsIgnoreCase("srcfile")) {
            String filename = arg.getValue().toString();
            String filenameout = filename.substring(0, filename.indexOf(".", filename.length() - 4)) + "_out.pdf";
            this.destfile.setValue(filenameout);
        }
    }

    @Override
    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }

    static {
        ReversePages.addVersion("$Id: ReversePages.java 3271 2008-04-18 20:39:42Z xlv $");
    }
}

