/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.toolbox.arguments;

import java.awt.event.ActionEvent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.openpdf.text.Image;
import org.openpdf.toolbox.AbstractTool;
import org.openpdf.toolbox.arguments.AbstractArgument;
import org.openpdf.toolbox.arguments.filters.ImageFilter;

public class ImageArgument
extends AbstractArgument {
    private FileFilter filter;

    public ImageArgument(AbstractTool tool, String name, String description, FileFilter filter) {
        super(tool, name, description, null);
        this.filter = filter;
    }

    public ImageArgument(AbstractTool tool, String name, String description) {
        this(tool, name, description, new ImageFilter());
    }

    @Override
    public Object getArgument() throws InstantiationException {
        if (this.value == null) {
            return null;
        }
        try {
            return Image.getInstance((String)this.value.toString());
        }
        catch (Exception e) {
            throw new InstantiationException(e.getMessage());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser fc = new JFileChooser();
        if (this.filter != null) {
            fc.setFileFilter(this.filter);
        }
        fc.showOpenDialog(this.tool.getInternalFrame());
        try {
            this.setValue(fc.getSelectedFile().getAbsolutePath());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

