/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.rups.view.itext.treenodes;

import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.Text;
import org.openpdf.rups.view.icons.IconFetcher;
import org.openpdf.rups.view.icons.IconTreeNode;

public class XdpTreeNode
extends IconTreeNode {
    private static final long serialVersionUID = -6431790925424045933L;

    public XdpTreeNode(Node node) {
        super(null, node);
        if (node instanceof Element) {
            Element element = (Element)node;
            this.addChildNodes(element.attributes());
        }
        if (node instanceof Branch) {
            Branch branch = (Branch)node;
            this.addChildNodes(branch.content());
        }
        if (node instanceof Attribute) {
            this.icon = IconFetcher.getIcon("attribute.png");
            return;
        }
        if (node instanceof Text) {
            this.icon = IconFetcher.getIcon("text.png");
            return;
        }
        if (node instanceof ProcessingInstruction) {
            this.icon = IconFetcher.getIcon("pi.png");
            return;
        }
        if (node instanceof Document) {
            this.icon = IconFetcher.getIcon("xfa.png");
            return;
        }
        this.icon = IconFetcher.getIcon("tag.png");
    }

    private void addChildNodes(List list) {
        for (Object o : list) {
            Node n = (Node)o;
            if (n instanceof Namespace || n instanceof Comment) continue;
            this.add(new XdpTreeNode(n));
        }
    }

    public Node getNode() {
        return (Node)this.getUserObject();
    }

    @Override
    public String toString() {
        Node node = this.getNode();
        if (node instanceof Element) {
            Element e = (Element)node;
            return e.getName();
        }
        if (node instanceof Attribute) {
            Attribute a = (Attribute)node;
            StringBuilder buf = new StringBuilder();
            buf.append(a.getName());
            buf.append("=\"");
            buf.append(a.getValue());
            buf.append('\"');
            return buf.toString();
        }
        if (node instanceof Text) {
            Text t = (Text)node;
            return t.getText();
        }
        if (node instanceof ProcessingInstruction) {
            ProcessingInstruction pi = (ProcessingInstruction)node;
            StringBuilder buf = new StringBuilder("<?");
            buf.append(pi.getName());
            buf.append(' ');
            buf.append(pi.getText());
            buf.append("?>");
            return buf.toString();
        }
        if (node instanceof Document) {
            return "XFA Document";
        }
        return this.getNode().toString();
    }
}

