/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.rups.model;

import com.lowagie.rups.model.BackgroundTask;
import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFPage;

public class PageLoader
extends BackgroundTask {
    protected PDFFile file;
    protected int numberOfPages;
    protected boolean[] busy;
    protected boolean[] done;

    public PageLoader(PDFFile file) {
        this.file = file;
        this.numberOfPages = file.getNumPages();
        this.busy = new boolean[this.numberOfPages];
        this.done = new boolean[this.numberOfPages];
        this.start();
    }

    public int getNumberOfPages() {
        return this.numberOfPages;
    }

    public synchronized PDFPage loadPage(int pageNumber) {
        if (this.busy[--pageNumber]) {
            return null;
        }
        this.busy[pageNumber] = true;
        PDFPage page = this.file.getPage(pageNumber + 1, true);
        if (!this.done[pageNumber]) {
            System.out.println("Loading page " + (pageNumber + 1));
        }
        this.done[pageNumber] = true;
        this.busy[pageNumber] = false;
        return page;
    }

    @Override
    public void doTask() {
        for (int i = 0; i < this.numberOfPages; ++i) {
            this.loadPage(i + 1);
        }
    }
}

