/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.rups.model;

import com.lowagie.rups.model.IndirectObjectFactory;
import com.lowagie.rups.view.itext.treenodes.PdfObjectTreeNode;
import com.lowagie.rups.view.itext.treenodes.PdfPagesTreeNode;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNull;
import com.lowagie.text.pdf.PdfObject;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.tree.TreeNode;

public class TreeNodeFactory {
    protected IndirectObjectFactory objects;
    protected ArrayList<PdfObjectTreeNode> nodes = new ArrayList();

    public TreeNodeFactory(IndirectObjectFactory objects) {
        this.objects = objects;
        for (int i = 0; i < objects.size(); ++i) {
            int ref = objects.getRefByIndex(i);
            this.nodes.add(PdfObjectTreeNode.getInstance((PdfObject)PdfNull.PDFNULL, ref));
        }
    }

    public PdfObjectTreeNode getNode(int ref) {
        int idx = this.objects.getIndexByRef(ref);
        PdfObjectTreeNode node = this.nodes.get(idx);
        if (node.getPdfObject().isNull()) {
            node = PdfObjectTreeNode.getInstance(this.objects.loadObjectByReference(ref), ref);
            this.nodes.set(idx, node);
        }
        return node;
    }

    public void expandNode(PdfObjectTreeNode node) {
        if (node.getChildCount() > 0) {
            return;
        }
        PdfObject object = node.getPdfObject();
        switch (object.type()) {
            case 10: {
                PdfIndirectReference ref = (PdfIndirectReference)object;
                PdfObjectTreeNode leaf = this.getNode(ref.getNumber());
                this.addNodes(node, leaf);
                if (leaf instanceof PdfPagesTreeNode) {
                    this.expandNode(leaf);
                }
                return;
            }
            case 5: {
                PdfArray array = (PdfArray)object;
                ListIterator it = array.listIterator();
                while (it.hasNext()) {
                    PdfObjectTreeNode leaf = PdfObjectTreeNode.getInstance((PdfObject)it.next());
                    this.addNodes(node, leaf);
                    this.expandNode(leaf);
                }
                return;
            }
            case 6: 
            case 7: {
                PdfDictionary dict = (PdfDictionary)object;
                Iterator it = dict.getKeys().iterator();
                while (it.hasNext()) {
                    PdfObjectTreeNode leaf = PdfObjectTreeNode.getInstance(dict, (PdfName)it.next());
                    this.addNodes(node, leaf);
                    this.expandNode(leaf);
                }
                return;
            }
        }
    }

    public PdfObjectTreeNode getChildNode(PdfObjectTreeNode node, PdfName key) {
        Enumeration<TreeNode> children = node.breadthFirstEnumeration();
        while (children.hasMoreElements()) {
            PdfObjectTreeNode child = (PdfObjectTreeNode)children.nextElement();
            if (!child.isDictionaryNode(key)) continue;
            if (child.isIndirectReference()) {
                this.expandNode(child);
                child = (PdfObjectTreeNode)child.getFirstChild();
            }
            this.expandNode(child);
            return child;
        }
        return null;
    }

    private void addNodes(PdfObjectTreeNode parent, PdfObjectTreeNode child) {
        try {
            parent.add(child);
        }
        catch (IllegalArgumentException iae) {
            parent.setRecursive(true);
        }
    }
}

